/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.method;

import org.fest.reflect.method.Invoker;
import org.fest.reflect.method.StaticMethodParameterTypes;

public class StaticMethodReturnType<T> {
    private final String name;

    static <T> StaticMethodReturnType<T> newReturnType(String name, Class<T> type) {
        if (type == null) {
            throw new NullPointerException("The return type of the static method to access should not be null");
        }
        return new StaticMethodReturnType<T>(name);
    }

    private StaticMethodReturnType(String name) {
        this.name = name;
    }

    public Invoker<T> in(Class<?> target) {
        return Invoker.newInvoker(this.name, target, new Class[0]);
    }

    public StaticMethodParameterTypes<T> withParameterTypes(Class<?> ... parameterTypes) {
        return StaticMethodParameterTypes.newParameterTypes(this.name, parameterTypes);
    }
}

