/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.beanproperty;

import org.fest.reflect.beanproperty.Invoker;
import org.fest.reflect.reference.TypeRef;

public class PropertyTypeRef<T> {
    private final TypeRef<T> type;
    private final String name;

    static <T> PropertyTypeRef<T> newPropertyTypeRef(String name, TypeRef<T> type) {
        if (type == null) {
            throw new NullPointerException("The type reference of the property to access should not be null");
        }
        return new PropertyTypeRef<T>(name, type);
    }

    private PropertyTypeRef(String name, TypeRef<T> type) {
        this.name = name;
        this.type = type;
    }

    public Invoker<T> in(Object target) {
        return Invoker.newInvoker(this.name, this.type, target);
    }
}

