/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.beanproperty;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import org.fest.reflect.exception.ReflectionError;
import org.fest.reflect.reference.TypeRef;
import org.fest.util.Strings;

public final class Invoker<T> {
    private final String propertyName;
    private final Object target;
    private final PropertyDescriptor descriptor;

    static <T> Invoker<T> newInvoker(String name, TypeRef<T> expectedType, Object target) {
        return Invoker.createInvoker(name, expectedType.rawType(), target);
    }

    static <T> Invoker<T> newInvoker(String name, Class<T> expectedType, Object target) {
        return Invoker.createInvoker(name, expectedType, target);
    }

    private static <T> Invoker<T> createInvoker(String name, Class<?> expectedType, Object target) {
        PropertyDescriptor descriptor = Invoker.descriptorForProperty(name, target);
        Invoker.verifyCorrectType(name, target, expectedType, descriptor);
        return new Invoker<T>(name, target, descriptor);
    }

    private static PropertyDescriptor descriptorForProperty(String propertyName, Object target) {
        BeanInfo beanInfo = null;
        Class<?> type = target.getClass();
        try {
            beanInfo = Introspector.getBeanInfo(type);
        }
        catch (Exception e) {
            throw new ReflectionError(Strings.concat((Object[])new Object[]{"Unable to get BeanInfo for type ", type.getName()}), e);
        }
        for (PropertyDescriptor d : beanInfo.getPropertyDescriptors()) {
            if (!propertyName.equals(d.getName())) continue;
            return d;
        }
        throw new ReflectionError(Strings.concat((Object[])new Object[]{"Unable to find property ", Strings.quote((String)propertyName), " in ", type.getName()}));
    }

    static void verifyCorrectType(String name, Object target, Class<?> expectedType, PropertyDescriptor descriptor) {
        Class<?> actualType = descriptor.getPropertyType();
        if (!expectedType.isAssignableFrom(actualType)) {
            throw Invoker.incorrectPropertyType(name, target, actualType, expectedType);
        }
    }

    private static ReflectionError incorrectPropertyType(String name, Object target, Class<?> actual, Class<?> expected) {
        String typeName = target.getClass().getName();
        String msg = Strings.concat((Object[])new Object[]{"The type of the property ", Strings.quote((String)name), " in ", typeName, " should be <", expected.getName(), "> but was <", actual.getName(), ">"});
        throw new ReflectionError(msg);
    }

    private Invoker(String propertyName, Object target, PropertyDescriptor descriptor) {
        this.propertyName = propertyName;
        this.target = target;
        this.descriptor = descriptor;
    }

    public void set(T value) {
        try {
            this.descriptor.getWriteMethod().invoke(this.target, value);
        }
        catch (Exception e) {
            throw new ReflectionError(Strings.concat((Object[])new Object[]{"Unable to update the value in property ", Strings.quote((String)this.propertyName)}), e);
        }
    }

    public T get() {
        try {
            return (T)this.descriptor.getReadMethod().invoke(this.target, new Object[0]);
        }
        catch (Exception e) {
            throw new ReflectionError(Strings.concat((Object[])new Object[]{"Unable to obtain the value in property " + Strings.quote((String)this.propertyName)}), e);
        }
    }

    public PropertyDescriptor info() {
        return this.descriptor;
    }
}

