/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.compiler;

import edu.emory.mathcs.backport.java.util.concurrent.ArrayBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.SourceDependencyAnalyzer;
import org.codehaus.mojo.natives.compiler.Compiler;
import org.codehaus.mojo.natives.compiler.CompilerConfiguration;
import org.codehaus.mojo.natives.parser.Parser;
import org.codehaus.mojo.natives.util.CommandLineUtil;
import org.codehaus.mojo.natives.util.EnvUtil;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.Commandline;

public abstract class AbstractCompiler
extends AbstractLogEnabled
implements Compiler {
    protected abstract Parser getParser();

    protected abstract Commandline getCommandLine(File var1, File var2, CompilerConfiguration var3) throws NativeBuildException;

    public List compile(CompilerConfiguration config, File[] sourceFiles) throws NativeBuildException {
        if (!config.getOutputDirectory().exists()) {
            config.getOutputDirectory().mkdirs();
        }
        ArrayList<File> compilerOutputFiles = new ArrayList<File>(sourceFiles.length);
        CompilerThreadPoolExecutor compilerThreadPoolExecutor = null;
        if (config.getNumberOfConcurrentCompilation() > 1) {
            compilerThreadPoolExecutor = new CompilerThreadPoolExecutor(config.getNumberOfConcurrentCompilation());
        }
        for (int i = 0; i < sourceFiles.length; ++i) {
            File source = sourceFiles[i];
            File objectFile = AbstractCompiler.getObjectFile(source, config.getOutputDirectory(), config.getObjectFileExtension());
            compilerOutputFiles.add(objectFile);
            Parser parser = this.getParser();
            if (SourceDependencyAnalyzer.isStaled(source, objectFile, parser, config.getIncludePaths())) {
                if (compilerThreadPoolExecutor != null && compilerThreadPoolExecutor.isErrorFound()) break;
                Commandline cl = this.getCommandLine(source, objectFile, config);
                EnvUtil.setupCommandlineEnv(cl, config.getEnvFactory());
                if (compilerThreadPoolExecutor != null) {
                    try {
                        compilerThreadPoolExecutor.execute(new CompilerRunnable(cl, this.getLogger()));
                    }
                    catch (RejectedExecutionException e) {
                        CommandLineUtil.execute(cl, this.getLogger());
                    }
                    continue;
                }
                CommandLineUtil.execute(cl, this.getLogger());
                continue;
            }
            this.getLogger().debug(objectFile + " is up to date.");
        }
        if (compilerThreadPoolExecutor != null) {
            if (!compilerThreadPoolExecutor.isErrorFound()) {
                compilerThreadPoolExecutor.shutdown();
            }
            try {
                compilerThreadPoolExecutor.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (compilerThreadPoolExecutor.isErrorFound()) {
                throw new NativeBuildException("Compilation failure detected.");
            }
        }
        return compilerOutputFiles;
    }

    protected static String getObjectFileExtension(String fileExtension) {
        if (fileExtension != null) {
            return fileExtension;
        }
        if (Os.isFamily((String)"windows")) {
            return "obj";
        }
        return "o";
    }

    protected static File getObjectFile(File sourceFile, File outputDirectory, String objectFileExtension) throws NativeBuildException {
        String objectFileName;
        try {
            objectFileExtension = AbstractCompiler.getObjectFileExtension(objectFileExtension);
            objectFileName = FileUtils.basename((String)sourceFile.getCanonicalPath());
            objectFileName = objectFileName.charAt(objectFileName.length() - 1) != '.' ? objectFileName + "." + objectFileExtension : objectFileName + objectFileExtension;
        }
        catch (IOException e) {
            throw new NativeBuildException("Failed to figure out object file name for " + sourceFile + ": " + e.getMessage(), e);
        }
        File objectFile = new File(outputDirectory, objectFileName);
        return objectFile;
    }

    public class CompilerRunnable
    implements Runnable {
        private Commandline cl;
        private Logger logger;
        private boolean skip = false;

        public void setSkip(boolean skip) {
            this.skip = skip;
        }

        public CompilerRunnable(Commandline cl, Logger logger) {
            this.cl = cl;
            this.logger = logger;
        }

        public void run() throws NativeBuildException {
            if (this.skip) {
                return;
            }
            CommandLineUtil.execute(this.cl, this.logger);
        }
    }

    private class CompilerThreadPoolExecutor
    extends ThreadPoolExecutor {
        private boolean errorFound;

        public synchronized void setErrorFound(boolean errorFound) {
            this.errorFound = errorFound;
        }

        public synchronized boolean isErrorFound() {
            return this.errorFound;
        }

        public CompilerThreadPoolExecutor(int corePoolSize) {
            super(corePoolSize, corePoolSize, 30L, TimeUnit.SECONDS, (BlockingQueue)new ArrayBlockingQueue(corePoolSize * 2));
            this.errorFound = false;
        }

        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            if (t != null) {
                this.setErrorFound(true);
                this.shutdown();
            }
        }

        protected void beforeExecute(Thread t, Runnable r) {
            super.beforeExecute(t, r);
            if (this.isErrorFound()) {
                ((CompilerRunnable)r).setSkip(true);
            }
        }
    }
}

