/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildhelper;

import java.util.Properties;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.buildhelper.OsgiArtifactVersion;

public class ParseVersionMojo
extends AbstractMojo {
    private MavenProject project;
    private String versionString;
    private String propertyPrefix;

    public void execute() throws MojoExecutionException {
        this.parseVersion(this.versionString, this.project.getProperties());
    }

    public void parseVersion(String version, Properties props) {
        Object artifactVersion = new DefaultArtifactVersion(version);
        if (artifactVersion.getQualifier() != null && artifactVersion.getQualifier().equals(version)) {
            this.getLog().debug((CharSequence)"The version is not in the regular format, will try OSGi format instead");
            artifactVersion = new OsgiArtifactVersion(version);
        }
        props.setProperty(this.propertyPrefix + ".majorVersion", Integer.toString(artifactVersion.getMajorVersion()));
        props.setProperty(this.propertyPrefix + ".minorVersion", Integer.toString(artifactVersion.getMinorVersion()));
        props.setProperty(this.propertyPrefix + ".incrementalVersion", Integer.toString(artifactVersion.getIncrementalVersion()));
        String qualifier = artifactVersion.getQualifier();
        if (qualifier == null) {
            qualifier = "";
        }
        props.setProperty(this.propertyPrefix + ".qualifier", qualifier);
        props.setProperty(this.propertyPrefix + ".buildNumber", Integer.toString(artifactVersion.getBuildNumber()));
        String osgiVersion = this.getOsgiVersion((ArtifactVersion)artifactVersion);
        props.setProperty(this.propertyPrefix + ".osgiVersion", osgiVersion);
    }

    public void setPropertyPrefix(String prefix) {
        this.propertyPrefix = prefix;
    }

    public String getOsgiVersion(ArtifactVersion version) {
        if (version.toString().equals(version.getQualifier())) {
            return version.toString();
        }
        StringBuffer osgiVersion = new StringBuffer();
        osgiVersion.append(version.getMajorVersion());
        osgiVersion.append("." + version.getMinorVersion());
        osgiVersion.append("." + version.getIncrementalVersion());
        if (version.getQualifier() != null || version.getBuildNumber() != 0) {
            osgiVersion.append(".");
        }
        if (version.getQualifier() != null) {
            osgiVersion.append(version.getQualifier());
        }
        if (version.getBuildNumber() != 0) {
            osgiVersion.append(version.getBuildNumber());
        }
        return osgiVersion.toString();
    }
}

