/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.mojo;

import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.gmavenplus.model.Version;
import org.codehaus.gmavenplus.util.ClassWrangler;

public abstract class AbstractGroovyMojo
extends AbstractMojo {
    protected static final String GROOVY_SOURCES_PATTERN = "**" + File.separator + "*.groovy";
    protected static final String JAVA_SOURCES_PATTERN = "**" + File.separator + "*.java";
    protected static final Version JAVA_1_7 = new Version(1, 7);
    protected static final Version GROOVY_1_5_0 = new Version(1, 5, 0);
    protected ClassWrangler classWrangler;
    protected MavenProject project;
    protected MavenSession session;
    protected List<Artifact> pluginArtifacts;
    protected MojoExecution mojoExecution;
    protected Version minGroovyVersion = GROOVY_1_5_0;
    protected boolean skipTests;

    protected void logPluginClasspath() {
        if (this.getLog().isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (Artifact artifact : this.pluginArtifacts) {
                sb.append(artifact.getFile());
            }
            this.getLog().debug((CharSequence)("Plugin classpath:\n" + sb.toString()));
        }
    }

    protected boolean isJavaSupportIndy() {
        return this.getJavaVersion().compareTo(JAVA_1_7, false) >= 0;
    }

    protected Version getJavaVersion() {
        return Version.parseFromString(this.getJavaVersionString());
    }

    protected String getJavaVersionString() {
        return System.getProperty("java.version");
    }

    protected boolean groovyVersionSupportsAction() {
        return this.classWrangler.getGroovyVersion() != null && this.classWrangler.getGroovyVersion().compareTo(this.minGroovyVersion) >= 0;
    }
}

