/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.test.dag;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.test.TestInput;
import org.apache.tez.test.TestOutput;
import org.apache.tez.test.TestProcessor;

public class TwoLevelsFailingDAG {
    static Resource defaultResource = Resource.newInstance((int)100, (int)0);
    protected static DAG dag;
    protected static byte[] payload;
    protected static Vertex l1v1;
    protected static Vertex l1v2;
    protected static Vertex l1v3;
    protected static Vertex l1v4;
    protected static Vertex l2v1;
    protected static Vertex l2v2;
    protected static Vertex l2v3;
    protected static Vertex l2v4;

    public static DAG createDAG(String name, Configuration conf) throws Exception {
        if (conf != null) {
            payload = TezUtils.createUserPayloadFromConf((Configuration)conf);
        }
        dag = new DAG(name);
        TwoLevelsFailingDAG.addDAGVerticesAndEdges();
        return dag;
    }

    protected static void addDAGVerticesAndEdges() {
        l1v1 = new Vertex("l1v1", TestProcessor.getProcDesc(payload), 1, defaultResource);
        l2v1 = new Vertex("l2v1", TestProcessor.getProcDesc(payload), 1, defaultResource);
        TwoLevelsFailingDAG.addVerticesAndEdgeInternal(l1v1, l2v1, EdgeProperty.DataMovementType.SCATTER_GATHER);
        l1v2 = new Vertex("l1v2", TestProcessor.getProcDesc(payload), 2, defaultResource);
        l2v2 = new Vertex("l2v2", TestProcessor.getProcDesc(payload), 3, defaultResource);
        TwoLevelsFailingDAG.addVerticesAndEdgeInternal(l1v2, l2v2, EdgeProperty.DataMovementType.SCATTER_GATHER);
        l1v3 = new Vertex("l1v3", TestProcessor.getProcDesc(payload), 3, defaultResource);
        l2v3 = new Vertex("l2v3", TestProcessor.getProcDesc(payload), 2, defaultResource);
        TwoLevelsFailingDAG.addVerticesAndEdgeInternal(l1v3, l2v3, EdgeProperty.DataMovementType.SCATTER_GATHER);
        l1v4 = new Vertex("l1v4", TestProcessor.getProcDesc(payload), 2, defaultResource);
        l2v4 = new Vertex("l2v4", TestProcessor.getProcDesc(payload), 3, defaultResource);
        TwoLevelsFailingDAG.addVerticesAndEdgeInternal(l1v4, l2v4, EdgeProperty.DataMovementType.BROADCAST);
    }

    protected static void addVerticesAndEdgeInternal(Vertex v1, Vertex v2, EdgeProperty.DataMovementType dataMovementType) {
        dag.addVertex(v1).addVertex(v2);
        TwoLevelsFailingDAG.addEdge(v1, v2, dataMovementType);
    }

    protected static void addEdge(Vertex v1, Vertex v2, EdgeProperty.DataMovementType dataMovementType) {
        dag.addEdge(new Edge(v1, v2, new EdgeProperty(dataMovementType, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, TestOutput.getOutputDesc(payload), TestInput.getInputDesc(payload))));
    }

    public static DAG createDAG(Configuration conf) throws Exception {
        return TwoLevelsFailingDAG.createDAG("TwoLevelsFailingDAG", conf);
    }
}

