/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.test;

import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.TezOutputContext;
import org.apache.tez.runtime.api.Writer;
import org.apache.tez.runtime.api.events.DataMovementEvent;

public class TestOutput
implements LogicalOutput {
    private static final Log LOG = LogFactory.getLog(TestOutput.class);
    int output;
    int numOutputs;
    TezOutputContext outputContext;

    public static OutputDescriptor getOutputDesc(byte[] payload) {
        return new OutputDescriptor(TestOutput.class.getName()).setUserPayload(payload);
    }

    public List<Event> initialize(TezOutputContext outputContext) throws Exception {
        this.outputContext = outputContext;
        this.outputContext.requestInitialMemory(0L, null);
        return Collections.emptyList();
    }

    void write(int value) {
        this.output = value;
    }

    public void start() {
    }

    public Writer getWriter() throws Exception {
        return null;
    }

    public void handleEvents(List<Event> outputEvents) {
    }

    public List<Event> close() throws Exception {
        LOG.info((Object)("Sending data movement event with value: " + this.output));
        byte[] result = ByteBuffer.allocate(4).putInt(this.output).array();
        ArrayList events = Lists.newArrayListWithCapacity((int)this.numOutputs);
        for (int i = 0; i < this.numOutputs; ++i) {
            DataMovementEvent event = new DataMovementEvent(i, result);
            events.add(event);
        }
        return events;
    }

    public void setNumPhysicalOutputs(int numOutputs) {
        this.numOutputs = numOutputs;
    }
}

