/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.test;

import java.io.IOException;
import java.util.HashMap;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.tez.client.AMConfiguration;
import org.apache.tez.client.TezClientUtils;
import org.apache.tez.client.TezSession;
import org.apache.tez.client.TezSessionConfiguration;
import org.apache.tez.client.TezSessionStatus;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.test.MiniTezCluster;
import org.apache.tez.test.SimpleTestDAG;
import org.apache.tez.test.SimpleTestDAG3Vertices;
import org.apache.tez.test.TestInput;
import org.apache.tez.test.TestOutput;
import org.apache.tez.test.TestProcessor;
import org.apache.tez.test.dag.SimpleReverseVTestDAG;
import org.apache.tez.test.dag.SimpleVTestDAG;
import org.apache.tez.test.dag.SixLevelsFailingDAG;
import org.apache.tez.test.dag.ThreeLevelsFailingDAG;
import org.apache.tez.test.dag.TwoLevelsFailingDAG;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestFaultTolerance {
    private static final Log LOG = LogFactory.getLog(TestFaultTolerance.class);
    private static Configuration conf = new Configuration();
    private static MiniTezCluster miniTezCluster;
    private static String TEST_ROOT_DIR;
    protected static MiniDFSCluster dfsCluster;
    private static TezSession tezSession;

    @BeforeClass
    public static void setup() throws Exception {
        LOG.info((Object)"Starting mini clusters");
        DistributedFileSystem remoteFs = null;
        try {
            conf.set("hdfs.minidfs.basedir", TEST_ROOT_DIR);
            dfsCluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(true).racks(null).build();
            remoteFs = dfsCluster.getFileSystem();
        }
        catch (IOException io) {
            throw new RuntimeException("problem starting mini dfs cluster", io);
        }
        if (miniTezCluster == null) {
            miniTezCluster = new MiniTezCluster(TestFaultTolerance.class.getName(), 4, 1, 1);
            Configuration miniTezconf = new Configuration(conf);
            miniTezconf.set("fs.defaultFS", remoteFs.getUri().toString());
            miniTezCluster.init(miniTezconf);
            miniTezCluster.start();
            Path remoteStagingDir = remoteFs.makeQualified(new Path(TEST_ROOT_DIR, String.valueOf(new Random().nextInt(100000))));
            TezClientUtils.ensureStagingDirExists((Configuration)conf, (Path)remoteStagingDir);
            TezConfiguration tezConf = new TezConfiguration(miniTezCluster.getConfig());
            tezConf.set("tez.staging-dir", remoteStagingDir.toString());
            tezConf.setBoolean("tez.am.node-blacklisting.enabled", false);
            AMConfiguration amConfig = new AMConfiguration(new HashMap(), new HashMap(), tezConf, null);
            TezSessionConfiguration tezSessionConfig = new TezSessionConfiguration(amConfig, tezConf);
            tezSession = new TezSession("TestFaultTolerance", tezSessionConfig);
            tezSession.start();
        }
    }

    @AfterClass
    public static void tearDown() throws Exception {
        LOG.info((Object)"Stopping mini clusters");
        if (tezSession != null) {
            tezSession.stop();
        }
        if (miniTezCluster != null) {
            miniTezCluster.stop();
            miniTezCluster = null;
        }
        if (dfsCluster != null) {
            dfsCluster.shutdown();
            dfsCluster = null;
        }
    }

    void runDAGAndVerify(DAG dag, DAGStatus.State finalState) throws Exception {
        TezSessionStatus status = tezSession.getSessionStatus();
        while (status != TezSessionStatus.READY && status != TezSessionStatus.SHUTDOWN) {
            LOG.info((Object)("Waiting for session to be ready. Current: " + status));
            Thread.sleep(100L);
            status = tezSession.getSessionStatus();
        }
        if (status == TezSessionStatus.SHUTDOWN) {
            throw new TezUncheckedException("Unexpected Session shutdown");
        }
        DAGClient dagClient = tezSession.submitDAG(dag);
        DAGStatus dagStatus = dagClient.getDAGStatus(null);
        while (!dagStatus.isCompleted()) {
            LOG.info((Object)("Waiting for dag to complete. Sleeping for 500ms. DAG name: " + dag.getName() + " DAG appId: " + dagClient.getApplicationId() + " Current state: " + dagStatus.getState()));
            Thread.sleep(100L);
            dagStatus = dagClient.getDAGStatus(null);
        }
        Assert.assertEquals((Object)finalState, (Object)dagStatus.getState());
    }

    @Test(timeout=60000L)
    public void testBasicSuccessScatterGather() throws Exception {
        DAG dag = SimpleTestDAG.createDAG("testBasicSuccessScatterGather", null);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testBasicSuccessBroadcast() throws Exception {
        DAG dag = new DAG("testBasicSuccessBroadcast");
        Vertex v1 = new Vertex("v1", TestProcessor.getProcDesc(null), 2, SimpleTestDAG.defaultResource);
        Vertex v2 = new Vertex("v2", TestProcessor.getProcDesc(null), 2, SimpleTestDAG.defaultResource);
        dag.addVertex(v1).addVertex(v2).addEdge(new Edge(v1, v2, new EdgeProperty(EdgeProperty.DataMovementType.BROADCAST, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, TestOutput.getOutputDesc(null), TestInput.getInputDesc(null))));
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testBasicTaskFailure() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setBoolean(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_DO_FAIL, "v1"), true);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_TASK_INDEX, "v1"), "0");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_UPTO_TASK_ATTEMPT, "v1"), 0);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_TASK_INDEX, "v2"), "1");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v2", 1), 4);
        DAG dag = SimpleTestDAG.createDAG("testBasicTaskFailure", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testTaskMultipleFailures() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setBoolean(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_DO_FAIL, "v1"), true);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_TASK_INDEX, "v1"), "0,1");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_UPTO_TASK_ATTEMPT, "v1"), 1);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_TASK_INDEX, "v2"), "0");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v2", 0), 7);
        DAG dag = SimpleTestDAG.createDAG("testTaskMultipleFailures", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testTaskMultipleFailuresDAGFail() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setBoolean(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_DO_FAIL, "v1"), true);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_TASK_INDEX, "v1"), "0");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_UPTO_TASK_ATTEMPT, "v1"), -1);
        DAG dag = SimpleTestDAG.createDAG("testTaskMultipleFailuresDAGFail", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.FAILED);
    }

    @Test(timeout=60000L)
    public void testBasicInputFailureWithExit() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL, "v2"), true);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL_AND_EXIT, "v2"), true);
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_INDEX, "v2"), "1");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, "v2"), "0");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, "v2"), "0");
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_TASK_INDEX, "v2"), "0,1");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v2", 1), 5);
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v2", 0), 3);
        DAG dag = SimpleTestDAG.createDAG("testBasicInputFailureWithExit", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testBasicInputFailureWithoutExit() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL, "v2"), true);
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_INDEX, "v2"), "1");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, "v2"), "0");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, "v2"), "0");
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_TASK_INDEX, "v2"), "0,1");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v2", 1), 4);
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v2", 0), 3);
        DAG dag = SimpleTestDAG.createDAG("testBasicInputFailureWithoutExit", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testMultipleInputFailureWithoutExit() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL, "v2"), true);
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_INDEX, "v2"), "0,1");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, "v2"), "0");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, "v2"), "-1");
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_TASK_INDEX, "v2"), "0,1");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v2", 0), 5);
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v2", 1), 5);
        DAG dag = SimpleTestDAG.createDAG("testMultipleInputFailureWithoutExit", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testMultiVersionInputFailureWithoutExit() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL, "v2"), true);
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_INDEX, "v2"), "1");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, "v2"), "0");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, "v2"), "0");
        testConf.setInt(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_UPTO_INPUT_ATTEMPT, "v2"), 1);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_TASK_INDEX, "v2"), "0,1");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v2", 1), 5);
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v2", 0), 3);
        DAG dag = SimpleTestDAG.createDAG("testMultiVersionInputFailureWithoutExit", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testTwoLevelsFailingDAGSuccess() throws Exception {
        Configuration testConf = new Configuration();
        DAG dag = TwoLevelsFailingDAG.createDAG("testTwoLevelsFailingDAGSuccess", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testThreeLevelsFailingDAGSuccess() throws Exception {
        Configuration testConf = new Configuration();
        DAG dag = ThreeLevelsFailingDAG.createDAG("testThreeLevelsFailingDAGSuccess", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testSixLevelsFailingDAGSuccess() throws Exception {
        Configuration testConf = new Configuration();
        DAG dag = SixLevelsFailingDAG.createDAG("testSixLevelsFailingDAGSuccess", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testThreeLevelsFailingDAG2VerticesHaveFailedAttemptsDAGSucceeds() throws Exception {
        Configuration testConf = new Configuration();
        testConf.setInt("tez.am.max.task.attempts", 4);
        testConf.setBoolean(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_DO_FAIL, "l2v1"), true);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_TASK_INDEX, "l2v1"), "1");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_UPTO_TASK_ATTEMPT, "l2v1"), 2);
        testConf.setBoolean(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_DO_FAIL, "l3v1"), true);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_TASK_INDEX, "l3v1"), "0");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_UPTO_TASK_ATTEMPT, "l3v1"), 2);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_TASK_INDEX, "l3v1"), "0");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "l3v1", 0), 15);
        DAG dag = ThreeLevelsFailingDAG.createDAG("testThreeLevelsFailingDAG2VerticesHaveFailedAttemptsDAGSucceeds", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testInputFailureCausesRerunAttemptWithinMaxAttemptSuccess() throws Exception {
        Configuration testConf = new Configuration();
        testConf.setBoolean(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_DO_FAIL, "v1"), true);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_TASK_INDEX, "v1"), "1");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_UPTO_TASK_ATTEMPT, "v1"), 0);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL, "v2"), true);
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_INDEX, "v2"), "0");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, "v2"), "0");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, "v2"), "1");
        testConf.setInt(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_UPTO_INPUT_ATTEMPT, "v2"), 1);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_TASK_INDEX, "v2"), "0,1");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v2", 0), 5);
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v2", 1), 4);
        DAG dag = SimpleTestDAG.createDAG("testInputFailureCausesRerunAttemptWithinMaxAttemptSuccess", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    private void setCascadingInputFailureConfig(Configuration testConf, boolean failAndExit) {
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL, "v2"), true);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL_AND_EXIT, "v2"), failAndExit);
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_INDEX, "v2"), "0");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, "v2"), "1");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, "v2"), "0");
        testConf.setInt(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_UPTO_INPUT_ATTEMPT, "v2"), 0);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL, "v3"), true);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL_AND_EXIT, "v3"), failAndExit);
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_INDEX, "v3"), "-1");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, "v3"), "0");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, "v3"), "0");
        testConf.setInt(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_UPTO_INPUT_ATTEMPT, "v3"), 0);
    }

    @Test(timeout=60000L)
    public void testCascadingInputFailureWithoutExitSuccess() throws Exception {
        Configuration testConf = new Configuration(false);
        this.setCascadingInputFailureConfig(testConf, false);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_TASK_INDEX, "v3"), "0,1");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v3", 0), 9);
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v3", 1), 9);
        DAG dag = SimpleTestDAG3Vertices.createDAG("testCascadingInputFailureWithoutExitSuccess", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testCascadingInputFailureWithExitSuccess() throws Exception {
        Configuration testConf = new Configuration(false);
        this.setCascadingInputFailureConfig(testConf, true);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_TASK_INDEX, "v3"), "0,1");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v3", 0), 11);
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v3", 1), 11);
        DAG dag = SimpleTestDAG3Vertices.createDAG("testCascadingInputFailureWithExitSuccess", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testInputFailureCausesRerunOfTwoVerticesWithoutExit() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL, "v3"), true);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL_AND_EXIT, "v3"), false);
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_INDEX, "v3"), "0,1");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, "v3"), "0");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, "v3"), "-1");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_UPTO_INPUT_ATTEMPT, "v3"), "1");
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_TASK_INDEX, "v3"), "0");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v3", 0), 13);
        DAG dag = SimpleVTestDAG.createDAG("testInputFailureCausesRerunOfTwoVerticesWithoutExit", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testAttemptOfDownstreamVertexConnectedWithTwoUpstreamVerticesFailure() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setBoolean(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_DO_FAIL, "v3"), true);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_TASK_INDEX, "v3"), "0,1");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_UPTO_TASK_ATTEMPT, "v3"), 1);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_TASK_INDEX, "v3"), "0,1");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v3", 0), 7);
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v3", 1), 7);
        DAG dag = SimpleVTestDAG.createDAG("testAttemptOfDownstreamVertexConnectedWithTwoUpstreamVerticesFailure", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testInputFailureRerunCanSendOutputToTwoDownstreamVertices() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL, "v2"), true);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL_AND_EXIT, "v2"), false);
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_INDEX, "v2"), "-1");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, "v2"), "0");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, "v2"), "-1");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_UPTO_INPUT_ATTEMPT, "v2"), "0");
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL, "v3"), true);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL_AND_EXIT, "v3"), false);
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_INDEX, "v3"), "-1");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, "v3"), "0");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, "v3"), "-1");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_UPTO_INPUT_ATTEMPT, "v3"), "0");
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_TASK_INDEX, "v2"), "0");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v2", 0), 5);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_TASK_INDEX, "v3"), "0");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v3", 0), 5);
        DAG dag = SimpleReverseVTestDAG.createDAG("testInputFailureRerunCanSendOutputToTwoDownstreamVertices", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=60000L)
    public void testTwoTasksHaveInputFailuresSuccess() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL, "v2"), true);
        testConf.setBoolean(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_DO_FAIL_AND_EXIT, "v2"), false);
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_INDEX, "v2"), "0,1");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, "v2"), "0");
        testConf.set(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, "v2"), "0");
        testConf.setInt(TestInput.getVertexConfName(TestInput.TEZ_FAILING_INPUT_FAILING_UPTO_INPUT_ATTEMPT, "v2"), 1);
        testConf.set(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_TASK_INDEX, "v2"), "0,1");
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v2", 0), 5);
        testConf.setInt(TestProcessor.getVertexConfName(TestProcessor.TEZ_FAILING_PROCESSOR_VERIFY_VALUE, "v2", 1), 5);
        DAG dag = SimpleTestDAG.createDAG("testTwoTasksHaveInputFailuresSuccess", testConf);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    static {
        TEST_ROOT_DIR = "target/" + TestFaultTolerance.class.getName() + "-tmpDir";
        tezSession = null;
    }
}

