/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.test;

import java.io.IOException;
import java.util.HashMap;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.tez.client.AMConfiguration;
import org.apache.tez.client.TezClientUtils;
import org.apache.tez.client.TezSession;
import org.apache.tez.client.TezSessionConfiguration;
import org.apache.tez.client.TezSessionStatus;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.test.MiniTezCluster;
import org.apache.tez.test.dag.MultiAttemptDAG;
import org.apache.tez.test.dag.SimpleVTestDAG;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestDAGRecovery2 {
    private static final Log LOG = LogFactory.getLog(TestDAGRecovery2.class);
    private static Configuration conf = new Configuration();
    private static MiniTezCluster miniTezCluster;
    private static String TEST_ROOT_DIR;
    protected static MiniDFSCluster dfsCluster;
    private static TezSession tezSession;

    @BeforeClass
    public static void setup() throws Exception {
        LOG.info((Object)"Starting mini clusters");
        DistributedFileSystem remoteFs = null;
        try {
            conf.set("hdfs.minidfs.basedir", TEST_ROOT_DIR);
            dfsCluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).format(true).racks(null).build();
            remoteFs = dfsCluster.getFileSystem();
        }
        catch (IOException io) {
            throw new RuntimeException("problem starting mini dfs cluster", io);
        }
        if (miniTezCluster == null) {
            miniTezCluster = new MiniTezCluster(TestDAGRecovery2.class.getName(), 1, 1, 1);
            Configuration miniTezconf = new Configuration(conf);
            miniTezconf.setInt("yarn.resourcemanager.am.max-attempts", 4);
            miniTezconf.set("fs.defaultFS", remoteFs.getUri().toString());
            miniTezCluster.init(miniTezconf);
            miniTezCluster.start();
            Path remoteStagingDir = remoteFs.makeQualified(new Path(TEST_ROOT_DIR, String.valueOf(new Random().nextInt(100000))));
            TezClientUtils.ensureStagingDirExists((Configuration)conf, (Path)remoteStagingDir);
            TezConfiguration tezConf = new TezConfiguration(miniTezCluster.getConfig());
            tezConf.setInt("tez.dag.recovery.max.unflushed.events", 10);
            tezConf.set("tez.am.log.level", "DEBUG");
            tezConf.set("tez.staging-dir", remoteStagingDir.toString());
            tezConf.setBoolean("tez.am.node-blacklisting.enabled", false);
            tezConf.setInt("tez.am.max.app.attempts", 4);
            tezConf.setInt("tez.am.resource.memory.mb", 500);
            tezConf.set("tez.am.java.opts", " -Xmx256m");
            AMConfiguration amConfig = new AMConfiguration(new HashMap(), new HashMap(), tezConf, null);
            TezSessionConfiguration tezSessionConfig = new TezSessionConfiguration(amConfig, tezConf);
            tezSession = new TezSession("TestDAGRecovery2", tezSessionConfig);
            tezSession.start();
        }
    }

    void runDAGAndVerify(DAG dag, DAGStatus.State finalState) throws Exception {
        TezSessionStatus status = tezSession.getSessionStatus();
        while (status != TezSessionStatus.READY && status != TezSessionStatus.SHUTDOWN) {
            LOG.info((Object)("Waiting for session to be ready. Current: " + status));
            Thread.sleep(100L);
            status = tezSession.getSessionStatus();
        }
        if (status == TezSessionStatus.SHUTDOWN) {
            throw new TezUncheckedException("Unexpected Session shutdown");
        }
        DAGClient dagClient = tezSession.submitDAG(dag);
        DAGStatus dagStatus = dagClient.getDAGStatus(null);
        while (!dagStatus.isCompleted()) {
            LOG.info((Object)("Waiting for dag to complete. Sleeping for 500ms. DAG name: " + dag.getName() + " DAG appId: " + dagClient.getApplicationId() + " Current state: " + dagStatus.getState()));
            Thread.sleep(100L);
            dagStatus = dagClient.getDAGStatus(null);
        }
        Assert.assertEquals((Object)finalState, (Object)dagStatus.getState());
    }

    @Test(timeout=120000L)
    public void testBasicRecovery() throws Exception {
        DAG dag = SimpleVTestDAG.createDAG("FailingCommitterDAG", null);
        OutputDescriptor od = new OutputDescriptor(MultiAttemptDAG.NoOpOutput.class.getName());
        od.setUserPayload(new MultiAttemptDAG.FailingOutputCommitter.FailingOutputCommitterConfig(true).toUserPayload());
        dag.getVertex("v3").addOutput("FailingOutput", od, MultiAttemptDAG.FailingOutputCommitter.class);
        this.runDAGAndVerify(dag, DAGStatus.State.FAILED);
    }

    static {
        TEST_ROOT_DIR = "target/" + TestDAGRecovery2.class.getName() + "-tmpDir";
        tezSession = null;
    }
}

