/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.ShuffleHandler;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobHistoryUtils;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.JarFinder;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.DefaultContainerExecutor;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.app.DAGAppMaster;

public class MiniTezCluster
extends MiniYARNCluster {
    public static final String APPJAR = JarFinder.getJar(DAGAppMaster.class);
    private static final Log LOG = LogFactory.getLog(MiniTezCluster.class);
    private static final String YARN_CLUSTER_CONFIG = "yarn-site.xml";
    private Path confFilePath;

    public MiniTezCluster(String testName) {
        this(testName, 1);
    }

    public MiniTezCluster(String testName, int noOfNMs) {
        super(testName, noOfNMs, 4, 4);
    }

    public MiniTezCluster(String testName, int noOfNMs, int numLocalDirs, int numLogDirs) {
        super(testName, noOfNMs, numLocalDirs, numLogDirs);
    }

    public void serviceInit(Configuration conf) throws Exception {
        File appJarLocalFile;
        conf.set("mapreduce.framework.name", "yarn-tez");
        if (conf.get("yarn.app.mapreduce.am.staging-dir") == null) {
            conf.set("yarn.app.mapreduce.am.staging-dir", new File(this.getTestWorkDir(), "apps_staging_dir/").getAbsolutePath());
        }
        if (conf.get("yarn.nodemanager.delete.debug-delay-sec") == null) {
            conf.setLong("yarn.nodemanager.delete.debug-delay-sec", 0L);
        }
        if (!(appJarLocalFile = new File(APPJAR)).exists()) {
            String message = "TezAppJar " + APPJAR + " not found. Exiting.";
            LOG.info((Object)message);
            throw new TezUncheckedException(message);
        }
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path testRootDir = fs.makeQualified(new Path("target", this.getName() + "-tmpDir"));
        Path appRemoteJar = new Path(testRootDir, "TezAppJar.jar");
        Path appMasterJar = new Path(APPJAR);
        fs.copyFromLocalFile(appMasterJar, appRemoteJar);
        fs.setPermission(appRemoteJar, new FsPermission("777"));
        conf.set("tez.lib.uris", appRemoteJar.toUri().toString());
        LOG.info((Object)("Set TEZ-LIB-URI to: " + conf.get("tez.lib.uris")));
        conf.setBoolean("yarn.nodemanager.pmem-check-enabled", false);
        conf.setBoolean("yarn.nodemanager.vmem-check-enabled", false);
        conf.set("fs.permissions.umask-mode", "000");
        try {
            FileContext fc;
            Path stagingPath = FileContext.getFileContext((Configuration)conf).makeQualified(new Path(conf.get("yarn.app.mapreduce.am.staging-dir")));
            if (Path.WINDOWS && LocalFileSystem.class.isInstance(stagingPath.getFileSystem(conf))) {
                conf.set("yarn.app.mapreduce.am.staging-dir", new File(conf.get("yarn.app.mapreduce.am.staging-dir")).getAbsolutePath());
            }
            if ((fc = FileContext.getFileContext((URI)stagingPath.toUri(), (Configuration)conf)).util().exists(stagingPath)) {
                LOG.info((Object)(stagingPath + " exists! deleting..."));
                fc.delete(stagingPath, true);
            }
            LOG.info((Object)("mkdir: " + stagingPath));
            fc.mkdir(stagingPath, null, true);
            String doneDir = JobHistoryUtils.getConfiguredHistoryServerDoneDirPrefix((Configuration)conf);
            Path doneDirPath = fc.makeQualified(new Path(doneDir));
            fc.mkdir(doneDirPath, null, true);
        }
        catch (IOException e) {
            throw new TezUncheckedException("Could not create staging directory. ", (Throwable)e);
        }
        conf.set("mapreduce.jobtracker.address", "test");
        conf.setStrings("yarn.nodemanager.aux-services", new String[]{"mapreduce_shuffle"});
        conf.setClass(String.format("yarn.nodemanager.aux-services.%s.class", "mapreduce_shuffle"), ShuffleHandler.class, Service.class);
        conf.setInt("mapreduce.shuffle.port", 0);
        conf.setClass("yarn.nodemanager.container-executor.class", DefaultContainerExecutor.class, ContainerExecutor.class);
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        super.serviceInit(conf);
    }

    public void serviceStart() throws Exception {
        super.serviceStart();
        File workDir = super.getTestWorkDir();
        Configuration conf = super.getConfig();
        this.confFilePath = new Path(workDir.getAbsolutePath(), YARN_CLUSTER_CONFIG);
        File confFile = new File(this.confFilePath.toString());
        try {
            confFile.createNewFile();
            conf.writeXml((OutputStream)new FileOutputStream(confFile));
            confFile.deleteOnExit();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        this.confFilePath = new Path(confFile.getAbsolutePath());
        conf.setStrings("yarn.application.classpath", new String[]{workDir.getAbsolutePath(), System.getProperty("java.class.path")});
        LOG.info((Object)("Setting yarn-site.xml via YARN-APP-CP at: " + conf.get("yarn.application.classpath")));
    }

    public Path getConfigFilePath() {
        return this.confFilePath;
    }
}

