/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.shuffle.common;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;

public class InputHost {
    private final String host;
    private final int port;
    private final int srcPhysicalIndex;
    private final BlockingQueue<InputAttemptIdentifier> inputs = new LinkedBlockingQueue<InputAttemptIdentifier>();

    public InputHost(String hostName, int port, ApplicationId appId, int srcPhysicalIndex) {
        this.host = hostName;
        this.port = port;
        this.srcPhysicalIndex = srcPhysicalIndex;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getSrcPhysicalIndex() {
        return this.srcPhysicalIndex;
    }

    public int getNumPendingInputs() {
        return this.inputs.size();
    }

    public void addKnownInput(InputAttemptIdentifier srcAttempt) {
        this.inputs.add(srcAttempt);
    }

    public List<InputAttemptIdentifier> clearAndGetPendingInputs() {
        ArrayList<InputAttemptIdentifier> inputsCopy = new ArrayList<InputAttemptIdentifier>(this.inputs.size());
        this.inputs.drainTo(inputsCopy);
        return inputsCopy;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + this.srcPhysicalIndex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InputHost other = (InputHost)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        return this.srcPhysicalIndex == other.srcPhysicalIndex;
    }

    public String toDetailedString() {
        return "InputHost [host=" + this.host + ", port=" + this.port + ",srcPhysicalIndex=" + this.srcPhysicalIndex + ", inputs=" + this.inputs + "]";
    }

    public String toString() {
        return "InputHost [host=" + this.host + ", port=" + this.port + ", srcPhysicalIndex=" + this.srcPhysicalIndex + "]";
    }
}

