/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.localshuffle;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.runtime.api.TezInputContext;
import org.apache.tez.runtime.library.common.ConfigUtils;
import org.apache.tez.runtime.library.common.sort.impl.TezMerger;
import org.apache.tez.runtime.library.common.sort.impl.TezRawKeyValueIterator;
import org.apache.tez.runtime.library.common.task.local.output.TezLocalTaskOutputFiles;
import org.apache.tez.runtime.library.common.task.local.output.TezTaskOutput;

public class LocalShuffle {
    private final TezInputContext inputContext;
    private final Configuration conf;
    private final int numInputs;
    private final Class keyClass;
    private final Class valClass;
    private final RawComparator comparator;
    private final FileSystem rfs;
    private final int sortFactor;
    private final TezCounter spilledRecordsCounter;
    private final CompressionCodec codec;
    private final TezTaskOutput mapOutputFile;
    private final boolean ifileReadAhead;
    private final int ifileReadAheadLength;
    private final int ifileBufferSize;

    public LocalShuffle(TezInputContext inputContext, Configuration conf, int numInputs) throws IOException {
        this.inputContext = inputContext;
        this.conf = conf;
        this.numInputs = numInputs;
        this.keyClass = ConfigUtils.getIntermediateInputKeyClass(conf);
        this.valClass = ConfigUtils.getIntermediateInputValueClass(conf);
        this.comparator = ConfigUtils.getIntermediateInputKeyComparator(conf);
        this.sortFactor = conf.getInt("tez.runtime.io.sort.factor", 100);
        this.rfs = FileSystem.getLocal((Configuration)conf).getRaw();
        this.spilledRecordsCounter = inputContext.getCounters().findCounter((Enum)TaskCounter.SPILLED_RECORDS);
        if (ConfigUtils.isIntermediateInputCompressed(conf)) {
            Class<? extends CompressionCodec> codecClass = ConfigUtils.getIntermediateInputCompressorClass(conf, DefaultCodec.class);
            this.codec = (CompressionCodec)ReflectionUtils.newInstance(codecClass, (Configuration)conf);
        } else {
            this.codec = null;
        }
        this.ifileReadAhead = conf.getBoolean("tez.runtime.ifile.readahead", true);
        this.ifileReadAheadLength = this.ifileReadAhead ? conf.getInt("tez.runtime.ifile.readahead.bytes", 0x400000) : 0;
        this.ifileBufferSize = conf.getInt("io.file.buffer.size", -1);
        this.mapOutputFile = new TezLocalTaskOutputFiles(conf, inputContext.getUniqueIdentifier());
    }

    public TezRawKeyValueIterator run() throws IOException {
        return TezMerger.merge(this.conf, this.rfs, this.keyClass, this.valClass, this.codec, this.ifileReadAhead, this.ifileReadAheadLength, this.ifileBufferSize, this.getMapFiles(), false, this.sortFactor, new Path(this.inputContext.getUniqueIdentifier()), this.comparator, null, this.spilledRecordsCounter, null, null, null);
    }

    private Path[] getMapFiles() throws IOException {
        ArrayList fileList = new ArrayList();
        for (int i = 0; i < this.numInputs; ++i) {
        }
        return fileList.toArray(new Path[0]);
    }
}

