/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.hadoop;

import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.api.records.Phase;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.tez.common.TezTaskStatus;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.mapreduce.hadoop.IDConverter;

public class TezTypeConverters {
    public static JobID toJobID(TezDAGID id) {
        return new JobID(String.valueOf(id.getApplicationId().getClusterTimestamp()), id.getId());
    }

    public static Phase toYarn(TezTaskStatus.Phase phase) {
        return Phase.valueOf((String)phase.name());
    }

    public static TaskAttemptId toYarn(TezTaskAttemptID taskAttemptId) {
        org.apache.hadoop.mapred.TaskAttemptID mrTaskAttemptId = IDConverter.toMRTaskAttemptId(taskAttemptId);
        TaskAttemptId mrv2TaskAttemptId = TypeConverter.toYarn((org.apache.hadoop.mapred.TaskAttemptID)mrTaskAttemptId);
        return mrv2TaskAttemptId;
    }

    public static TezTaskAttemptID toTez(TaskAttemptId taskAttemptId) {
        org.apache.hadoop.mapred.TaskAttemptID mrTaskAttemptId = TypeConverter.fromYarn((TaskAttemptId)taskAttemptId);
        TezTaskAttemptID tezTaskAttemptId = IDConverter.fromMRTaskAttemptId((TaskAttemptID)mrTaskAttemptId);
        return tezTaskAttemptId;
    }

    public static Counters fromTez(TezCounters tezCounters) {
        if (tezCounters == null) {
            return null;
        }
        Counters counters = new Counters();
        for (CounterGroup xGrp : tezCounters) {
            counters.addGroup(xGrp.getName(), xGrp.getDisplayName());
            for (TezCounter xCounter : xGrp) {
                Counter counter = counters.findCounter(xGrp.getName(), xCounter.getName());
                counter.setValue(xCounter.getValue());
            }
        }
        return counters;
    }
}

