/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api.client;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.tez.client.FrameworkClient;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DAGNotRunningException;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGClientTimelineImpl;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.Progress;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.dag.api.client.VertexStatus;
import org.apache.tez.dag.api.client.rpc.DAGClientRPCImpl;
import org.apache.tez.dag.api.records.DAGProtos;

@InterfaceAudience.Private
public class DAGClientImpl
extends DAGClient {
    private static final Log LOG = LogFactory.getLog(DAGClientImpl.class);
    private final ApplicationId appId;
    private final String dagId;
    private final TezConfiguration conf;
    private final FrameworkClient frameworkClient;
    @VisibleForTesting
    protected DAGClient realClient;
    private boolean dagCompleted = false;
    private boolean isATSEnabled = false;
    private DAGStatus cachedDagStatus = null;
    Map<String, VertexStatus> cachedVertexStatus = new HashMap<String, VertexStatus>();
    private static final long SLEEP_FOR_COMPLETION = 500L;
    private static final long PRINT_STATUS_INTERVAL_MILLIS = 5000L;
    private final DecimalFormat formatter = new DecimalFormat("###.##%");
    private long lastPrintStatusTimeMillis;
    private EnumSet<VertexStatus.State> vertexCompletionStates = EnumSet.of(VertexStatus.State.SUCCEEDED, VertexStatus.State.FAILED, VertexStatus.State.KILLED, VertexStatus.State.ERROR);

    public DAGClientImpl(ApplicationId appId, String dagId, TezConfiguration conf, @Nullable FrameworkClient frameworkClient) {
        this.appId = appId;
        this.dagId = dagId;
        this.conf = conf;
        if (frameworkClient != null && conf.getBoolean("tez.local.mode", false)) {
            this.frameworkClient = frameworkClient;
        } else {
            this.frameworkClient = FrameworkClient.createFrameworkClient(conf);
            this.frameworkClient.init(conf, new YarnConfiguration((Configuration)conf));
            this.frameworkClient.start();
        }
        this.isATSEnabled = conf.get("tez.history.logging.service.class", "").equals("org.apache.tez.dag.history.logging.ats.ATSHistoryLoggingService");
        if (UserGroupInformation.isSecurityEnabled()) {
            this.isATSEnabled = false;
        }
        this.realClient = new DAGClientRPCImpl(appId, dagId, conf, this.frameworkClient);
    }

    @Override
    public String getExecutionContext() {
        return this.realClient.getExecutionContext();
    }

    @Override
    protected ApplicationReport getApplicationReportInternal() {
        return this.realClient.getApplicationReportInternal();
    }

    @Override
    public DAGStatus getDAGStatus(@Nullable Set<StatusGetOpts> statusOptions) throws TezException, IOException {
        block10: {
            DAGStatus dagStatus;
            if (!this.dagCompleted) {
                dagStatus = this.getDAGStatusViaAM(statusOptions);
                if (!this.dagCompleted) {
                    if (dagStatus != null) {
                        this.cachedDagStatus = dagStatus;
                        return dagStatus;
                    }
                    if (this.cachedDagStatus != null) {
                        return this.cachedDagStatus;
                    }
                }
                if (this.isATSEnabled && this.dagCompleted) {
                    this.switchToTimelineClient();
                }
            }
            if (this.isATSEnabled && this.dagCompleted) {
                try {
                    dagStatus = this.realClient.getDAGStatus(statusOptions);
                    if (dagStatus.isCompleted()) {
                        return dagStatus;
                    }
                }
                catch (TezException e) {
                    if (!LOG.isDebugEnabled()) break block10;
                    LOG.info((Object)("DAGStatus fetch failed." + e.getMessage()));
                }
            }
        }
        if (this.dagCompleted && this.cachedDagStatus != null && this.cachedDagStatus.isCompleted()) {
            return this.cachedDagStatus;
        }
        return this.getDAGStatusViaRM();
    }

    @Override
    public VertexStatus getVertexStatus(String vertexName, Set<StatusGetOpts> statusOptions) throws IOException, TezException {
        VertexStatus vertexStatus;
        block10: {
            if (!this.dagCompleted) {
                vertexStatus = this.getVertexStatusViaAM(vertexName, statusOptions);
                if (!this.dagCompleted) {
                    if (vertexStatus != null) {
                        this.cachedVertexStatus.put(vertexName, vertexStatus);
                        return vertexStatus;
                    }
                    if (this.cachedVertexStatus.containsKey(vertexName)) {
                        return this.cachedVertexStatus.get(vertexName);
                    }
                }
                if (this.isATSEnabled && this.dagCompleted) {
                    this.switchToTimelineClient();
                }
            }
            if (this.isATSEnabled && this.dagCompleted) {
                try {
                    vertexStatus = this.realClient.getVertexStatus(vertexName, statusOptions);
                    if (this.vertexCompletionStates.contains((Object)vertexStatus.getState())) {
                        return vertexStatus;
                    }
                }
                catch (TezException e) {
                    if (!LOG.isDebugEnabled()) break block10;
                    LOG.debug((Object)("ERROR fetching vertex data from Yarn Timeline. " + e.getMessage()));
                }
            }
        }
        if (this.cachedVertexStatus.containsKey(vertexName) && this.vertexCompletionStates.contains((Object)(vertexStatus = this.cachedVertexStatus.get(vertexName)).getState())) {
            return vertexStatus;
        }
        return null;
    }

    @Override
    public void tryKillDAG() throws IOException, TezException {
        if (!this.dagCompleted) {
            this.realClient.tryKillDAG();
        } else {
            LOG.info((Object)("TryKill for app: " + this.appId + " dag:" + this.dagId + " dag already completed."));
        }
    }

    @Override
    public DAGStatus waitForCompletion() throws IOException, TezException, InterruptedException {
        return this._waitForCompletionWithStatusUpdates(false, EnumSet.noneOf(StatusGetOpts.class));
    }

    @Override
    public DAGStatus waitForCompletionWithStatusUpdates(@Nullable Set<StatusGetOpts> statusGetOpts) throws IOException, TezException, InterruptedException {
        return this._waitForCompletionWithStatusUpdates(true, statusGetOpts);
    }

    @Override
    public void close() throws IOException {
        this.realClient.close();
        if (this.frameworkClient != null) {
            this.frameworkClient.stop();
        }
    }

    private DAGStatus getDAGStatusViaAM(@Nullable Set<StatusGetOpts> statusOptions) throws IOException {
        DAGStatus dagStatus = null;
        try {
            dagStatus = this.realClient.getDAGStatus(statusOptions);
        }
        catch (DAGNotRunningException e) {
            this.dagCompleted = true;
        }
        catch (TezException tezException) {
            // empty catch block
        }
        if (dagStatus == null && !this.dagCompleted) {
            this.checkAndSetDagCompletionStatus();
        }
        return dagStatus;
    }

    private VertexStatus getVertexStatusViaAM(String vertexName, Set<StatusGetOpts> statusOptions) throws IOException {
        VertexStatus vertexStatus = null;
        try {
            vertexStatus = this.realClient.getVertexStatus(vertexName, statusOptions);
        }
        catch (DAGNotRunningException e) {
            this.dagCompleted = true;
        }
        catch (TezException e) {
            // empty catch block
        }
        if (vertexStatus == null && !this.dagCompleted) {
            this.checkAndSetDagCompletionStatus();
        }
        return vertexStatus;
    }

    DAGStatus getDAGStatusViaRM() throws TezException, IOException {
        DAGProtos.DAGStatusStateProto dagState;
        ApplicationReport appReport;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("GetDAGStatus via AM for app: " + this.appId + " dag:" + this.dagId));
        }
        try {
            appReport = this.frameworkClient.getApplicationReport(this.appId);
        }
        catch (YarnException e) {
            throw new TezException(e);
        }
        if (appReport == null) {
            throw new TezException("Unknown/Invalid appId: " + this.appId);
        }
        DAGProtos.DAGStatusProto.Builder builder = DAGProtos.DAGStatusProto.newBuilder();
        DAGStatus dagStatus = new DAGStatus(builder);
        block1 : switch (appReport.getYarnApplicationState()) {
            case NEW: 
            case NEW_SAVING: 
            case SUBMITTED: 
            case ACCEPTED: {
                dagState = DAGProtos.DAGStatusStateProto.DAG_SUBMITTED;
                break;
            }
            case RUNNING: {
                dagState = DAGProtos.DAGStatusStateProto.DAG_RUNNING;
                break;
            }
            case FAILED: {
                dagState = DAGProtos.DAGStatusStateProto.DAG_FAILED;
                break;
            }
            case KILLED: {
                dagState = DAGProtos.DAGStatusStateProto.DAG_KILLED;
                break;
            }
            case FINISHED: {
                switch (appReport.getFinalApplicationStatus()) {
                    case UNDEFINED: 
                    case FAILED: {
                        dagState = DAGProtos.DAGStatusStateProto.DAG_FAILED;
                        break block1;
                    }
                    case KILLED: {
                        dagState = DAGProtos.DAGStatusStateProto.DAG_KILLED;
                        break block1;
                    }
                    case SUCCEEDED: {
                        dagState = DAGProtos.DAGStatusStateProto.DAG_SUCCEEDED;
                        break block1;
                    }
                }
                throw new TezUncheckedException("Encountered unknown final application status from YARN, appState=" + appReport.getYarnApplicationState() + ", finalStatus=" + appReport.getFinalApplicationStatus());
            }
            default: {
                throw new TezUncheckedException("Encountered unknown application state from YARN, appState=" + appReport.getYarnApplicationState());
            }
        }
        builder.setState(dagState);
        if (appReport.getDiagnostics() != null) {
            builder.addAllDiagnostics(Collections.singleton(appReport.getDiagnostics()));
        }
        return dagStatus;
    }

    private DAGStatus _waitForCompletionWithStatusUpdates(boolean vertexUpdates, @Nullable Set<StatusGetOpts> statusGetOpts) throws IOException, TezException, InterruptedException {
        DAGStatus dagStatus;
        boolean initPrinted = false;
        boolean runningPrinted = false;
        double dagProgress = -1.0;
        while (true) {
            dagStatus = this.getDAGStatus(statusGetOpts);
            if (!(initPrinted || dagStatus.getState() != DAGStatus.State.INITING && dagStatus.getState() != DAGStatus.State.SUBMITTED)) {
                initPrinted = true;
                this.log("Waiting for DAG to start running");
            }
            if (dagStatus.getState() == DAGStatus.State.RUNNING || dagStatus.getState() == DAGStatus.State.SUCCEEDED || dagStatus.getState() == DAGStatus.State.FAILED || dagStatus.getState() == DAGStatus.State.KILLED || dagStatus.getState() == DAGStatus.State.ERROR) break;
            Thread.sleep(500L);
        }
        Set<String> vertexNames = Collections.emptySet();
        while (!dagStatus.isCompleted()) {
            if (!runningPrinted) {
                this.log("DAG initialized: CurrentState=Running");
                runningPrinted = true;
            }
            if (vertexUpdates && vertexNames.isEmpty()) {
                vertexNames = this.getDAGStatus(statusGetOpts).getVertexProgress().keySet();
            }
            dagProgress = this.monitorProgress(vertexNames, dagProgress, null, dagStatus);
            Thread.sleep(500L);
            dagStatus = this.getDAGStatus(statusGetOpts);
        }
        this.monitorProgress(vertexNames, -1.0, statusGetOpts, dagStatus);
        this.log("DAG completed. FinalState=" + (Object)((Object)dagStatus.getState()));
        return dagStatus;
    }

    private double monitorProgress(Set<String> vertexNames, double prevDagProgress, Set<StatusGetOpts> opts, DAGStatus dagStatus) throws IOException, TezException {
        Progress progress = dagStatus.getDAGProgress();
        double dagProgress = prevDagProgress;
        if (progress != null) {
            boolean printIntervalExpired;
            dagProgress = this.getProgress(progress);
            boolean progressChanged = dagProgress > prevDagProgress;
            long currentTimeMillis = System.currentTimeMillis();
            long timeSinceLastPrintStatus = currentTimeMillis - this.lastPrintStatusTimeMillis;
            boolean bl = printIntervalExpired = timeSinceLastPrintStatus > 5000L;
            if (progressChanged || printIntervalExpired) {
                this.lastPrintStatusTimeMillis = currentTimeMillis;
                this.printDAGStatus(vertexNames, opts, dagStatus, progress);
            }
        }
        return dagProgress;
    }

    private void printDAGStatus(Set<String> vertexNames, Set<StatusGetOpts> opts, DAGStatus dagStatus, Progress dagProgress) throws IOException, TezException {
        TezCounters counters;
        boolean displayCounter;
        double vProgressFloat = 0.0;
        this.log("DAG: State: " + (Object)((Object)dagStatus.getState()) + " Progress: " + this.formatter.format(this.getProgress(dagProgress)) + " " + dagProgress);
        boolean bl = displayCounter = opts != null && opts.contains((Object)StatusGetOpts.GET_COUNTERS);
        if (displayCounter && (counters = dagStatus.getDAGCounters()) != null) {
            this.log("DAG Counters:\n" + counters);
        }
        for (String vertex : vertexNames) {
            TezCounters counters2;
            VertexStatus vStatus = this.getVertexStatus(vertex, opts);
            if (vStatus == null) {
                this.log("Could not retrieve status for vertex: " + vertex);
                continue;
            }
            Progress vProgress = vStatus.getProgress();
            if (vProgress != null) {
                vProgressFloat = 0.0;
                if (vProgress.getTotalTaskCount() == 0) {
                    vProgressFloat = 1.0;
                } else if (vProgress.getTotalTaskCount() > 0) {
                    vProgressFloat = this.getProgress(vProgress);
                }
                this.log("\tVertexStatus: VertexName: " + vertex + " Progress: " + this.formatter.format(vProgressFloat) + " " + vProgress);
            }
            if (!displayCounter || (counters2 = vStatus.getVertexCounters()) == null) continue;
            this.log("Vertex Counters for " + vertex + ":\n" + counters2);
        }
    }

    private void checkAndSetDagCompletionStatus() {
        YarnApplicationState appState;
        ApplicationReport appReport = this.realClient.getApplicationReportInternal();
        if (appReport != null && ((appState = appReport.getYarnApplicationState()) == YarnApplicationState.FINISHED || appState == YarnApplicationState.FAILED || appState == YarnApplicationState.KILLED)) {
            this.dagCompleted = true;
        }
    }

    private ApplicationReport getApplicationReport() {
        ApplicationReport appReport = null;
        try {
            appReport = this.frameworkClient.getApplicationReport(this.appId);
        }
        catch (YarnException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return appReport;
    }

    private void switchToTimelineClient() throws IOException, TezException {
        this.realClient.close();
        this.realClient = new DAGClientTimelineImpl(this.appId, this.dagId, this.conf, this.frameworkClient);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"dag completed switching to DAGClientTimelineImpl");
        }
    }

    @VisibleForTesting
    public DAGClient getRealClient() {
        return this.realClient;
    }

    private double getProgress(Progress progress) {
        return progress.getTotalTaskCount() == 0 ? 0.0 : (double)progress.getSucceededTaskCount() / (double)progress.getTotalTaskCount();
    }

    private void log(String message) {
        LOG.info((Object)message);
    }
}

