/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.validation;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.model.Config;
import org.apache.sqoop.model.ConfigClass;
import org.apache.sqoop.model.ConfigUtils;
import org.apache.sqoop.model.ConfigurationClass;
import org.apache.sqoop.model.Input;
import org.apache.sqoop.model.Validator;
import org.apache.sqoop.utils.ClassUtils;
import org.apache.sqoop.validation.ConfigValidationError;
import org.apache.sqoop.validation.ConfigValidationResult;
import org.apache.sqoop.validation.validators.AbstractValidator;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class ConfigValidationRunner {
    private Map<Class<? extends AbstractValidator>, AbstractValidator> cache = new HashMap<Class<? extends AbstractValidator>, AbstractValidator>();

    public ConfigValidationResult validate(Object config) {
        ConfigValidationResult result = new ConfigValidationResult();
        ConfigurationClass globalAnnotation = ConfigUtils.getConfigurationClassAnnotation(config, true);
        for (Field field : config.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            Config configAnnotation = ConfigUtils.getConfigAnnotation(field, false);
            if (configAnnotation == null) continue;
            String configName = ConfigUtils.getName(field, configAnnotation);
            ConfigValidationResult r = this.validateConfig(configName, ConfigUtils.getFieldValue(field, config));
            result.mergeValidatorResult(r);
        }
        if (result.getStatus().canProceed()) {
            ConfigValidationResult r = this.validateArray("", config, globalAnnotation.validators());
            result.mergeValidatorResult(r);
        }
        return result;
    }

    public ConfigValidationResult validateConfig(String configName, Object config) {
        ConfigValidationResult result = new ConfigValidationResult();
        ConfigClass configAnnotation = ConfigUtils.getConfigClassAnnotation(config, true);
        for (Field field : config.getClass().getDeclaredFields()) {
            Input inputAnnotation = ConfigUtils.getInputAnnotation(field, false);
            if (inputAnnotation == null) continue;
            String name = configName + "." + ConfigUtils.getName(field, inputAnnotation);
            ConfigValidationResult r = this.validateArray(name, ConfigUtils.getFieldValue(field, config), inputAnnotation.validators());
            result.mergeValidatorResult(r);
        }
        if (result.getStatus().canProceed()) {
            ConfigValidationResult r = this.validateArray(configName, config, configAnnotation.validators());
            result.mergeValidatorResult(r);
        }
        return result;
    }

    private ConfigValidationResult validateArray(String name, Object object, Validator[] validators) {
        ConfigValidationResult result = new ConfigValidationResult();
        for (Validator validator : validators) {
            AbstractValidator v = this.executeValidator(object, validator);
            result.addValidatorResult(name, v);
        }
        return result;
    }

    private AbstractValidator executeValidator(Object object, Validator validator) {
        AbstractValidator instance = this.cache.get(validator.value());
        if (instance == null) {
            instance = (AbstractValidator)ClassUtils.instantiate(validator.value(), new Object[0]);
            if (instance == null) {
                throw new SqoopException((ErrorCode)ConfigValidationError.VALIDATION_0004, validator.value().getName());
            }
            this.cache.put(validator.value(), instance);
        } else {
            instance.reset();
        }
        instance.setStringArgument(validator.strArg());
        instance.validate(object);
        return instance;
    }
}

