/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.schema.type;

import java.util.HashSet;
import java.util.Set;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.schema.type.Column;
import org.apache.sqoop.schema.type.ColumnType;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class Enum
extends Column {
    private Set<String> options;

    public Enum(String name) {
        super(name);
        this.setOptions(new HashSet<String>());
    }

    public Enum(String name, Set<String> options) {
        super(name);
        this.setOptions(options);
    }

    public Enum setOptions(Set<String> options) {
        assert (options != null);
        this.options = options;
        return this;
    }

    public Set<String> getOptions() {
        return this.options;
    }

    @Override
    public ColumnType getType() {
        return ColumnType.ENUM;
    }

    @Override
    public String toString() {
        return "Enum{" + super.toString() + ",options=" + this.options + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Enum)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Enum that = (Enum)o;
        return !(this.options != null ? !this.options.equals(that.options) : that.options != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
        return result;
    }
}

