/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.common.Direction;
import org.apache.sqoop.common.SupportedDirections;
import org.apache.sqoop.model.Configurable;
import org.apache.sqoop.model.MConfigurableType;
import org.apache.sqoop.model.MFromConfig;
import org.apache.sqoop.model.MLinkConfig;
import org.apache.sqoop.model.MToConfig;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public final class MConnector
extends Configurable {
    private final String uniqueName;
    private final String className;
    private final String version;
    private final MLinkConfig linkConfig;
    private final MFromConfig fromConfig;
    private final MToConfig toConfig;

    public MConnector(String uniqueName, String className, String version, MLinkConfig linkConfig, MFromConfig fromConfig, MToConfig toConfig) {
        this.version = version;
        this.linkConfig = linkConfig;
        this.fromConfig = fromConfig;
        this.toConfig = toConfig;
        if (uniqueName == null || className == null) {
            throw new NullPointerException();
        }
        this.uniqueName = uniqueName;
        this.className = className;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("connector-");
        sb.append(this.uniqueName).append(":").append(this.getPersistenceId()).append(":");
        sb.append(this.className);
        sb.append(", ").append(this.getLinkConfig().toString());
        if (this.getFromConfig() != null) {
            sb.append(", ").append(this.getFromConfig().toString());
        }
        if (this.getToConfig() != null) {
            sb.append(", ").append(this.getToConfig().toString());
        }
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MConnector)) {
            return false;
        }
        MConnector mc = (MConnector)other;
        SupportedDirections supportedDirections = this.getSupportedDirections();
        SupportedDirections mcSupportedDirections = mc.getSupportedDirections();
        if (supportedDirections.isDirectionSupported(Direction.FROM) && mcSupportedDirections.isDirectionSupported(Direction.FROM) && !this.getFromConfig().equals(mc.getFromConfig())) {
            return false;
        }
        if (supportedDirections.isDirectionSupported(Direction.FROM) != mcSupportedDirections.isDirectionSupported(Direction.FROM)) {
            return false;
        }
        if (supportedDirections.isDirectionSupported(Direction.TO) && mcSupportedDirections.isDirectionSupported(Direction.TO) && !this.getToConfig().equals(mc.getToConfig())) {
            return false;
        }
        if (supportedDirections.isDirectionSupported(Direction.TO) != mcSupportedDirections.isDirectionSupported(Direction.TO)) {
            return false;
        }
        return this.uniqueName.equals(mc.uniqueName) && this.className.equals(mc.className) && this.version.equals(mc.version) && this.linkConfig.equals(mc.getLinkConfig());
    }

    public int hashCode() {
        SupportedDirections supportedDirections = this.getSupportedDirections();
        int result = this.getLinkConfig().hashCode();
        if (supportedDirections.isDirectionSupported(Direction.FROM)) {
            result = 31 * result + this.getFromConfig().hashCode();
        }
        if (supportedDirections.isDirectionSupported(Direction.TO)) {
            result = 31 * result + this.getToConfig().hashCode();
        }
        result = 31 * result + this.version.hashCode();
        result = 31 * result + this.uniqueName.hashCode();
        result = 31 * result + this.className.hashCode();
        return result;
    }

    @Override
    public MConnector clone(boolean cloneWithValue) {
        cloneWithValue = false;
        MFromConfig fromConfig = this.getFromConfig();
        MToConfig toConfig = this.getToConfig();
        if (fromConfig != null) {
            fromConfig = fromConfig.clone(cloneWithValue);
        }
        if (toConfig != null) {
            toConfig = toConfig.clone(cloneWithValue);
        }
        MConnector copy = new MConnector(this.getUniqueName(), this.getClassName(), this.getVersion(), this.getLinkConfig().clone(cloneWithValue), fromConfig, toConfig);
        copy.setPersistenceId(this.getPersistenceId());
        return copy;
    }

    public MLinkConfig getLinkConfig() {
        return this.linkConfig;
    }

    public MFromConfig getFromConfig() {
        return this.fromConfig;
    }

    public MToConfig getToConfig() {
        return this.toConfig;
    }

    public String getVersion() {
        return this.version;
    }

    public MConfigurableType getType() {
        return MConfigurableType.CONNECTOR;
    }

    public SupportedDirections getSupportedDirections() {
        return new SupportedDirections(this.getFromConfig() != null, this.getToConfig() != null);
    }
}

