/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.ArrayList;
import java.util.List;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.json.JsonBean;
import org.apache.sqoop.model.MPrivilege;
import org.apache.sqoop.model.MResource;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class PrivilegeBean
implements JsonBean {
    public static final String PRIVILEGE = "privilege";
    private static final String RESOURCE_NAME = "resource-name";
    private static final String RESOURCE_TYPE = "resource-type";
    private static final String ACTION = "action";
    private static final String WITH_GRANT_OPTION = "with-grant-option";
    private List<MPrivilege> privileges;

    public List<MPrivilege> getPrivileges() {
        return this.privileges;
    }

    public PrivilegeBean(MPrivilege privilege) {
        this();
        this.privileges = new ArrayList<MPrivilege>();
        this.privileges.add(privilege);
    }

    public PrivilegeBean(List<MPrivilege> privileges) {
        this();
        this.privileges = privileges;
    }

    public PrivilegeBean() {
    }

    @Override
    public JSONObject extract(boolean skipSensitive) {
        JSONObject privilege = new JSONObject();
        privilege.put((Object)PRIVILEGE, (Object)this.extractPrivilege(this.privileges.get(0)));
        return privilege;
    }

    protected JSONArray extractPrivileges() {
        JSONArray privilegesArray = new JSONArray();
        if (this.privileges != null) {
            for (MPrivilege privilege : this.privileges) {
                privilegesArray.add((Object)this.extractPrivilege(privilege));
            }
        }
        return privilegesArray;
    }

    private JSONObject extractPrivilege(MPrivilege privilege) {
        JSONObject object = new JSONObject();
        object.put((Object)RESOURCE_NAME, (Object)privilege.getResource().getName());
        object.put((Object)RESOURCE_TYPE, (Object)privilege.getResource().getType());
        object.put((Object)ACTION, (Object)privilege.getAction());
        object.put((Object)WITH_GRANT_OPTION, (Object)privilege.isWith_grant_option());
        return object;
    }

    @Override
    public void restore(JSONObject json) {
        this.privileges = new ArrayList<MPrivilege>();
        JSONObject obj = (JSONObject)json.get((Object)PRIVILEGE);
        this.privileges.add(this.restorePrivilege(obj));
    }

    protected void restorePrivileges(JSONArray array) {
        this.privileges = new ArrayList<MPrivilege>();
        for (Object obj : array) {
            this.privileges.add(this.restorePrivilege(obj));
        }
    }

    private MPrivilege restorePrivilege(Object obj) {
        JSONObject object = (JSONObject)obj;
        MResource resource = new MResource((String)object.get((Object)RESOURCE_NAME), (String)object.get((Object)RESOURCE_TYPE));
        return new MPrivilege(resource, (String)object.get((Object)ACTION), (boolean)Boolean.valueOf(object.get((Object)WITH_GRANT_OPTION).toString()));
    }
}

