/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.ArrayList;
import java.util.List;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.json.JsonBean;
import org.apache.sqoop.model.MPrincipal;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class PrincipalBean
implements JsonBean {
    public static final String PRINCIPAL = "principal";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private List<MPrincipal> principals;

    public List<MPrincipal> getPrincipals() {
        return this.principals;
    }

    public PrincipalBean(MPrincipal principal) {
        this();
        this.principals = new ArrayList<MPrincipal>();
        this.principals.add(principal);
    }

    public PrincipalBean(List<MPrincipal> principals) {
        this();
        this.principals = principals;
    }

    public PrincipalBean() {
    }

    @Override
    public JSONObject extract(boolean skipSensitive) {
        JSONObject principal = new JSONObject();
        principal.put((Object)PRINCIPAL, (Object)this.extractPrincipal(this.principals.get(0)));
        return principal;
    }

    protected JSONArray extractPrincipals() {
        JSONArray principalsArray = new JSONArray();
        if (this.principals != null) {
            for (MPrincipal principal : this.principals) {
                principalsArray.add((Object)this.extractPrincipal(principal));
            }
        }
        return principalsArray;
    }

    private JSONObject extractPrincipal(MPrincipal principal) {
        JSONObject object = new JSONObject();
        object.put((Object)NAME, (Object)principal.getName());
        object.put((Object)TYPE, (Object)principal.getType());
        return object;
    }

    @Override
    public void restore(JSONObject json) {
        this.principals = new ArrayList<MPrincipal>();
        JSONObject obj = (JSONObject)json.get((Object)PRINCIPAL);
        this.principals.add(this.restorePrincipal(obj));
    }

    protected void restorePrincipals(JSONArray array) {
        this.principals = new ArrayList<MPrincipal>();
        for (Object obj : array) {
            this.principals.add(this.restorePrincipal(obj));
        }
    }

    private MPrincipal restorePrincipal(Object obj) {
        JSONObject object = (JSONObject)obj;
        return new MPrincipal((String)object.get((Object)NAME), (String)object.get((Object)TYPE));
    }
}

