/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.common.Direction;
import org.apache.sqoop.json.ConfigurableBean;
import org.apache.sqoop.json.util.ConfigBundleSerialization;
import org.apache.sqoop.json.util.ConfigInputSerialization;
import org.apache.sqoop.model.MConfig;
import org.apache.sqoop.model.MConnector;
import org.apache.sqoop.model.MFromConfig;
import org.apache.sqoop.model.MLinkConfig;
import org.apache.sqoop.model.MToConfig;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ConnectorBean
extends ConfigurableBean {
    public static final String CONNECTOR_LINK_CONFIG = "link-config";
    public static final String CONNECTOR_JOB_CONFIG = "job-config";
    private static final String CONNECTOR = "connector";
    private List<MConnector> connectors;
    private Map<Long, ResourceBundle> connectorConfigBundles;

    public ConnectorBean(List<MConnector> connectors, Map<Long, ResourceBundle> bundles) {
        this.connectors = connectors;
        this.connectorConfigBundles = bundles;
    }

    public ConnectorBean() {
    }

    public List<MConnector> getConnectors() {
        return this.connectors;
    }

    public Map<Long, ResourceBundle> getResourceBundles() {
        return this.connectorConfigBundles;
    }

    @Override
    public JSONObject extract(boolean skipSensitive) {
        JSONObject connector = new JSONObject();
        connector.put((Object)CONNECTOR, (Object)this.extractConnector(skipSensitive, this.connectors.get(0)));
        return connector;
    }

    protected JSONArray extractConnectors(boolean skipSensitive) {
        JSONArray connectorArray = new JSONArray();
        for (MConnector connector : this.connectors) {
            connectorArray.add((Object)this.extractConnector(skipSensitive, connector));
        }
        return connectorArray;
    }

    private JSONObject extractConnector(boolean skipSensitive, MConnector connector) {
        JSONObject connectorJsonObject = new JSONObject();
        connectorJsonObject.put((Object)"id", (Object)connector.getPersistenceId());
        connectorJsonObject.put((Object)"name", (Object)connector.getUniqueName());
        connectorJsonObject.put((Object)"class", (Object)connector.getClassName());
        connectorJsonObject.put((Object)"version", (Object)connector.getVersion());
        connectorJsonObject.put((Object)CONNECTOR_LINK_CONFIG, (Object)ConfigInputSerialization.extractConfigList(connector.getLinkConfig().getConfigs(), connector.getLinkConfig().getType(), skipSensitive));
        connectorJsonObject.put((Object)CONNECTOR_JOB_CONFIG, (Object)new JSONObject());
        if (connector.getFromConfig() != null) {
            ((JSONObject)connectorJsonObject.get((Object)CONNECTOR_JOB_CONFIG)).put((Object)Direction.FROM, (Object)ConfigInputSerialization.extractConfigList(connector.getFromConfig().getConfigs(), connector.getFromConfig().getType(), skipSensitive));
        }
        if (connector.getToConfig() != null) {
            ((JSONObject)connectorJsonObject.get((Object)CONNECTOR_JOB_CONFIG)).put((Object)Direction.TO, (Object)ConfigInputSerialization.extractConfigList(connector.getToConfig().getConfigs(), connector.getToConfig().getType(), skipSensitive));
        }
        connectorJsonObject.put((Object)"all-config-resources", (Object)new JSONObject());
        if (this.connectorConfigBundles != null && !this.connectorConfigBundles.isEmpty()) {
            connectorJsonObject.put((Object)"all-config-resources", (Object)ConfigBundleSerialization.extractConfigParamBundle(this.connectorConfigBundles.get(connector.getPersistenceId())));
        }
        return connectorJsonObject;
    }

    @Override
    public void restore(JSONObject jsonObject) {
        this.connectors = new ArrayList<MConnector>();
        this.connectorConfigBundles = new HashMap<Long, ResourceBundle>();
        JSONObject obj = (JSONObject)jsonObject.get((Object)CONNECTOR);
        this.connectors.add(this.restoreConnector(obj));
    }

    protected void restoreConnectors(JSONArray array) {
        this.connectors = new ArrayList<MConnector>();
        this.connectorConfigBundles = new HashMap<Long, ResourceBundle>();
        for (Object obj : array) {
            this.connectors.add(this.restoreConnector(obj));
        }
    }

    private MConnector restoreConnector(Object obj) {
        JSONObject object = (JSONObject)obj;
        long connectorId = (Long)object.get((Object)"id");
        String uniqueName = (String)object.get((Object)"name");
        String className = (String)object.get((Object)"class");
        String version = (String)object.get((Object)"version");
        List<MConfig> linkConfigs = ConfigInputSerialization.restoreConfigList((JSONArray)object.get((Object)CONNECTOR_LINK_CONFIG));
        JSONObject jobConfigJson = (JSONObject)object.get((Object)CONNECTOR_JOB_CONFIG);
        JSONArray fromJobConfigJson = (JSONArray)jobConfigJson.get((Object)Direction.FROM.name());
        JSONArray toJobConfigJson = (JSONArray)jobConfigJson.get((Object)Direction.TO.name());
        MFromConfig fromConfig = null;
        MToConfig toConfig = null;
        if (fromJobConfigJson != null) {
            List<MConfig> fromJobConfig = ConfigInputSerialization.restoreConfigList(fromJobConfigJson);
            fromConfig = new MFromConfig(fromJobConfig);
        }
        if (toJobConfigJson != null) {
            List<MConfig> toJobConfig = ConfigInputSerialization.restoreConfigList(toJobConfigJson);
            toConfig = new MToConfig(toJobConfig);
        }
        MLinkConfig linkConfig = new MLinkConfig(linkConfigs);
        MConnector connector = new MConnector(uniqueName, className, version, linkConfig, fromConfig, toConfig);
        connector.setPersistenceId(connectorId);
        if (object.containsKey((Object)"all-config-resources")) {
            JSONObject jsonConfigBundle = (JSONObject)object.get((Object)"all-config-resources");
            this.connectorConfigBundles.put(connectorId, ConfigBundleSerialization.restoreConfigParamBundle(jsonConfigBundle));
        }
        return connector;
    }
}

