/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.common;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.common.ImmutableContext;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class MapContext
implements ImmutableContext {
    private final Map<String, String> options;

    public MapContext(Map<String, String> options) {
        this.options = options;
    }

    protected Map<String, String> getOptions() {
        return this.options;
    }

    @Override
    public String getString(String key) {
        return this.options.get(key);
    }

    @Override
    public String getString(String key, String defaultValue) {
        String value = this.getString(key);
        if (value == null || value.trim().length() == 0) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.getString(key);
        boolean result = defaultValue;
        if (value != null) {
            result = Boolean.valueOf(value);
        }
        return result;
    }

    @Override
    public long getLong(String key, long defaultValue) {
        if (!this.options.containsKey(key)) {
            return defaultValue;
        }
        String value = this.options.get(key);
        return Long.parseLong(value);
    }

    @Override
    public int getInt(String key, int defaultValue) {
        if (!this.options.containsKey(key)) {
            return defaultValue;
        }
        String value = this.options.get(key);
        return Integer.parseInt(value);
    }

    public Map<String, String> getNestedProperties(String prefix) {
        HashMap<String, String> subProps = new HashMap<String, String>();
        for (String key : this.options.keySet()) {
            if (!key.startsWith(prefix)) continue;
            subProps.put(key.substring(prefix.length()), this.options.get(key));
        }
        return subProps;
    }

    public Map<String, String> getValByRegex(String regex) {
        Pattern p = Pattern.compile(regex);
        HashMap<String, String> result = new HashMap<String, String>();
        for (String item : this.options.keySet()) {
            Matcher m = p.matcher(item);
            if (!m.find()) continue;
            result.put(item, this.getString(item));
        }
        return result;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.options.entrySet().iterator();
    }
}

