/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;

public class CollectionAdminRequest
extends SolrRequest {
    protected String collection = null;
    protected CollectionParams.CollectionAction action = null;
    protected String asyncId = null;

    public CollectionAdminRequest() {
        super(SolrRequest.METHOD.GET, "/admin/collections");
    }

    public CollectionAdminRequest(String path) {
        super(SolrRequest.METHOD.GET, path);
    }

    public final void setCollectionName(String collectionName) {
        this.collection = collectionName;
    }

    public void setAction(CollectionParams.CollectionAction action) {
        this.action = action;
    }

    public void setAsyncId(String asyncId) {
        this.asyncId = asyncId;
    }

    @Override
    public SolrParams getParams() {
        if (this.action == null) {
            throw new RuntimeException("no action specified!");
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", this.action.toString());
        params.set("name", this.collection);
        return params;
    }

    @Override
    public Collection<ContentStream> getContentStreams() throws IOException {
        return null;
    }

    @Override
    public CollectionAdminResponse process(SolrServer server) throws SolrServerException, IOException {
        long startTime = TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
        CollectionAdminResponse res = new CollectionAdminResponse();
        res.setResponse(server.request(this));
        long endTime = TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
        res.setElapsedTime(endTime - startTime);
        return res;
    }

    public static CollectionAdminResponse createCollection(String name, Integer shards, Integer repl, Integer maxShards, String nodeSet, String conf, String routerField, SolrServer server) throws SolrServerException, IOException {
        return CollectionAdminRequest.createCollection(name, shards, repl, maxShards, nodeSet, conf, routerField, server, null);
    }

    public static CollectionAdminResponse createCollection(String name, Integer shards, Integer repl, Integer maxShards, String nodeSet, String conf, String routerField, SolrServer server, String asyncId) throws SolrServerException, IOException {
        Create req = new Create();
        req.setCollectionName(name);
        req.setRouterName("compositeId");
        req.setNumShards(shards);
        req.setReplicationFactor(repl);
        req.setMaxShardsPerNode(maxShards);
        req.setCreateNodeSet(nodeSet);
        req.setConfigName(conf);
        req.setRouterField(routerField);
        req.setAsyncId(asyncId);
        return req.process(server);
    }

    public static CollectionAdminResponse createCollection(String name, Integer shards, String conf, SolrServer server) throws SolrServerException, IOException {
        return CollectionAdminRequest.createCollection(name, shards, conf, server, null);
    }

    public static CollectionAdminResponse createCollection(String name, Integer shards, String conf, SolrServer server, String asyncId) throws SolrServerException, IOException {
        Create req = new Create();
        req.setCollectionName(name);
        req.setRouterName("compositeId");
        req.setNumShards(shards);
        req.setConfigName(conf);
        req.setAsyncId(asyncId);
        return req.process(server);
    }

    public static CollectionAdminResponse createCollection(String name, String shards, Integer repl, Integer maxShards, String nodeSet, String conf, String routerField, SolrServer server) throws SolrServerException, IOException {
        return CollectionAdminRequest.createCollection(name, shards, repl, maxShards, nodeSet, conf, routerField, server, null);
    }

    public static CollectionAdminResponse createCollection(String name, String shards, Integer repl, Integer maxShards, String nodeSet, String conf, String routerField, SolrServer server, String asyncId) throws SolrServerException, IOException {
        Create req = new Create();
        req.setCollectionName(name);
        req.setRouterName("implicit");
        req.setShards(shards);
        req.setReplicationFactor(repl);
        req.setMaxShardsPerNode(maxShards);
        req.setCreateNodeSet(nodeSet);
        req.setConfigName(conf);
        req.setRouterField(routerField);
        req.setAsyncId(asyncId);
        return req.process(server);
    }

    public static CollectionAdminResponse createCollection(String name, String shards, String conf, SolrServer server) throws SolrServerException, IOException {
        return CollectionAdminRequest.createCollection(name, shards, conf, server, null);
    }

    public static CollectionAdminResponse createCollection(String name, String shards, String conf, SolrServer server, String asyncId) throws SolrServerException, IOException {
        Create req = new Create();
        req.setCollectionName(name);
        req.setRouterName("implicit");
        req.setShards(shards);
        req.setConfigName(conf);
        req.setAsyncId(asyncId);
        return req.process(server);
    }

    public static CollectionAdminResponse reloadCollection(String name, SolrServer server) throws SolrServerException, IOException {
        return CollectionAdminRequest.reloadCollection(name, server, null);
    }

    public static CollectionAdminResponse reloadCollection(String name, SolrServer server, String asyncId) throws SolrServerException, IOException {
        Reload req = new Reload();
        req.setCollectionName(name);
        req.setAsyncId(asyncId);
        return ((CollectionAdminRequest)req).process(server);
    }

    public static CollectionAdminResponse deleteCollection(String name, SolrServer server) throws SolrServerException, IOException {
        return CollectionAdminRequest.deleteCollection(name, server, null);
    }

    public static CollectionAdminResponse deleteCollection(String name, SolrServer server, String asyncId) throws SolrServerException, IOException {
        Delete req = new Delete();
        req.setCollectionName(name);
        req.setAsyncId(asyncId);
        return ((CollectionAdminRequest)req).process(server);
    }

    public static CollectionAdminResponse requestStatus(String requestId, SolrServer server) throws SolrServerException, IOException {
        RequestStatus req = new RequestStatus();
        req.setRequestId(requestId);
        return req.process(server);
    }

    public static CollectionAdminResponse createShard(String name, String shard, String nodeSet, SolrServer server) throws SolrServerException, IOException {
        CreateShard req = new CreateShard();
        req.setCollectionName(name);
        req.setShardName(shard);
        req.setNodeSet(nodeSet);
        return req.process(server);
    }

    public static CollectionAdminResponse createShard(String name, String shard, SolrServer server) throws SolrServerException, IOException {
        return CollectionAdminRequest.createShard(name, shard, null, server);
    }

    public static CollectionAdminResponse splitShard(String name, String shard, String ranges, SolrServer server) throws SolrServerException, IOException {
        return CollectionAdminRequest.splitShard(name, shard, ranges, server, null);
    }

    public static CollectionAdminResponse splitShard(String name, String shard, String ranges, SolrServer server, String asyncId) throws SolrServerException, IOException {
        SplitShard req = new SplitShard();
        req.setCollectionName(name);
        req.setShardName(shard);
        req.setRanges(ranges);
        req.setAsyncId(asyncId);
        return req.process(server);
    }

    public static CollectionAdminResponse splitShard(String name, String shard, SolrServer server) throws SolrServerException, IOException {
        return CollectionAdminRequest.splitShard(name, shard, null, server, null);
    }

    public static CollectionAdminResponse splitShard(String name, String shard, SolrServer server, String asyncId) throws SolrServerException, IOException {
        return CollectionAdminRequest.splitShard(name, shard, null, server, asyncId);
    }

    public static CollectionAdminResponse deleteShard(String name, String shard, SolrServer server) throws SolrServerException, IOException {
        DeleteShard req = new DeleteShard();
        req.setCollectionName(name);
        ((CollectionShardAdminRequest)req).setShardName(shard);
        return req.process(server);
    }

    public static CollectionAdminResponse createAlias(String name, String collections, SolrServer server) throws SolrServerException, IOException {
        CreateAlias req = new CreateAlias();
        req.setCollectionName(name);
        req.setAliasedCollections(collections);
        return req.process(server);
    }

    public static CollectionAdminResponse deleteAlias(String name, SolrServer server) throws SolrServerException, IOException {
        DeleteAlias req = new DeleteAlias();
        req.setCollectionName(name);
        return ((CollectionAdminRequest)req).process(server);
    }

    public static class DeleteAlias
    extends CollectionAdminRequest {
        public DeleteAlias() {
            this.action = CollectionParams.CollectionAction.DELETEALIAS;
        }
    }

    public static class CreateAlias
    extends CollectionAdminRequest {
        protected String aliasedCollections = null;

        public void setAliasedCollections(String alias) {
            this.aliasedCollections = alias;
        }

        public String getAliasedCollections() {
            return this.aliasedCollections;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.set("collections", this.aliasedCollections);
            return params;
        }

        public CreateAlias() {
            this.action = CollectionParams.CollectionAction.CREATEALIAS;
        }
    }

    public static class RequestStatus
    extends CollectionAdminRequest {
        protected String requestId = null;

        public RequestStatus() {
            this.action = CollectionParams.CollectionAction.REQUESTSTATUS;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getRequestId() {
            return this.requestId;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.set("requestid", this.requestId);
            return params;
        }
    }

    public static class DeleteShard
    extends CollectionShardAdminRequest {
        public DeleteShard() {
            this.action = CollectionParams.CollectionAction.DELETESHARD;
        }
    }

    public static class SplitShard
    extends CollectionShardAdminRequest {
        protected String ranges;

        public void setRanges(String ranges) {
            this.ranges = ranges;
        }

        public String getRanges() {
            return this.ranges;
        }

        public SplitShard() {
            this.action = CollectionParams.CollectionAction.SPLITSHARD;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = this.getCommonParams();
            params.set("ranges", this.ranges);
            return params;
        }
    }

    public static class CreateShard
    extends CollectionShardAdminRequest {
        protected String nodeSet;

        public void setNodeSet(String nodeSet) {
            this.nodeSet = nodeSet;
        }

        public String getNodeSet() {
            return this.nodeSet;
        }

        public CreateShard() {
            this.action = CollectionParams.CollectionAction.CREATESHARD;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = this.getCommonParams();
            params.set("createNodeSet", this.nodeSet);
            return params;
        }
    }

    public static class Delete
    extends CollectionAdminRequest {
        public Delete() {
            this.action = CollectionParams.CollectionAction.DELETE;
        }
    }

    public static class Reload
    extends CollectionAdminRequest {
        public Reload() {
            this.action = CollectionParams.CollectionAction.RELOAD;
        }
    }

    public static class Create
    extends CollectionAdminRequest {
        protected String configName = null;
        protected String createNodeSet = null;
        protected String routerName;
        protected String shards;
        protected String routerField;
        protected Integer numShards;
        protected Integer maxShardsPerNode;
        protected Integer replicationFactor;

        public Create() {
            this.action = CollectionParams.CollectionAction.CREATE;
        }

        public void setConfigName(String config) {
            this.configName = config;
        }

        public void setCreateNodeSet(String nodeSet) {
            this.createNodeSet = nodeSet;
        }

        public void setRouterName(String routerName) {
            this.routerName = routerName;
        }

        public void setShards(String shards) {
            this.shards = shards;
        }

        public void setRouterField(String routerField) {
            this.routerField = routerField;
        }

        public void setNumShards(Integer numShards) {
            this.numShards = numShards;
        }

        public void setMaxShardsPerNode(Integer numShards) {
            this.maxShardsPerNode = numShards;
        }

        public void setReplicationFactor(Integer repl) {
            this.replicationFactor = repl;
        }

        public String getConfigName() {
            return this.configName;
        }

        public String getCreateNodeSet() {
            return this.createNodeSet;
        }

        public String getRouterName() {
            return this.routerName;
        }

        public String getShards() {
            return this.shards;
        }

        public Integer getNumShards() {
            return this.numShards;
        }

        public Integer getMaxShardsPerNode() {
            return this.maxShardsPerNode;
        }

        public Integer getReplicationFactor() {
            return this.replicationFactor;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            if (this.configName != null) {
                params.set("collection.configName", this.configName);
            }
            if (this.createNodeSet != null) {
                params.set("createNodeSet", this.createNodeSet);
            }
            if (this.numShards != null) {
                params.set("numShards", this.numShards);
            }
            if (this.maxShardsPerNode != null) {
                params.set("maxShardsPerNode", this.maxShardsPerNode);
            }
            if (this.routerName != null) {
                params.set("router.name", this.routerName);
            }
            if (this.shards != null) {
                params.set("shards", this.shards);
            }
            if (this.routerField != null) {
                params.set("router.field", this.routerField);
            }
            if (this.replicationFactor != null) {
                params.set("replicationFactor", this.replicationFactor);
            }
            if (this.asyncId != null) {
                params.set("async", this.asyncId);
            }
            return params;
        }
    }

    protected static class CollectionShardAdminRequest
    extends CollectionAdminRequest {
        protected String shardName = null;

        protected CollectionShardAdminRequest() {
        }

        public void setShardName(String shard) {
            this.shardName = shard;
        }

        public String getShardName() {
            return this.shardName;
        }

        public ModifiableSolrParams getCommonParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.remove("name");
            params.set("collection", this.collection);
            params.set("shard", this.shardName);
            params.set("async", this.asyncId);
            return params;
        }

        @Override
        public SolrParams getParams() {
            return this.getCommonParams();
        }
    }
}

