/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SSLOptions {
    private final List<String> _enabledProtocols;
    private final List<String> _disabledProtocols;

    public SSLOptions(String enabledProtocols, String disabledProtocols) {
        if (enabledProtocols == null) {
            enabledProtocols = System.getProperty("qpid.ssl.enabledProtocols");
        }
        if (disabledProtocols == null) {
            disabledProtocols = System.getProperty("qpid.ssl.disabledProtocols", "SSLv3");
        }
        this._enabledProtocols = enabledProtocols == null ? null : Collections.unmodifiableList(Arrays.asList(enabledProtocols.split(",")));
        this._disabledProtocols = disabledProtocols == null ? null : Collections.unmodifiableList(Arrays.asList(disabledProtocols.split(",")));
    }

    public SSLOptions(List<String> enabledProtocols, List<String> disabledProtocols) {
        this._enabledProtocols = enabledProtocols == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(enabledProtocols));
        this._disabledProtocols = disabledProtocols == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(disabledProtocols));
    }

    public List<String> getEnabledProtocols() {
        return this._enabledProtocols;
    }

    public List<String> getDisabledProtocols() {
        return this._disabledProtocols;
    }
}

