/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.jms.impl.util;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.qpid.amqp_1_0.codec.DescribedType;
import org.apache.qpid.amqp_1_0.jms.impl.util.JsonEncoder;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.Symbol;
import org.apache.qpid.amqp_1_0.type.UnsignedByte;
import org.apache.qpid.amqp_1_0.type.UnsignedInteger;
import org.apache.qpid.amqp_1_0.type.UnsignedLong;
import org.apache.qpid.amqp_1_0.type.UnsignedShort;

public class AnnotationEncoder {
    private final JsonEncoder _encoder = new JsonEncoder();

    public String encode(Map<Symbol, Object> annotations) throws IOException {
        Map<String, Object> convertedMap = this.convertMap(annotations);
        return this._encoder.encode(convertedMap);
    }

    private Map<String, Object> convertMap(Map<Symbol, Object> value) {
        LinkedHashMap<String, Object> converted = new LinkedHashMap<String, Object>();
        for (Map.Entry<Symbol, Object> entry : value.entrySet()) {
            converted.put(entry.getKey().toString(), this.convert(entry.getValue()));
        }
        return converted;
    }

    private Object convert(Object value) {
        if (value == null || value instanceof String || value instanceof Boolean || value instanceof Integer) {
            return value;
        }
        if (value instanceof Long) {
            return Collections.singletonMap("long", value);
        }
        if (value instanceof Short) {
            return Collections.singletonMap("short", value);
        }
        if (value instanceof Byte) {
            return Collections.singletonMap("byte", value);
        }
        if (value instanceof UnsignedLong) {
            return Collections.singletonMap("ulong", ((UnsignedLong)value).bigIntegerValue());
        }
        if (value instanceof UnsignedInteger) {
            return Collections.singletonMap("uint", ((UnsignedInteger)value).longValue());
        }
        if (value instanceof UnsignedShort) {
            return Collections.singletonMap("ushort", ((UnsignedShort)value).intValue());
        }
        if (value instanceof UnsignedByte) {
            return Collections.singletonMap("ubyte", ((UnsignedByte)value).shortValue());
        }
        if (value instanceof Character) {
            return Collections.singletonMap("char", value.toString());
        }
        if (value instanceof Symbol) {
            return Collections.singletonMap("symbol", value.toString());
        }
        if (value instanceof Date) {
            return Collections.singletonMap("timestamp", ((Date)value).getTime());
        }
        if (value instanceof Float) {
            return Collections.singletonMap("float", value);
        }
        if (value instanceof Double) {
            return Collections.singletonMap("double", value);
        }
        if (value instanceof Binary) {
            byte[] bytes;
            Binary bin = (Binary)value;
            if (bin.getArrayOffset() != 0 || bin.getLength() != bin.getArray().length) {
                bytes = new byte[bin.getLength()];
                System.arraycopy(bin.getArray(), bin.getArrayOffset(), bytes, 0, bin.getLength());
            } else {
                bytes = bin.getArray();
            }
            return Collections.singletonMap("binary", DatatypeConverter.printBase64Binary((byte[])bytes));
        }
        if (value instanceof List) {
            List list = (List)value;
            ArrayList<Object> convertedList = new ArrayList<Object>(list.size());
            for (Object o : list) {
                convertedList.add(this.convert(o));
            }
            return convertedList;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            LinkedHashMap<Object, Object> convertedMap = new LinkedHashMap<Object, Object>();
            for (Map.Entry entry : map.entrySet()) {
                convertedMap.put(this.convert(entry.getKey()), this.convert(entry.getValue()));
            }
            return Collections.singletonMap("map", convertedMap);
        }
        if (value instanceof Object[]) {
            return Collections.singletonMap("array", this.convert(Arrays.asList((Object[])value)));
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            ArrayList<Object> list = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                list.add(Array.get(value, i));
            }
            return Collections.singletonMap("array", this.convert(list));
        }
        if (value instanceof DescribedType) {
            DescribedType type = (DescribedType)value;
            return Collections.singletonMap("described", Collections.singletonMap(this.convert(type.getDescriptor()), this.convert(type.getDescribed())));
        }
        throw new IllegalArgumentException("Cannot convert object of class: " + value.getClass().getName());
    }
}

