/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.avro;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.parquet.avro.AvroDataSupplier;
import org.apache.parquet.avro.AvroRecordMaterializer;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.avro.SpecificDataSupplier;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;

public class AvroReadSupport<T extends IndexedRecord>
extends ReadSupport<T> {
    public static String AVRO_REQUESTED_PROJECTION = "parquet.avro.projection";
    private static final String AVRO_READ_SCHEMA = "parquet.avro.read.schema";
    static final String AVRO_SCHEMA_METADATA_KEY = "parquet.avro.schema";
    static final String OLD_AVRO_SCHEMA_METADATA_KEY = "avro.schema";
    private static final String AVRO_READ_SCHEMA_METADATA_KEY = "avro.read.schema";
    public static String AVRO_DATA_SUPPLIER = "parquet.avro.data.supplier";

    public static void setRequestedProjection(Configuration configuration, Schema requestedProjection) {
        configuration.set(AVRO_REQUESTED_PROJECTION, requestedProjection.toString());
    }

    public static void setAvroReadSchema(Configuration configuration, Schema avroReadSchema) {
        configuration.set(AVRO_READ_SCHEMA, avroReadSchema.toString());
    }

    public static void setAvroDataSupplier(Configuration configuration, Class<? extends AvroDataSupplier> clazz) {
        configuration.set(AVRO_DATA_SUPPLIER, clazz.getName());
    }

    public ReadSupport.ReadContext init(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema) {
        String avroReadSchema;
        MessageType projection = fileSchema;
        LinkedHashMap<String, String> metadata = null;
        String requestedProjectionString = configuration.get(AVRO_REQUESTED_PROJECTION);
        if (requestedProjectionString != null) {
            Schema avroRequestedProjection = new Schema.Parser().parse(requestedProjectionString);
            projection = new AvroSchemaConverter(configuration).convert(avroRequestedProjection);
        }
        if ((avroReadSchema = configuration.get(AVRO_READ_SCHEMA)) != null) {
            metadata = new LinkedHashMap<String, String>();
            metadata.put(AVRO_READ_SCHEMA_METADATA_KEY, avroReadSchema);
        }
        return new ReadSupport.ReadContext(projection, metadata);
    }

    public RecordMaterializer<T> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        MessageType parquetSchema = readContext.getRequestedSchema();
        Schema avroSchema = readContext.getReadSupportMetadata() != null && readContext.getReadSupportMetadata().get(AVRO_READ_SCHEMA_METADATA_KEY) != null ? new Schema.Parser().parse((String)readContext.getReadSupportMetadata().get(AVRO_READ_SCHEMA_METADATA_KEY)) : (keyValueMetaData.get(AVRO_SCHEMA_METADATA_KEY) != null ? new Schema.Parser().parse(keyValueMetaData.get(AVRO_SCHEMA_METADATA_KEY)) : (keyValueMetaData.get(OLD_AVRO_SCHEMA_METADATA_KEY) != null ? new Schema.Parser().parse(keyValueMetaData.get(OLD_AVRO_SCHEMA_METADATA_KEY)) : new AvroSchemaConverter(configuration).convert(parquetSchema)));
        Class suppClass = configuration.getClass(AVRO_DATA_SUPPLIER, SpecificDataSupplier.class, AvroDataSupplier.class);
        AvroDataSupplier supplier = (AvroDataSupplier)ReflectionUtils.newInstance((Class)suppClass, (Configuration)configuration);
        return new AvroRecordMaterializer(parquetSchema, avroSchema, supplier.get());
    }
}

