/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.MappingDefaults;
import org.apache.openjpa.jdbc.meta.MappingInfo;
import org.apache.openjpa.jdbc.meta.Version;
import org.apache.openjpa.jdbc.meta.strats.SuperclassVersionStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.UserException;

public class VersionMappingInfo
extends MappingInfo {
    private static final Localizer _loc = Localizer.forPackage(VersionMappingInfo.class);

    public Column[] getColumns(Version version, Column[] templates, boolean adapt) {
        if (this.spansMultipleTables(templates)) {
            return this.getMultiTableColumns(version, templates, adapt);
        }
        Table table = this.getSingleTable(version, templates);
        version.getMappingRepository().getMappingDefaults().populateColumns(version, table, templates);
        return this.createColumns(version, null, templates, table, adapt);
    }

    public Column[] getMultiTableColumns(Version vers, Column[] templates, boolean adapt) {
        Table table;
        Table primaryTable = vers.getClassMapping().getTable();
        List<DBIdentifier> secondaryTableNames = Arrays.asList(vers.getClassMapping().getMappingInfo().getSecondaryTableIdentifiers());
        LinkedHashMap assign = new LinkedHashMap();
        for (Column col : templates) {
            DBIdentifier tableName = col.getTableIdentifier();
            if (DBIdentifier.isEmpty(tableName) || tableName.equals(primaryTable.getIdentifier())) {
                table = primaryTable;
            } else if (secondaryTableNames.contains(tableName)) {
                table = primaryTable.getSchema().getTable(tableName);
            } else {
                throw new UserException(_loc.get("bad-version-column-table", (Object)col.getIdentifier().toString(), (Object)tableName));
            }
            if (!assign.containsKey(table)) {
                assign.put(table, new ArrayList());
            }
            ((List)assign.get(table)).add(col);
        }
        MappingDefaults def = vers.getMappingRepository().getMappingDefaults();
        ArrayList<Column> result = new ArrayList<Column>();
        Set assignSet = assign.entrySet();
        for (Map.Entry assignEntry : assignSet) {
            table = (Table)assignEntry.getKey();
            List cols = (List)assignEntry.getValue();
            Column[] partTemplates = cols.toArray(new Column[cols.size()]);
            def.populateColumns(vers, table, partTemplates);
            result.addAll(Arrays.asList(this.createColumns(vers, null, partTemplates, table, adapt)));
        }
        return result.toArray(new Column[result.size()]);
    }

    public Index getIndex(Version version, Column[] cols, boolean adapt) {
        Index idx = null;
        if (cols.length > 0) {
            idx = version.getMappingRepository().getMappingDefaults().getIndex(version, cols[0].getTable(), cols);
        }
        return this.createIndex(version, null, idx, cols, adapt);
    }

    public void syncWith(Version version) {
        this.clear(false);
        ClassMapping cls = version.getClassMapping();
        Column[] cols = version.getColumns();
        this.setColumnIO(version.getColumnIO());
        this.syncColumns(version, cols, false);
        this.syncIndex(version, version.getIndex());
        if (version.getStrategy() == null || version.getStrategy() instanceof SuperclassVersionStrategy) {
            return;
        }
        String strat = version.getStrategy().getAlias();
        if (!cls.isMapped() && !"none".equals(strat) || cls.isMapped() && cls.getJoinablePCSuperclassMapping() == null) {
            this.setStrategy(strat);
        }
    }

    boolean spansMultipleTables(Column[] cols) {
        if (cols == null || cols.length <= 1) {
            return false;
        }
        HashSet<DBIdentifier> tables = new HashSet<DBIdentifier>();
        for (Column col : cols) {
            if (!tables.add(col.getTableIdentifier()) || tables.size() <= 1) continue;
            return true;
        }
        return false;
    }

    private Table getSingleTable(Version version, Column[] cols) {
        if (cols == null || cols.length == 0 || DBIdentifier.isEmpty(cols[0].getTableIdentifier())) {
            return version.getClassMapping().getTable();
        }
        return version.getClassMapping().getTable().getSchema().getTable(cols[0].getTableIdentifier());
    }
}

