/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.io.File;
import java.io.PrintStream;
import java.util.List;

public class ReporterConfiguration {
    private final List reports;
    private final File reportsDirectory;
    private final PrintStream originalSystemOut;
    private final PrintStream originalSystemErr;
    private final Integer forkTimeout;
    private final Boolean trimStackTrace;
    private volatile boolean timedOut = false;

    public ReporterConfiguration(List reports, File reportsDirectory, Boolean trimStackTrace, Integer forkWithTimeout) {
        this.reports = reports;
        this.reportsDirectory = reportsDirectory;
        this.trimStackTrace = trimStackTrace;
        this.forkTimeout = forkWithTimeout;
        this.originalSystemOut = System.out;
        this.originalSystemErr = System.err;
    }

    public ReporterConfiguration(List reports, File reportsDirectory, Boolean trimStackTrace) {
        this(reports, reportsDirectory, trimStackTrace, null);
    }

    public File getReportsDirectory() {
        return this.reportsDirectory;
    }

    public Boolean isTrimStackTrace() {
        return this.trimStackTrace;
    }

    public List getReports() {
        return this.reports;
    }

    public PrintStream getOriginalSystemOut() {
        return this.originalSystemOut;
    }

    public PrintStream getOriginalSystemErr() {
        return this.originalSystemErr;
    }

    public boolean isForkWithTimeout() {
        return this.getForkTimeout() != null;
    }

    public Integer getForkTimeout() {
        return this.forkTimeout;
    }

    public void setTimedOut(boolean timedOut) {
        this.timedOut = timedOut;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }
}

