/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.io.File;
import java.io.PrintStream;
import java.util.Properties;
import org.apache.maven.plugin.surefire.report.AbstractConsoleReporter;
import org.apache.maven.plugin.surefire.report.AbstractFileReporter;
import org.apache.maven.plugin.surefire.report.BriefConsoleReporter;
import org.apache.maven.plugin.surefire.report.BriefFileReporter;
import org.apache.maven.plugin.surefire.report.ConsoleOutputDirectReporter;
import org.apache.maven.plugin.surefire.report.ConsoleOutputFileReporter;
import org.apache.maven.plugin.surefire.report.ConsoleReporter;
import org.apache.maven.plugin.surefire.report.DetailedConsoleReporter;
import org.apache.maven.plugin.surefire.report.FileReporter;
import org.apache.maven.plugin.surefire.report.Reporter;
import org.apache.maven.plugin.surefire.report.XMLReporter;
import org.apache.maven.plugin.surefire.runorder.StatisticsReporter;

public class StartupReportConfiguration {
    private final boolean useFile;
    private final boolean printSummary;
    private final String reportFormat;
    private final String reportNameSuffix;
    private final String configurationHash;
    private final boolean requiresRunHistory;
    private final boolean redirectTestOutputToFile;
    private final boolean disableXmlReport;
    private final File reportsDirectory;
    private final boolean trimStackTrace;
    private final Properties testVmSystemProperties = new Properties();
    public static final String BRIEF_REPORT_FORMAT = "brief";
    public static final String PLAIN_REPORT_FORMAT = "plain";

    public StartupReportConfiguration(boolean useFile, boolean printSummary, String reportFormat, boolean redirectTestOutputToFile, boolean disableXmlReport, File reportsDirectory, boolean trimStackTrace, String reportNameSuffix, String configurationHash, boolean requiresRunHistory) {
        this.useFile = useFile;
        this.printSummary = printSummary;
        this.reportFormat = reportFormat;
        this.redirectTestOutputToFile = redirectTestOutputToFile;
        this.disableXmlReport = disableXmlReport;
        this.reportsDirectory = reportsDirectory;
        this.trimStackTrace = trimStackTrace;
        this.reportNameSuffix = reportNameSuffix;
        this.configurationHash = configurationHash;
        this.requiresRunHistory = requiresRunHistory;
    }

    public static StartupReportConfiguration defaultValue() {
        File target = new File("./target");
        return new StartupReportConfiguration(true, true, "PLAIN", false, false, target, false, null, "TESTHASH", false);
    }

    public static StartupReportConfiguration defaultNoXml() {
        File target = new File("./target");
        return new StartupReportConfiguration(true, true, "PLAIN", false, true, target, false, null, "TESTHASHxXML", false);
    }

    public boolean isUseFile() {
        return this.useFile;
    }

    public boolean isPrintSummary() {
        return this.printSummary;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public String getReportNameSuffix() {
        return this.reportNameSuffix;
    }

    public boolean isRedirectTestOutputToFile() {
        return this.redirectTestOutputToFile;
    }

    public boolean isDisableXmlReport() {
        return this.disableXmlReport;
    }

    public File getReportsDirectory() {
        return this.reportsDirectory;
    }

    public XMLReporter instantiateXmlReporter() {
        if (!this.isDisableXmlReport()) {
            return new XMLReporter(this.trimStackTrace, this.reportsDirectory, this.reportNameSuffix);
        }
        return null;
    }

    public AbstractFileReporter instantiateFileReporter() {
        if (this.isUseFile()) {
            if (BRIEF_REPORT_FORMAT.equals(this.getReportFormat())) {
                return new BriefFileReporter(this.trimStackTrace, this.reportsDirectory, this.getReportNameSuffix());
            }
            if (PLAIN_REPORT_FORMAT.equals(this.getReportFormat())) {
                return new FileReporter(this.trimStackTrace, this.reportsDirectory, this.getReportNameSuffix());
            }
        }
        return null;
    }

    public AbstractConsoleReporter instantiateConsoleReporter() {
        if (this.isUseFile()) {
            return this.isPrintSummary() ? new ConsoleReporter(this.trimStackTrace) : null;
        }
        if (this.isRedirectTestOutputToFile() || BRIEF_REPORT_FORMAT.equals(this.getReportFormat())) {
            return new BriefConsoleReporter(this.trimStackTrace);
        }
        if (PLAIN_REPORT_FORMAT.equals(this.getReportFormat())) {
            return new DetailedConsoleReporter(this.trimStackTrace);
        }
        return null;
    }

    public Reporter instantiateConsoleOutputFileReporter(PrintStream originalSystemOut) {
        if (this.isRedirectTestOutputToFile()) {
            return new ConsoleOutputFileReporter(this.reportsDirectory, this.getReportNameSuffix());
        }
        return new ConsoleOutputDirectReporter(originalSystemOut);
    }

    public StatisticsReporter instantiateStatisticsReporter() {
        if (this.requiresRunHistory) {
            File target = this.getStatisticsFile();
            return new StatisticsReporter(target);
        }
        return null;
    }

    public File getStatisticsFile() {
        return new File(this.reportsDirectory.getParentFile().getParentFile(), ".surefire-" + this.configurationHash);
    }

    public Properties getTestVmSystemProperties() {
        return this.testVmSystemProperties;
    }

    public boolean isTrimStackTrace() {
        return this.trimStackTrace;
    }

    public String getConfigurationHash() {
        return this.configurationHash;
    }

    public boolean isRequiresRunHistory() {
        return this.requiresRunHistory;
    }
}

