/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.surefire.CommonReflector;
import org.apache.maven.plugin.surefire.StartupReportConfiguration;
import org.apache.maven.plugin.surefire.booterclient.BooterSerializer;
import org.apache.maven.plugin.surefire.booterclient.ForkConfiguration;
import org.apache.maven.plugin.surefire.booterclient.output.ForkClient;
import org.apache.maven.plugin.surefire.booterclient.output.ThreadedStreamConsumer;
import org.apache.maven.plugin.surefire.report.FileReporterFactory;
import org.apache.maven.surefire.booter.Classpath;
import org.apache.maven.surefire.booter.ClasspathConfiguration;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.ProviderFactory;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.booter.SystemPropertyManager;
import org.apache.maven.surefire.providerapi.SurefireProvider;
import org.apache.maven.surefire.report.RunStatistics;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.util.DefaultScanResult;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineTimeOutException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class ForkStarter {
    private final int forkedProcessTimeoutInSeconds;
    private final ProviderConfiguration providerConfiguration;
    private final StartupConfiguration startupConfiguration;
    private final ForkConfiguration forkConfiguration;
    private final StartupReportConfiguration startupReportConfiguration;
    private final FileReporterFactory fileReporterFactory;
    private static volatile int systemPropertiesFileCounter = 0;
    private static final Object lock = new Object();

    public ForkStarter(ProviderConfiguration providerConfiguration, StartupConfiguration startupConfiguration, ForkConfiguration forkConfiguration, int forkedProcessTimeoutInSeconds, StartupReportConfiguration startupReportConfiguration) {
        this.forkConfiguration = forkConfiguration;
        this.providerConfiguration = providerConfiguration;
        this.forkedProcessTimeoutInSeconds = forkedProcessTimeoutInSeconds;
        this.startupConfiguration = startupConfiguration;
        this.startupReportConfiguration = startupReportConfiguration;
        this.fileReporterFactory = new FileReporterFactory(startupReportConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunResult run(DefaultScanResult scanResult) throws SurefireBooterForkException, SurefireExecutionException {
        RunResult result;
        block6: {
            String requestedForkMode = this.forkConfiguration.getForkMode();
            try {
                Properties providerProperties = this.providerConfiguration.getProviderProperties();
                scanResult.writeTo(providerProperties);
                if ("once".equals(requestedForkMode)) {
                    ForkClient forkClient = new ForkClient(this.fileReporterFactory, this.startupReportConfiguration.getTestVmSystemProperties());
                    result = this.fork(null, providerProperties, forkClient, this.fileReporterFactory.getGlobalRunStatistics());
                    break block6;
                }
                if ("always".equals(requestedForkMode)) {
                    result = this.runSuitesForkPerTestSet(providerProperties, 1);
                    break block6;
                }
                if ("perthread".equals(requestedForkMode)) {
                    result = this.runSuitesForkPerTestSet(providerProperties, this.forkConfiguration.getThreadCount());
                    break block6;
                }
                throw new SurefireExecutionException("Unknown forkmode: " + requestedForkMode, null);
            }
            finally {
                this.fileReporterFactory.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunResult runSuitesForkPerTestSet(final Properties properties, int forkCount) throws SurefireBooterForkException {
        ArrayList<Future<RunResult>> results = new ArrayList<Future<RunResult>>(500);
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(forkCount, forkCount, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(500));
        try {
            RunResult globalResult = new RunResult(0, 0, 0, 0);
            Iterator suites = this.getSuitesIterator();
            while (suites.hasNext()) {
                final Object testSet = suites.next();
                final ForkClient forkClient = new ForkClient(this.fileReporterFactory, this.startupReportConfiguration.getTestVmSystemProperties());
                Callable<RunResult> pf = new Callable<RunResult>(){

                    @Override
                    public RunResult call() throws Exception {
                        return ForkStarter.this.fork(testSet, (Properties)properties.clone(), forkClient, ForkStarter.this.fileReporterFactory.getGlobalRunStatistics());
                    }
                };
                results.add(executorService.submit(pf));
            }
            for (Future future : results) {
                try {
                    RunResult cur = (RunResult)future.get();
                    if (cur != null) {
                        globalResult = globalResult.aggregate(cur);
                        continue;
                    }
                    throw new SurefireBooterForkException("No results for " + future.toString());
                }
                catch (InterruptedException e) {
                    throw new SurefireBooterForkException("Interrupted", (Throwable)e);
                }
                catch (ExecutionException e) {
                    throw new SurefireBooterForkException("ExecutionException", (Throwable)e);
                }
            }
            RunResult runResult = globalResult;
            return runResult;
        }
        finally {
            this.closeExecutor(executorService);
        }
    }

    private void closeExecutor(ExecutorService executorService) throws SurefireBooterForkException {
        executorService.shutdown();
        try {
            executorService.awaitTermination(3600L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new SurefireBooterForkException("Interrupted", (Throwable)e);
        }
    }

    private RunResult fork(Object testSet, Properties properties, ForkClient forkClient, RunStatistics globalRunStatistics) throws SurefireBooterForkException {
        RunResult runResult;
        File surefireProperties;
        File systemProperties = null;
        try {
            BooterSerializer booterSerializer = new BooterSerializer(this.forkConfiguration, properties);
            surefireProperties = booterSerializer.serialize(this.providerConfiguration, this.startupConfiguration, testSet, this.forkConfiguration.getForkMode());
            if (this.forkConfiguration.getSystemProperties() != null) {
                systemProperties = SystemPropertyManager.writePropertiesFile((Properties)this.forkConfiguration.getSystemProperties(), (File)this.forkConfiguration.getTempDirectory(), (String)("surefire_" + systemPropertiesFileCounter++), (boolean)this.forkConfiguration.isDebug());
            }
        }
        catch (IOException e) {
            throw new SurefireBooterForkException("Error creating properties files for forking", (Throwable)e);
        }
        Classpath bootClasspathConfiguration = this.forkConfiguration.getBootClasspath();
        Classpath additionlClassPathUrls = this.startupConfiguration.useSystemClassLoader() ? this.startupConfiguration.getClasspathConfiguration().getTestClasspath() : null;
        Classpath bootClasspath = Classpath.join((Classpath)bootClasspathConfiguration, (Classpath)additionlClassPathUrls);
        Commandline cli = this.forkConfiguration.createCommandLine((List<String>)bootClasspath.getClassPath(), this.startupConfiguration.getClassLoaderConfiguration(), this.startupConfiguration.isShadefire());
        cli.createArg().setFile(surefireProperties);
        if (systemProperties != null) {
            cli.createArg().setFile(systemProperties);
        }
        ThreadedStreamConsumer threadedStreamConsumer = new ThreadedStreamConsumer(forkClient);
        if (this.forkConfiguration.isDebug()) {
            System.out.println("Forking command line: " + cli);
        }
        try {
            int timeout = this.forkedProcessTimeoutInSeconds > 0 ? this.forkedProcessTimeoutInSeconds : 0;
            int result = CommandLineUtils.executeCommandLine(cli, threadedStreamConsumer, (StreamConsumer)threadedStreamConsumer, timeout);
            threadedStreamConsumer.close();
            forkClient.close();
            if (result != 0) {
                throw new SurefireBooterForkException("Error occurred in starting fork, check output in log");
            }
            runResult = globalRunStatistics.getRunResult();
        }
        catch (CommandLineTimeOutException e) {
            runResult = RunResult.Timeout;
        }
        catch (CommandLineException e) {
            throw new SurefireBooterForkException("Error while executing forked tests.", e.getCause());
        }
        return runResult;
    }

    private Iterator getSuitesIterator() throws SurefireBooterForkException {
        try {
            ClasspathConfiguration classpathConfiguration = this.startupConfiguration.getClasspathConfiguration();
            ClassLoader testsClassLoader = classpathConfiguration.createTestClassLoader(false);
            ClassLoader surefireClassLoader = classpathConfiguration.createInprocSurefireClassLoader(testsClassLoader);
            CommonReflector commonReflector = new CommonReflector(surefireClassLoader);
            Object reporterFactory = commonReflector.createReportingReporterFactory(this.startupReportConfiguration);
            ProviderFactory providerFactory = new ProviderFactory(this.startupConfiguration, this.providerConfiguration, surefireClassLoader, testsClassLoader, reporterFactory);
            SurefireProvider surefireProvider = providerFactory.createProvider(false);
            return surefireProvider.getSuites();
        }
        catch (SurefireExecutionException e) {
            throw new SurefireBooterForkException("Unable to create classloader to find test suites", (Throwable)e);
        }
    }
}

