/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.blame;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.maven.scm.command.blame.BlameLine;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.util.AbstractConsumer;
import org.apache.regexp.RE;

public class GitBlameConsumer
extends AbstractConsumer {
    private static final String GIT_TIMESTAMP_PATTERN = "yyyy-MM-dd HH:mm:ss Z";
    private static final String LINE_PATTERN = "(.*)\t\\((.*)\t(.*)\t.*\\)";
    private RE lineRegexp;
    private List lines = new ArrayList();

    public GitBlameConsumer(ScmLogger logger) {
        super(logger);
        this.lineRegexp = new RE(LINE_PATTERN);
    }

    public void consumeLine(String line) {
        if (this.lineRegexp.match(line)) {
            String revision = this.lineRegexp.getParen(1);
            String author = this.lineRegexp.getParen(2);
            String dateTimeStr = this.lineRegexp.getParen(3);
            Date dateTime = this.parseDate(dateTimeStr, null, GIT_TIMESTAMP_PATTERN);
            this.getLines().add(new BlameLine(dateTime, revision, author));
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(author + " " + dateTimeStr);
            }
        }
    }

    public List getLines() {
        return this.lines;
    }
}

