/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.EclipseSourceDir;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.AbstractEclipseManifestWriter;
import org.apache.maven.plugin.eclipse.writers.EclipseWriterConfig;
import org.apache.maven.plugin.ide.IdeUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class EclipseManifestWriter
extends AbstractEclipseManifestWriter {
    private static final String GENERATED_RESOURCE_DIRNAME = "target" + File.separatorChar + "generated-resources" + File.separatorChar + "eclipse";
    private static final String WEBAPP_RESOURCE_DIR = "src" + File.separatorChar + "main" + File.separatorChar + "webapp";

    private static String getWebContentBaseDirectory(EclipseWriterConfig config) throws MojoExecutionException {
        File warSourceDirectory = new File(IdeUtils.getPluginSetting(config.getProject(), "org.apache.maven.plugins:maven-war-plugin", "warSourceDirectory", WEBAPP_RESOURCE_DIR));
        String webContentDir = IdeUtils.toRelativeAndFixSeparator(config.getEclipseProjectDirectory(), warSourceDirectory, false);
        String result = config.getProject().getBasedir().getAbsolutePath() + File.separatorChar + webContentDir;
        return result;
    }

    protected String getMetaInfBaseDirectory(MavenProject project) throws MojoExecutionException {
        String metaInfBaseDirectory = null;
        if (this.config.getProject().getPackaging().equals("war")) {
            metaInfBaseDirectory = EclipseManifestWriter.getWebContentBaseDirectory(this.config);
            this.log.debug((CharSequence)("Attempting to use: " + metaInfBaseDirectory + " for location of META-INF in war project."));
            File metaInfDirectoryFile = new File(metaInfBaseDirectory + File.separatorChar + "META-INF");
            if (!metaInfDirectoryFile.exists() || metaInfDirectoryFile.exists() && !metaInfDirectoryFile.isDirectory()) {
                metaInfBaseDirectory = null;
            }
        }
        for (int index = this.config.getSourceDirs().length - 1; metaInfBaseDirectory == null && index >= 0; --index) {
            File manifestFile = new File(this.config.getEclipseProjectDirectory(), this.config.getSourceDirs()[index].getPath() + File.separatorChar + "META-INF" + File.separatorChar + "MANIFEST.MF");
            this.log.debug((CharSequence)("Checking for existence of META-INF/MANIFEST.MF file: " + manifestFile));
            if (!manifestFile.exists()) continue;
            metaInfBaseDirectory = manifestFile.getParentFile().getParent();
        }
        return metaInfBaseDirectory;
    }

    public static void addManifestResource(Log log, EclipseWriterConfig config) throws MojoExecutionException {
        EclipseManifestWriter manifestWriter = new EclipseManifestWriter();
        manifestWriter.init(log, config);
        String packaging = config.getProject().getPackaging();
        String manifestDirectory = ((AbstractEclipseManifestWriter)manifestWriter).getMetaInfBaseDirectory(config.getProject());
        if (!"ear".equals(packaging) && !"war".equals(packaging) && manifestDirectory == null) {
            String generatedResourceDir = config.getProject().getBasedir().getAbsolutePath() + File.separatorChar + GENERATED_RESOURCE_DIRNAME;
            manifestDirectory = generatedResourceDir + File.separatorChar + "META-INF";
            try {
                new File(manifestDirectory).mkdirs();
                File manifestFile = new File(manifestDirectory + File.separatorChar + "MANIFEST.MF");
                if (manifestFile.exists()) {
                    manifestFile.delete();
                }
                manifestFile.createNewFile();
            }
            catch (IOException e) {
                log.error((CharSequence)Messages.getString("EclipsePlugin.cantwritetofile", new Object[]{manifestDirectory + File.separatorChar + "META-INF" + File.separatorChar + "MANIFEST.MF"}));
            }
            log.debug((CharSequence)("Adding " + GENERATED_RESOURCE_DIRNAME + " to eclipse sources "));
            EclipseSourceDir[] sourceDirs = config.getSourceDirs();
            EclipseSourceDir[] newSourceDirs = new EclipseSourceDir[sourceDirs.length + 1];
            System.arraycopy(sourceDirs, 0, newSourceDirs, 0, sourceDirs.length);
            newSourceDirs[sourceDirs.length] = new EclipseSourceDir(GENERATED_RESOURCE_DIRNAME, null, true, false, null, null, false);
            config.setSourceDirs(newSourceDirs);
        }
        if ("war".equals(packaging)) {
            new File(EclipseManifestWriter.getWebContentBaseDirectory(config) + File.separatorChar + "META-INF").mkdirs();
        }
        manifestWriter.write();
    }
}

