/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.checkstyle;

import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.DefaultConfiguration;
import com.puppycrawl.tools.checkstyle.PackageNamesLoader;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.api.FilterSet;
import com.puppycrawl.tools.checkstyle.filters.SuppressionsLoader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.checkstyle.CheckstyleExecutor;
import org.apache.maven.plugin.checkstyle.CheckstyleExecutorException;
import org.apache.maven.plugin.checkstyle.CheckstyleExecutorRequest;
import org.apache.maven.plugin.checkstyle.CheckstyleReportListener;
import org.apache.maven.plugin.checkstyle.CheckstyleResults;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.FileResourceCreationException;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=CheckstyleExecutor.class, hint="default", instantiationStrategy="per-lookup")
public class DefaultCheckstyleExecutor
extends AbstractLogEnabled
implements CheckstyleExecutor {
    @Requirement(hint="default")
    private ResourceManager locator;
    @Requirement(hint="license")
    private ResourceManager licenseLocator;
    private static final File[] EMPTY_FILE_ARRAY = new File[0];

    @Override
    public CheckstyleResults executeCheckstyle(CheckstyleExecutorRequest request) throws CheckstyleExecutorException, CheckstyleException {
        File[] files;
        ClassLoader checkstyleClassLoader = PackageNamesLoader.class.getClassLoader();
        Thread.currentThread().setContextClassLoader(checkstyleClassLoader);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("executeCheckstyle start headerLocation : " + request.getHeaderLocation());
        }
        MavenProject project = request.getProject();
        this.configureResourceLocator(this.locator, request, null);
        this.configureResourceLocator(this.licenseLocator, request, request.getLicenseArtifacts());
        try {
            files = this.getFilesToProcess(request);
        }
        catch (IOException e) {
            throw new CheckstyleExecutorException("Error getting files to process", e);
        }
        String suppressionsFilePath = this.getSuppressionsFilePath(request);
        FilterSet filterSet = this.getSuppressionsFilterSet(suppressionsFilePath);
        Checker checker = new Checker();
        ArrayList<String> classPathStrings = new ArrayList<String>();
        ArrayList<String> outputDirectories = new ArrayList<String>();
        File sourceDirectory = request.getSourceDirectory();
        File testSourceDirectory = request.getTestSourceDirectory();
        if (request.isAggregate()) {
            for (MavenProject childProject : request.getReactorProjects()) {
                this.prepareCheckstylePaths(request, childProject, classPathStrings, outputDirectories, new File(childProject.getBuild().getSourceDirectory()), new File(childProject.getBuild().getTestSourceDirectory()));
            }
        } else {
            this.prepareCheckstylePaths(request, project, classPathStrings, outputDirectories, sourceDirectory, testSourceDirectory);
        }
        ArrayList<URL> urls = new ArrayList<URL>(classPathStrings.size());
        for (String path : classPathStrings) {
            try {
                urls.add(new File(path).toURL());
            }
            catch (MalformedURLException e) {
                throw new CheckstyleExecutorException(e.getMessage(), e);
            }
        }
        for (String outputDirectoryString : outputDirectories) {
            try {
                File outputDirectoryFile;
                if (outputDirectoryString == null || !(outputDirectoryFile = new File(outputDirectoryString)).exists()) continue;
                URL outputDirectoryUrl = outputDirectoryFile.toURL();
                request.getLog().debug((CharSequence)("Adding the outputDirectory " + outputDirectoryUrl.toString() + " to the Checkstyle class path"));
                urls.add(outputDirectoryUrl);
            }
            catch (MalformedURLException e) {
                throw new CheckstyleExecutorException(e.getMessage(), e);
            }
        }
        URLClassLoader projectClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), null);
        checker.setClassloader((ClassLoader)projectClassLoader);
        checker.setModuleClassLoader(Thread.currentThread().getContextClassLoader());
        if (filterSet != null) {
            checker.addFilter((Filter)filterSet);
        }
        Configuration configuration = this.getConfiguration(request);
        checker.configure(configuration);
        AuditListener listener = request.getListener();
        if (listener != null) {
            checker.addListener(listener);
        }
        if (request.isConsoleOutput()) {
            checker.addListener((AuditListener)request.getConsoleListener());
        }
        CheckstyleReportListener sinkListener = new CheckstyleReportListener(configuration);
        if (request.isAggregate()) {
            for (MavenProject childProject : request.getReactorProjects()) {
                this.addSourceDirectory(sinkListener, new File(childProject.getBuild().getSourceDirectory()), new File(childProject.getBuild().getTestSourceDirectory()), childProject.getResources(), request);
            }
        } else {
            this.addSourceDirectory(sinkListener, sourceDirectory, testSourceDirectory, request.getResources(), request);
        }
        checker.addListener((AuditListener)sinkListener);
        List<File> filesList = Arrays.asList(files);
        int nbErrors = checker.process(filesList);
        checker.destroy();
        if (projectClassLoader instanceof Closeable) {
            try {
                ((Closeable)projectClassLoader).close();
            }
            catch (IOException ex) {
                this.getLogger().info("Failed to close custom Classloader - this indicated a bug in the code.", (Throwable)ex);
            }
        }
        if (request.getStringOutputStream() != null) {
            request.getLog().info((CharSequence)request.getStringOutputStream().toString());
        }
        if (request.isFailsOnError() && nbErrors > 0) {
            throw new CheckstyleExecutorException("There are " + nbErrors + " checkstyle errors.");
        }
        if (nbErrors > 0) {
            request.getLog().info((CharSequence)("There are " + nbErrors + " checkstyle errors."));
        }
        return sinkListener.getResults();
    }

    protected void addSourceDirectory(CheckstyleReportListener sinkListener, File sourceDirectory, File testSourceDirectory, List<Resource> resources, CheckstyleExecutorRequest request) {
        if (sourceDirectory != null) {
            sinkListener.addSourceDirectory(sourceDirectory);
        }
        if (request.isIncludeTestSourceDirectory() && testSourceDirectory != null && testSourceDirectory.exists() && testSourceDirectory.isDirectory()) {
            sinkListener.addSourceDirectory(testSourceDirectory);
        }
        if (resources != null) {
            for (Resource resource : resources) {
                File resourcesDirectory;
                if (resource.getDirectory() == null || !(resourcesDirectory = new File(resource.getDirectory())).exists() || !resourcesDirectory.isDirectory()) continue;
                sinkListener.addSourceDirectory(resourcesDirectory);
                this.getLogger().debug("Added '" + resourcesDirectory.getAbsolutePath() + "' as a source directory.");
            }
        }
    }

    public Configuration getConfiguration(CheckstyleExecutorRequest request) throws CheckstyleExecutorException {
        try {
            Configuration[] modules;
            String effectiveEncoding;
            ClassLoader checkstyleClassLoader = PackageNamesLoader.class.getClassLoader();
            Thread.currentThread().setContextClassLoader(checkstyleClassLoader);
            String configFile = this.getConfigFile(request);
            Properties overridingProperties = this.getOverridingProperties(request);
            Configuration config = ConfigurationLoader.loadConfiguration((String)configFile, (PropertyResolver)new PropertiesExpander(overridingProperties));
            String string = effectiveEncoding = StringUtils.isNotEmpty((String)request.getEncoding()) ? request.getEncoding() : System.getProperty("file.encoding", "UTF-8");
            if (StringUtils.isEmpty((String)request.getEncoding())) {
                request.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + effectiveEncoding + ", i.e. build is platform dependent!"));
            }
            if ("Checker".equals(config.getName()) || "com.puppycrawl.tools.checkstyle.Checker".equals(config.getName())) {
                if (config instanceof DefaultConfiguration) {
                    try {
                        if (config.getAttribute("charset") == null) {
                            ((DefaultConfiguration)config).addAttribute("charset", effectiveEncoding);
                        }
                    }
                    catch (CheckstyleException ex) {
                        ((DefaultConfiguration)config).addAttribute("charset", effectiveEncoding);
                    }
                } else {
                    request.getLog().warn((CharSequence)("Failed to configure file encoding on module " + config));
                }
            }
            for (Configuration module : modules = config.getChildren()) {
                if (!"TreeWalker".equals(module.getName()) && !"com.puppycrawl.tools.checkstyle.TreeWalker".equals(module.getName())) continue;
                if (module instanceof DefaultConfiguration) {
                    try {
                        if (module.getAttribute("cacheFile") != null) continue;
                        ((DefaultConfiguration)module).addAttribute("cacheFile", request.getCacheFile());
                    }
                    catch (CheckstyleException ex) {
                        ((DefaultConfiguration)module).addAttribute("cacheFile", request.getCacheFile());
                    }
                    continue;
                }
                request.getLog().warn((CharSequence)("Failed to configure cache file on module " + module));
            }
            return config;
        }
        catch (CheckstyleException e) {
            throw new CheckstyleExecutorException("Failed during checkstyle configuration", e);
        }
    }

    private void prepareCheckstylePaths(CheckstyleExecutorRequest request, MavenProject project, List<String> classPathStrings, List<String> outputDirectories, File sourceDirectory, File testSourceDirectory) throws CheckstyleExecutorException {
        try {
            outputDirectories.add(project.getBuild().getOutputDirectory());
            if (request.isIncludeTestSourceDirectory() && testSourceDirectory != null && testSourceDirectory.exists() && testSourceDirectory.isDirectory()) {
                classPathStrings.addAll(project.getTestClasspathElements());
                outputDirectories.add(project.getBuild().getTestOutputDirectory());
            } else {
                classPathStrings.addAll(project.getCompileClasspathElements());
            }
        }
        catch (DependencyResolutionRequiredException e) {
            throw new CheckstyleExecutorException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getOverridingProperties(CheckstyleExecutorRequest request) throws CheckstyleExecutorException {
        String suppressionsFilePath;
        Properties p = new Properties();
        try {
            if (request.getPropertiesLocation() != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("request.getPropertiesLocation() " + request.getPropertiesLocation());
                }
                File propertiesFile = this.locator.getResourceAsFile(request.getPropertiesLocation(), "checkstyle-checker.properties");
                FileInputStream properties = new FileInputStream(propertiesFile);
                try {
                    if (propertiesFile != null) {
                        p.load(properties);
                    }
                }
                finally {
                    IOUtils.closeQuietly((InputStream)properties);
                }
            }
            if (StringUtils.isNotEmpty((String)request.getPropertyExpansion())) {
                String propertyExpansion = request.getPropertyExpansion();
                propertyExpansion = StringUtils.replace((String)propertyExpansion, (String)"\\", (String)"\\\\");
                p.load(new ByteArrayInputStream(propertyExpansion.getBytes()));
            }
            String headerLocation = request.getHeaderLocation();
            if ("config/maven_checks.xml".equals(request.getConfigLocation()) && "LICENSE.txt".equals(request.getHeaderLocation())) {
                headerLocation = "config/maven-header.txt";
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("headerLocation " + headerLocation);
            }
            if (StringUtils.isNotEmpty((String)headerLocation)) {
                try {
                    File headerFile = this.licenseLocator.getResourceAsFile(headerLocation, "checkstyle-header.txt");
                    if (headerFile != null) {
                        p.setProperty("checkstyle.header.file", headerFile.getAbsolutePath());
                    }
                }
                catch (FileResourceCreationException e) {
                    this.getLogger().debug("Unable to process header location: " + headerLocation);
                    this.getLogger().debug("Checkstyle will throw exception if ${checkstyle.header.file} is used");
                }
                catch (ResourceNotFoundException e) {
                    this.getLogger().debug("Unable to process header location: " + headerLocation);
                    this.getLogger().debug("Checkstyle will throw exception if ${checkstyle.header.file} is used");
                }
            }
            if (request.getCacheFile() != null) {
                p.setProperty("checkstyle.cache.file", request.getCacheFile());
            }
        }
        catch (IOException e) {
            throw new CheckstyleExecutorException("Failed to get overriding properties", e);
        }
        catch (FileResourceCreationException e) {
            throw new CheckstyleExecutorException("Failed to get overriding properties", e);
        }
        catch (ResourceNotFoundException e) {
            throw new CheckstyleExecutorException("Failed to get overriding properties", e);
        }
        if (request.getSuppressionsFileExpression() != null && (suppressionsFilePath = this.getSuppressionsFilePath(request)) != null) {
            p.setProperty(request.getSuppressionsFileExpression(), suppressionsFilePath);
        }
        return p;
    }

    private File[] getFilesToProcess(CheckstyleExecutorRequest request) throws IOException {
        String[] defaultExcludes;
        StringBuilder excludesStr = new StringBuilder();
        if (StringUtils.isNotEmpty((String)request.getExcludes())) {
            excludesStr.append(request.getExcludes());
        }
        for (String defaultExclude : defaultExcludes = FileUtils.getDefaultExcludes()) {
            if (excludesStr.length() > 0) {
                excludesStr.append(",");
            }
            excludesStr.append(defaultExclude);
        }
        File sourceDirectory = request.getSourceDirectory();
        ArrayList<File> files = new ArrayList<File>();
        if (request.isAggregate()) {
            for (MavenProject project : request.getReactorProjects()) {
                this.addFilesToProcess(request, new File(project.getBuild().getSourceDirectory()), project.getResources(), project.getTestResources(), files, new File(project.getBuild().getTestSourceDirectory()));
            }
        } else {
            this.addFilesToProcess(request, sourceDirectory, request.getResources(), request.getTestResources(), files, request.getTestSourceDirectory());
        }
        this.getLogger().debug("Added " + files.size() + " files to process.");
        return files.toArray(new File[files.size()]);
    }

    private void addFilesToProcess(CheckstyleExecutorRequest request, File sourceDirectory, List<Resource> resources, List<Resource> testResources, List<File> files, File testSourceDirectory) throws IOException {
        if (sourceDirectory != null && sourceDirectory.exists()) {
            List sourceFiles = FileUtils.getFiles((File)sourceDirectory, (String)request.getIncludes(), (String)request.getExcludes());
            files.addAll(sourceFiles);
            this.getLogger().debug("Added " + sourceFiles.size() + " source files found in '" + sourceDirectory.getAbsolutePath() + "'.");
        }
        if (request.isIncludeTestSourceDirectory() && testSourceDirectory != null && testSourceDirectory.exists() && testSourceDirectory.isDirectory()) {
            List testSourceFiles = FileUtils.getFiles((File)testSourceDirectory, (String)request.getIncludes(), (String)request.getExcludes());
            files.addAll(testSourceFiles);
            this.getLogger().debug("Added " + testSourceFiles.size() + " test source files found in '" + testSourceDirectory.getAbsolutePath() + "'.");
        }
        if (resources != null && request.isIncludeResources()) {
            this.addResourceFilesToProcess(request, resources, files);
        } else {
            this.getLogger().debug("No resources found in this project.");
        }
        if (testResources != null && request.isIncludeTestResources()) {
            this.addResourceFilesToProcess(request, testResources, files);
        } else {
            this.getLogger().debug("No test resources found in this project.");
        }
    }

    private void addResourceFilesToProcess(CheckstyleExecutorRequest request, List<Resource> resources, List<File> files) throws IOException {
        for (Resource resource : resources) {
            if (resource.getDirectory() == null) continue;
            File resourcesDirectory = new File(resource.getDirectory());
            if (resourcesDirectory.exists() && resourcesDirectory.isDirectory()) {
                List resourceFiles = FileUtils.getFiles((File)resourcesDirectory, (String)request.getResourceIncludes(), (String)request.getResourceExcludes());
                files.addAll(resourceFiles);
                this.getLogger().debug("Added " + resourceFiles.size() + " resource files found in '" + resourcesDirectory.getAbsolutePath() + "'.");
                continue;
            }
            this.getLogger().debug("The resources directory '" + resourcesDirectory.getAbsolutePath() + "' does not exist or is not a directory.");
        }
    }

    private FilterSet getSuppressionsFilterSet(String suppressionsFilePath) throws CheckstyleExecutorException {
        if (suppressionsFilePath == null) {
            return null;
        }
        try {
            return SuppressionsLoader.loadSuppressions((String)suppressionsFilePath);
        }
        catch (CheckstyleException ce) {
            throw new CheckstyleExecutorException("Failed to load suppressions file from: " + suppressionsFilePath, ce);
        }
    }

    private String getSuppressionsFilePath(CheckstyleExecutorRequest request) throws CheckstyleExecutorException {
        String suppressionsLocation = request.getSuppressionsLocation();
        if (StringUtils.isEmpty((String)suppressionsLocation)) {
            return null;
        }
        try {
            File suppressionsFile = this.locator.getResourceAsFile(suppressionsLocation, "checkstyle-suppressions.xml");
            return suppressionsFile == null ? null : suppressionsFile.getAbsolutePath();
        }
        catch (ResourceNotFoundException e) {
            throw new CheckstyleExecutorException("Unable to find suppressions file at location: " + suppressionsLocation, e);
        }
        catch (FileResourceCreationException e) {
            throw new CheckstyleExecutorException("Unable to process suppressions file location: " + suppressionsLocation, e);
        }
    }

    private String getConfigFile(CheckstyleExecutorRequest request) throws CheckstyleExecutorException {
        try {
            File configFile;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("request.getConfigLocation() " + request.getConfigLocation());
            }
            if ((configFile = this.locator.getResourceAsFile(request.getConfigLocation(), "checkstyle-checker.xml")) == null) {
                throw new CheckstyleExecutorException("Unable to process config location: " + request.getConfigLocation());
            }
            return configFile.getAbsolutePath();
        }
        catch (ResourceNotFoundException e) {
            throw new CheckstyleExecutorException("Unable to find configuration file at location: " + request.getConfigLocation(), e);
        }
        catch (FileResourceCreationException e) {
            throw new CheckstyleExecutorException("Unable to process configuration file at location: " + request.getConfigLocation(), e);
        }
    }

    private void configureResourceLocator(ResourceManager resourceManager, CheckstyleExecutorRequest request, List<Artifact> additionalArtifacts) {
        MavenProject project = request.getProject();
        resourceManager.setOutputDirectory(new File(project.getBuild().getDirectory()));
        for (MavenProject parent = project; parent != null && parent.getFile() != null; parent = parent.getParent()) {
            File dir = parent.getFile().getParentFile();
            resourceManager.addSearchPath("file", dir.getAbsolutePath());
        }
        resourceManager.addSearchPath("url", "");
        if (additionalArtifacts != null) {
            for (Artifact licenseArtifact : additionalArtifacts) {
                try {
                    resourceManager.addSearchPath("jar", "jar:" + licenseArtifact.getFile().toURI().toURL());
                }
                catch (MalformedURLException e) {}
            }
        }
    }
}

