/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.expressions;

import java.io.IOException;
import java.util.HashMap;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.Scorer;

class ExpressionComparator
extends FieldComparator<Double> {
    private final double[] values;
    private double bottom;
    private double topValue;
    private ValueSource source;
    private FunctionValues scores;
    private AtomicReaderContext readerContext;

    public ExpressionComparator(ValueSource source, int numHits) {
        this.values = new double[numHits];
        this.source = source;
    }

    public void setScorer(Scorer scorer) {
        super.setScorer(scorer);
        assert (this.readerContext != null);
        try {
            HashMap<String, Scorer> context = new HashMap<String, Scorer>();
            assert (scorer != null);
            context.put("scorer", scorer);
            this.scores = this.source.getValues(context, this.readerContext);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int compare(int slot1, int slot2) {
        return Double.compare(this.values[slot1], this.values[slot2]);
    }

    public void setBottom(int slot) {
        this.bottom = this.values[slot];
    }

    public void setTopValue(Double value) {
        this.topValue = value;
    }

    public int compareBottom(int doc) throws IOException {
        return Double.compare(this.bottom, this.scores.doubleVal(doc));
    }

    public void copy(int slot, int doc) throws IOException {
        this.values[slot] = this.scores.doubleVal(doc);
    }

    public FieldComparator<Double> setNextReader(AtomicReaderContext context) throws IOException {
        this.readerContext = context;
        return this;
    }

    public Double value(int slot) {
        return this.values[slot];
    }

    public int compareTop(int doc) throws IOException {
        return Double.compare(this.topValue, this.scores.doubleVal(doc));
    }
}

