/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.memory;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.MathUtil;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;
import org.apache.lucene.util.packed.BlockPackedWriter;
import org.apache.lucene.util.packed.MonotonicBlockPackedWriter;
import org.apache.lucene.util.packed.PackedInts;

class MemoryDocValuesConsumer
extends DocValuesConsumer {
    IndexOutput data;
    IndexOutput meta;
    final int maxDoc;
    final float acceptableOverheadRatio;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    MemoryDocValuesConsumer(SegmentWriteState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension, float acceptableOverheadRatio) throws IOException {
        this.acceptableOverheadRatio = acceptableOverheadRatio;
        this.maxDoc = state.segmentInfo.getDocCount();
        boolean success = false;
        try {
            String dataName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)dataExtension);
            this.data = state.directory.createOutput(dataName, state.context);
            CodecUtil.writeHeader((DataOutput)this.data, (String)dataCodec, (int)2);
            String metaName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)metaExtension);
            this.meta = state.directory.createOutput(metaName, state.context);
            CodecUtil.writeHeader((DataOutput)this.meta, (String)metaCodec, (int)2);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this});
            throw throwable;
        }
    }

    public void addNumericField(FieldInfo field, Iterable<Number> values) throws IOException {
        this.addNumericField(field, values, true);
    }

    void addNumericField(FieldInfo field, Iterable<Number> values, boolean optimizeStorage) throws IOException {
        this.meta.writeVInt(field.number);
        this.meta.writeByte((byte)0);
        this.meta.writeLong(this.data.getFilePointer());
        long minValue = Long.MAX_VALUE;
        long maxValue = Long.MIN_VALUE;
        long gcd = 0L;
        boolean missing = false;
        HashSet<Long> uniqueValues = null;
        if (optimizeStorage) {
            uniqueValues = new HashSet<Long>();
            long count = 0L;
            for (Number nv : values) {
                long v;
                if (nv == null) {
                    v = 0L;
                    missing = true;
                } else {
                    v = nv.longValue();
                }
                if (gcd != 1L) {
                    if (v < -4611686018427387904L || v > 0x3FFFFFFFFFFFFFFFL) {
                        gcd = 1L;
                    } else if (count != 0L) {
                        gcd = MathUtil.gcd((long)gcd, (long)(v - minValue));
                    }
                }
                minValue = Math.min(minValue, v);
                maxValue = Math.max(maxValue, v);
                if (uniqueValues != null && uniqueValues.add(v) && uniqueValues.size() > 256) {
                    uniqueValues = null;
                }
                ++count;
            }
            assert (count == (long)this.maxDoc);
        }
        if (missing) {
            long start = this.data.getFilePointer();
            this.writeMissingBitset(values);
            this.meta.writeLong(start);
            this.meta.writeLong(this.data.getFilePointer() - start);
        } else {
            this.meta.writeLong(-1L);
        }
        if (uniqueValues != null) {
            int bitsPerValue = PackedInts.bitsRequired((long)(uniqueValues.size() - 1));
            PackedInts.FormatAndBits formatAndBits = PackedInts.fastestFormatAndBits((int)this.maxDoc, (int)bitsPerValue, (float)this.acceptableOverheadRatio);
            if (formatAndBits.bitsPerValue == 8 && minValue >= -128L && maxValue <= 127L) {
                this.meta.writeByte((byte)2);
                for (Number nv : values) {
                    this.data.writeByte(nv == null ? (byte)0 : (byte)nv.longValue());
                }
            } else {
                this.meta.writeByte((byte)1);
                Long[] decode = uniqueValues.toArray(new Long[uniqueValues.size()]);
                HashMap<Long, Integer> encode = new HashMap<Long, Integer>();
                this.data.writeVInt(decode.length);
                for (int i = 0; i < decode.length; ++i) {
                    this.data.writeLong(decode[i].longValue());
                    encode.put(decode[i], i);
                }
                this.meta.writeVInt(1);
                this.data.writeVInt(formatAndBits.format.getId());
                this.data.writeVInt(formatAndBits.bitsPerValue);
                PackedInts.Writer writer = PackedInts.getWriterNoHeader((DataOutput)this.data, (PackedInts.Format)formatAndBits.format, (int)this.maxDoc, (int)formatAndBits.bitsPerValue, (int)1024);
                for (Number nv : values) {
                    writer.add((long)((Integer)encode.get(nv == null ? 0L : nv.longValue())).intValue());
                }
                writer.finish();
            }
        } else if (gcd != 0L && gcd != 1L) {
            this.meta.writeByte((byte)3);
            this.meta.writeVInt(1);
            this.data.writeLong(minValue);
            this.data.writeLong(gcd);
            this.data.writeVInt(4096);
            BlockPackedWriter writer = new BlockPackedWriter((DataOutput)this.data, 4096);
            for (Number nv : values) {
                long value = nv == null ? 0L : nv.longValue();
                writer.add((value - minValue) / gcd);
            }
            writer.finish();
        } else {
            this.meta.writeByte((byte)0);
            this.meta.writeVInt(1);
            this.data.writeVInt(4096);
            BlockPackedWriter writer = new BlockPackedWriter((DataOutput)this.data, 4096);
            for (Number nv : values) {
                writer.add(nv == null ? 0L : nv.longValue());
            }
            writer.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        block7: {
            block6: {
                boolean success = false;
                try {
                    if (this.meta != null) {
                        this.meta.writeVInt(-1);
                        CodecUtil.writeFooter((IndexOutput)this.meta);
                    }
                    if (this.data != null) {
                        CodecUtil.writeFooter((IndexOutput)this.data);
                    }
                    if (!(success = true)) break block6;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{this.data, this.meta});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.data, this.meta});
                    }
                    this.meta = null;
                    this.data = null;
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{this.data, this.meta});
                break block7;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.data, this.meta});
        }
        this.meta = null;
        this.data = null;
    }

    public void addBinaryField(FieldInfo field, Iterable<BytesRef> values) throws IOException {
        this.meta.writeVInt(field.number);
        this.meta.writeByte((byte)1);
        int minLength = Integer.MAX_VALUE;
        int maxLength = Integer.MIN_VALUE;
        long startFP = this.data.getFilePointer();
        boolean missing = false;
        for (BytesRef v : values) {
            int length;
            if (v == null) {
                length = 0;
                missing = true;
            } else {
                length = v.length;
            }
            if (length > 32766) {
                throw new IllegalArgumentException("DocValuesField \"" + field.name + "\" is too large, must be <= " + 32766);
            }
            minLength = Math.min(minLength, length);
            maxLength = Math.max(maxLength, length);
            if (v == null) continue;
            this.data.writeBytes(v.bytes, v.offset, v.length);
        }
        this.meta.writeLong(startFP);
        this.meta.writeLong(this.data.getFilePointer() - startFP);
        if (missing) {
            long start = this.data.getFilePointer();
            this.writeMissingBitset(values);
            this.meta.writeLong(start);
            this.meta.writeLong(this.data.getFilePointer() - start);
        } else {
            this.meta.writeLong(-1L);
        }
        this.meta.writeVInt(minLength);
        this.meta.writeVInt(maxLength);
        if (minLength != maxLength) {
            this.meta.writeVInt(1);
            this.meta.writeVInt(4096);
            MonotonicBlockPackedWriter writer = new MonotonicBlockPackedWriter((DataOutput)this.data, 4096);
            long addr = 0L;
            for (BytesRef v : values) {
                if (v != null) {
                    addr += (long)v.length;
                }
                writer.add(addr);
            }
            writer.finish();
        }
    }

    private void writeFST(FieldInfo field, Iterable<BytesRef> values) throws IOException {
        this.meta.writeVInt(field.number);
        this.meta.writeByte((byte)2);
        this.meta.writeLong(this.data.getFilePointer());
        PositiveIntOutputs outputs = PositiveIntOutputs.getSingleton();
        Builder builder = new Builder(FST.INPUT_TYPE.BYTE1, (Outputs)outputs);
        IntsRef scratch = new IntsRef();
        long ord = 0L;
        for (BytesRef v : values) {
            builder.add(Util.toIntsRef((BytesRef)v, (IntsRef)scratch), (Object)ord);
            ++ord;
        }
        FST fst = builder.finish();
        if (fst != null) {
            fst.save((DataOutput)this.data);
        }
        this.meta.writeVLong(ord);
    }

    void writeMissingBitset(Iterable<?> values) throws IOException {
        long bits = 0L;
        int count = 0;
        for (Object v : values) {
            if (count == 64) {
                this.data.writeLong(bits);
                count = 0;
                bits = 0L;
            }
            if (v != null) {
                bits |= 1L << (count & 0x3F);
            }
            ++count;
        }
        if (count > 0) {
            this.data.writeLong(bits);
        }
    }

    public void addSortedField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrd) throws IOException {
        this.addNumericField(field, docToOrd, false);
        this.writeFST(field, values);
    }

    public void addSortedSetField(FieldInfo field, Iterable<BytesRef> values, final Iterable<Number> docToOrdCount, final Iterable<Number> ords) throws IOException {
        this.addBinaryField(field, new Iterable<BytesRef>(){

            @Override
            public Iterator<BytesRef> iterator() {
                return new SortedSetIterator(docToOrdCount.iterator(), ords.iterator());
            }
        });
        this.writeFST(field, values);
    }

    static class SortedSetIterator
    implements Iterator<BytesRef> {
        byte[] buffer = new byte[10];
        ByteArrayDataOutput out = new ByteArrayDataOutput();
        BytesRef ref = new BytesRef();
        final Iterator<Number> counts;
        final Iterator<Number> ords;

        SortedSetIterator(Iterator<Number> counts, Iterator<Number> ords) {
            this.counts = counts;
            this.ords = ords;
        }

        @Override
        public boolean hasNext() {
            return this.counts.hasNext();
        }

        @Override
        public BytesRef next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int count = this.counts.next().intValue();
            int maxSize = count * 9;
            if (maxSize > this.buffer.length) {
                this.buffer = ArrayUtil.grow((byte[])this.buffer, (int)maxSize);
            }
            try {
                this.encodeValues(count);
            }
            catch (IOException bogus) {
                throw new RuntimeException(bogus);
            }
            this.ref.bytes = this.buffer;
            this.ref.offset = 0;
            this.ref.length = this.out.getPosition();
            return this.ref;
        }

        private void encodeValues(int count) throws IOException {
            this.out.reset(this.buffer);
            long lastOrd = 0L;
            for (int i = 0; i < count; ++i) {
                long ord = this.ords.next().longValue();
                this.out.writeVLong(ord - lastOrd);
                lastOrd = ord;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

