/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.avro;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.server.UID;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.hadoop.io.Writable;

public class AvroGenericRecordWritable
implements Writable {
    GenericRecord record;
    private BinaryDecoder binaryDecoder;
    private UID recordReaderID;

    public GenericRecord getRecord() {
        return this.record;
    }

    public void setRecord(GenericRecord record) {
        this.record = record;
    }

    public AvroGenericRecordWritable() {
    }

    public AvroGenericRecordWritable(GenericRecord record) {
        this.record = record;
    }

    public void write(DataOutput out) throws IOException {
        String schemaString = this.record.getSchema().toString(false);
        out.writeUTF(schemaString);
        this.recordReaderID.write(out);
        GenericDatumWriter gdw = new GenericDatumWriter();
        BinaryEncoder be = EncoderFactory.get().directBinaryEncoder((OutputStream)((DataOutputStream)out), null);
        gdw.setSchema(this.record.getSchema());
        gdw.write((Object)this.record, (Encoder)be);
    }

    public void readFields(DataInput in) throws IOException {
        Schema schema = Schema.parse((String)in.readUTF());
        this.recordReaderID = UID.read(in);
        this.record = new GenericData.Record(schema);
        this.binaryDecoder = DecoderFactory.defaultFactory().createBinaryDecoder((InputStream)((Object)in), this.binaryDecoder);
        GenericDatumReader gdr = new GenericDatumReader(schema);
        this.record = (GenericRecord)gdr.read((Object)this.record, (Decoder)this.binaryDecoder);
    }

    public UID getRecordReaderID() {
        return this.recordReaderID;
    }

    public void setRecordReaderID(UID recordReaderID) {
        this.recordReaderID = recordReaderID;
    }
}

