/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.DeleteTracker;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class ScanDeleteTracker
implements DeleteTracker {
    private boolean hasFamilyStamp = false;
    private long familyStamp = 0L;
    private SortedSet<Long> familyVersionStamps = new TreeSet<Long>();
    private byte[] deleteBuffer = null;
    private int deleteOffset = 0;
    private int deleteLength = 0;
    private byte deleteType = 0;
    private long deleteTimestamp = 0L;

    @Override
    public void add(Cell cell) {
        long timestamp = cell.getTimestamp();
        int qualifierOffset = cell.getQualifierOffset();
        int qualifierLength = cell.getQualifierLength();
        byte type = cell.getTypeByte();
        if (!this.hasFamilyStamp || timestamp > this.familyStamp) {
            if (type == KeyValue.Type.DeleteFamily.getCode()) {
                this.hasFamilyStamp = true;
                this.familyStamp = timestamp;
                return;
            }
            if (type == KeyValue.Type.DeleteFamilyVersion.getCode()) {
                this.familyVersionStamps.add(timestamp);
                return;
            }
            if (this.deleteBuffer != null && type < this.deleteType && Bytes.equals((byte[])this.deleteBuffer, (int)this.deleteOffset, (int)this.deleteLength, (byte[])cell.getQualifierArray(), (int)qualifierOffset, (int)qualifierLength)) {
                return;
            }
            this.deleteBuffer = cell.getQualifierArray();
            this.deleteOffset = qualifierOffset;
            this.deleteLength = qualifierLength;
            this.deleteType = type;
            this.deleteTimestamp = timestamp;
        }
    }

    @Override
    public DeleteTracker.DeleteResult isDeleted(Cell cell) {
        long timestamp = cell.getTimestamp();
        int qualifierOffset = cell.getQualifierOffset();
        int qualifierLength = cell.getQualifierLength();
        if (this.hasFamilyStamp && timestamp <= this.familyStamp) {
            return DeleteTracker.DeleteResult.FAMILY_DELETED;
        }
        if (this.familyVersionStamps.contains(timestamp)) {
            return DeleteTracker.DeleteResult.FAMILY_VERSION_DELETED;
        }
        if (this.deleteBuffer != null) {
            int ret = Bytes.compareTo((byte[])this.deleteBuffer, (int)this.deleteOffset, (int)this.deleteLength, (byte[])cell.getQualifierArray(), (int)qualifierOffset, (int)qualifierLength);
            if (ret == 0) {
                if (this.deleteType == KeyValue.Type.DeleteColumn.getCode()) {
                    return DeleteTracker.DeleteResult.COLUMN_DELETED;
                }
                if (timestamp == this.deleteTimestamp) {
                    return DeleteTracker.DeleteResult.VERSION_DELETED;
                }
                assert (timestamp < this.deleteTimestamp);
                this.deleteBuffer = null;
            } else if (ret < 0) {
                this.deleteBuffer = null;
            } else {
                throw new IllegalStateException("isDelete failed: deleteBuffer=" + Bytes.toStringBinary((byte[])this.deleteBuffer, (int)this.deleteOffset, (int)this.deleteLength) + ", qualifier=" + Bytes.toStringBinary((byte[])cell.getQualifierArray(), (int)qualifierOffset, (int)qualifierLength) + ", timestamp=" + timestamp + ", comparison result: " + ret);
            }
        }
        return DeleteTracker.DeleteResult.NOT_DELETED;
    }

    @Override
    public boolean isEmpty() {
        return this.deleteBuffer == null && !this.hasFamilyStamp && this.familyVersionStamps.isEmpty();
    }

    @Override
    public void reset() {
        this.hasFamilyStamp = false;
        this.familyStamp = 0L;
        this.familyVersionStamps.clear();
        this.deleteBuffer = null;
    }

    @Override
    public void update() {
        this.reset();
    }
}

