/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;
import com.google.protobuf.Service;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.EndpointObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.regionserver.DeleteTracker;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

public class RegionCoprocessorHost
extends CoprocessorHost<RegionEnvironment> {
    private static final Log LOG = LogFactory.getLog(RegionCoprocessorHost.class);
    private static ReferenceMap sharedDataMap = new ReferenceMap(0, 2);
    RegionServerServices rsServices;
    HRegion region;

    public RegionCoprocessorHost(HRegion region, RegionServerServices rsServices, Configuration conf) {
        super((Abortable)rsServices);
        this.conf = conf;
        this.rsServices = rsServices;
        this.region = region;
        this.pathPrefix = Integer.toString(this.region.getRegionInfo().hashCode());
        this.loadSystemCoprocessors(conf, "hbase.coprocessor.region.classes");
        if (!region.getRegionInfo().getTable().isSystemTable()) {
            this.loadSystemCoprocessors(conf, "hbase.coprocessor.user.region.classes");
        }
        this.loadTableCoprocessors(conf);
    }

    void loadTableCoprocessors(Configuration conf) {
        ArrayList<RegionEnvironment> configured = new ArrayList<RegionEnvironment>();
        for (Map.Entry e : this.region.getTableDesc().getValues().entrySet()) {
            String key = Bytes.toString((byte[])((ImmutableBytesWritable)e.getKey()).get()).trim();
            String spec = Bytes.toString((byte[])((ImmutableBytesWritable)e.getValue()).get()).trim();
            if (!HConstants.CP_HTD_ATTR_KEY_PATTERN.matcher(key).matches()) continue;
            try {
                Matcher matcher = HConstants.CP_HTD_ATTR_VALUE_PATTERN.matcher(spec);
                if (matcher.matches()) {
                    Configuration ourConf;
                    Path path = matcher.group(1).trim().isEmpty() ? null : new Path(matcher.group(1).trim());
                    String className = matcher.group(2).trim();
                    int priority = matcher.group(3).trim().isEmpty() ? 0x3FFFFFFF : Integer.valueOf(matcher.group(3));
                    String cfgSpec = null;
                    try {
                        cfgSpec = matcher.group(4);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        // empty catch block
                    }
                    if (cfgSpec != null) {
                        cfgSpec = cfgSpec.substring(cfgSpec.indexOf(124) + 1);
                        ourConf = new Configuration(false);
                        HBaseConfiguration.merge((Configuration)ourConf, (Configuration)conf);
                        Matcher m = HConstants.CP_HTD_ATTR_VALUE_PARAM_PATTERN.matcher(cfgSpec);
                        while (m.find()) {
                            ourConf.set(m.group(1), m.group(2));
                        }
                    } else {
                        ourConf = conf;
                    }
                    try {
                        RegionEnvironment env = (RegionEnvironment)this.load(path, className, priority, ourConf);
                        configured.add(env);
                        LOG.info((Object)("Loaded coprocessor " + className + " from HTD of " + this.region.getTableDesc().getTableName().getNameAsString() + " successfully."));
                    }
                    catch (Throwable t) {
                        if (conf.getBoolean("hbase.coprocessor.abortonerror", true)) {
                            this.abortServer(className, t);
                            continue;
                        }
                        LOG.error((Object)("Failed to load coprocessor " + className), t);
                    }
                    continue;
                }
                LOG.error((Object)("Malformed table coprocessor specification: key=" + key + ", spec: " + spec));
            }
            catch (Exception ioe) {
                LOG.error((Object)("Malformed table coprocessor specification: key=" + key + ", spec: " + spec));
            }
        }
        this.coprocessors.addAll(configured);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegionEnvironment createEnvironment(Class<?> implClass, Coprocessor instance, int priority, int seq, Configuration conf) {
        ConcurrentHashMap<String, Object> classData;
        for (Class<?> c : implClass.getInterfaces()) {
            if (!CoprocessorService.class.isAssignableFrom(c)) continue;
            this.region.registerService(((CoprocessorService)instance).getService());
        }
        ReferenceMap referenceMap = sharedDataMap;
        synchronized (referenceMap) {
            classData = (ConcurrentHashMap<String, Object>)sharedDataMap.get((Object)implClass.getName());
            if (classData == null) {
                classData = new ConcurrentHashMap<String, Object>();
                sharedDataMap.put((Object)implClass.getName(), classData);
            }
        }
        return new RegionEnvironment(instance, priority, seq, conf, this.region, this.rsServices, classData);
    }

    private void handleCoprocessorThrowableNoRethrow(CoprocessorEnvironment env, Throwable e) {
        try {
            this.handleCoprocessorThrowable(env, e);
        }
        catch (IOException ioe) {
            LOG.warn((Object)("handleCoprocessorThrowable() threw an IOException while attempting to handle Throwable " + e + ". Ignoring."), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preOpen() throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).preOpen(ctx);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postOpen() {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).postOpen(ctx);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowableNoRethrow(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postLogReplay() {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).postLogReplay(ctx);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowableNoRethrow(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preClose(boolean abortRequested) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).preClose(ctx, abortRequested);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postClose(boolean abortRequested) {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (env.getInstance() instanceof RegionObserver) {
                ctx = ObserverContext.createAndPrepare(env, ctx);
                Thread currentThread = Thread.currentThread();
                ClassLoader cl = currentThread.getContextClassLoader();
                try {
                    currentThread.setContextClassLoader(env.getClassLoader());
                    ((RegionObserver)env.getInstance()).postClose(ctx, abortRequested);
                }
                catch (Throwable e) {
                    this.handleCoprocessorThrowableNoRethrow(env, e);
                }
                finally {
                    currentThread.setContextClassLoader(cl);
                }
            }
            this.shutdown(env);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalScanner preCompactScannerOpen(Store store, List<StoreFileScanner> scanners, ScanType scanType, long earliestPutTs, CompactionRequest request) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        InternalScanner s = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                s = ((RegionObserver)env.getInstance()).preCompactScannerOpen(ctx, store, scanners, scanType, earliestPutTs, s, request);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preCompactSelection(Store store, List<StoreFile> candidates, CompactionRequest request) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        boolean bypass = false;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).preCompactSelection(ctx, store, candidates, request);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCompactSelection(Store store, ImmutableList<StoreFile> selected, CompactionRequest request) {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).postCompactSelection(ctx, store, selected, request);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowableNoRethrow(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalScanner preCompact(Store store, InternalScanner scanner, ScanType scanType, CompactionRequest request) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        boolean bypass = false;
        InternalScanner s = scanner;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                s = ((RegionObserver)env.getInstance()).preCompact(ctx, store, s, scanType, request);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass ? null : s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCompact(Store store, StoreFile resultFile, CompactionRequest request) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).postCompact(ctx, store, resultFile, request);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalScanner preFlush(Store store, InternalScanner scanner) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        boolean bypass = false;
        InternalScanner s = scanner;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                s = ((RegionObserver)env.getInstance()).preFlush(ctx, store, s);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass ? null : s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preFlush() throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).preFlush(ctx);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalScanner preFlushScannerOpen(Store store, KeyValueScanner memstoreScanner) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        InternalScanner s = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                s = ((RegionObserver)env.getInstance()).preFlushScannerOpen(ctx, store, memstoreScanner, s);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postFlush() throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).postFlush(ctx);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postFlush(Store store, StoreFile storeFile) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).postFlush(ctx, store, storeFile);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSplit() throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).preSplit(ctx);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSplit(byte[] splitRow) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).preSplit(ctx, splitRow);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSplit(HRegion l, HRegion r) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).postSplit(ctx, l, r);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preSplitBeforePONR(byte[] splitKey, List<Mutation> metaEntries) throws IOException {
        boolean bypass = false;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).preSplitBeforePONR(ctx, splitKey, metaEntries);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSplitAfterPONR() throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).preSplitAfterPONR(ctx);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preRollBackSplit() throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).preRollBackSplit(ctx);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRollBackSplit() throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).postRollBackSplit(ctx);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCompleteSplit() throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).postCompleteSplit(ctx);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preGetClosestRowBefore(byte[] row, byte[] family, Result result) throws IOException {
        boolean bypass = false;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).preGetClosestRowBefore(ctx, row, family, result);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postGetClosestRowBefore(byte[] row, byte[] family, Result result) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).postGetClosestRowBefore(ctx, row, family, result);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preGet(Get get, List<Cell> results) throws IOException {
        boolean bypass = false;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).preGetOp(ctx, get, results);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postGet(Get get, List<Cell> results) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).postGetOp(ctx, get, results);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean preExists(Get get) throws IOException {
        boolean bypass = false;
        boolean exists = false;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                exists = ((RegionObserver)env.getInstance()).preExists(ctx, get, exists);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass ? Boolean.valueOf(exists) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postExists(Get get, boolean exists) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                exists = ((RegionObserver)env.getInstance()).postExists(ctx, get, exists);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prePut(Put put, WALEdit edit, Durability durability) throws IOException {
        boolean bypass = false;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).prePut(ctx, put, edit, durability);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postPut(Put put, WALEdit edit, Durability durability) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).postPut(ctx, put, edit, durability);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preDelete(Delete delete, WALEdit edit, Durability durability) throws IOException {
        boolean bypass = false;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).preDelete(ctx, delete, edit, durability);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDelete(Delete delete, WALEdit edit, Durability durability) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).postDelete(ctx, delete, edit, durability);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preBatchMutate(MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        boolean bypass = false;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).preBatchMutate(ctx, miniBatchOp);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postBatchMutate(MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).postBatchMutate(ctx, miniBatchOp);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postBatchMutateIndispensably(MiniBatchOperationInProgress<Mutation> miniBatchOp, boolean success) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).postBatchMutateIndispensably(ctx, miniBatchOp, success);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean preCheckAndPut(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, Put put) throws IOException {
        boolean bypass = false;
        boolean result = false;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                result = ((RegionObserver)env.getInstance()).preCheckAndPut(ctx, row, family, qualifier, compareOp, comparator, put, result);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass ? Boolean.valueOf(result) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postCheckAndPut(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, Put put, boolean result) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                result = ((RegionObserver)env.getInstance()).postCheckAndPut(ctx, row, family, qualifier, compareOp, comparator, put, result);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean preCheckAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, Delete delete) throws IOException {
        boolean bypass = false;
        boolean result = false;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                result = ((RegionObserver)env.getInstance()).preCheckAndDelete(ctx, row, family, qualifier, compareOp, comparator, delete, result);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass ? Boolean.valueOf(result) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postCheckAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, Delete delete, boolean result) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                result = ((RegionObserver)env.getInstance()).postCheckAndDelete(ctx, row, family, qualifier, compareOp, comparator, delete, result);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result preAppend(Append append) throws IOException {
        boolean bypass = false;
        Result result = null;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                result = ((RegionObserver)env.getInstance()).preAppend(ctx, append);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass ? result : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result preIncrement(Increment increment) throws IOException {
        boolean bypass = false;
        Result result = null;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                result = ((RegionObserver)env.getInstance()).preIncrement(ctx, increment);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass ? result : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postAppend(Append append, Result result) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).postAppend(ctx, append, result);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result postIncrement(Increment increment, Result result) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                result = ((RegionObserver)env.getInstance()).postIncrement(ctx, increment, result);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegionScanner preScannerOpen(Scan scan) throws IOException {
        boolean bypass = false;
        RegionScanner s = null;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                s = ((RegionObserver)env.getInstance()).preScannerOpen(ctx, scan, s);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass ? s : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyValueScanner preStoreScannerOpen(Store store, Scan scan, NavigableSet<byte[]> targetCols) throws IOException {
        KeyValueScanner s = null;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                s = ((RegionObserver)env.getInstance()).preStoreScannerOpen(ctx, store, scan, targetCols, s);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegionScanner postScannerOpen(Scan scan, RegionScanner s) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                s = ((RegionObserver)env.getInstance()).postScannerOpen(ctx, scan, s);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean preScannerNext(InternalScanner s, List<Result> results, int limit) throws IOException {
        boolean bypass = false;
        boolean hasNext = false;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                hasNext = ((RegionObserver)env.getInstance()).preScannerNext(ctx, s, results, limit, hasNext);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass ? Boolean.valueOf(hasNext) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postScannerNext(InternalScanner s, List<Result> results, int limit, boolean hasMore) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                hasMore = ((RegionObserver)env.getInstance()).postScannerNext(ctx, s, results, limit, hasMore);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return hasMore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postScannerFilterRow(InternalScanner s, byte[] currentRow, int offset, short length) throws IOException {
        boolean hasMore = true;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                hasMore = ((RegionObserver)env.getInstance()).postScannerFilterRow(ctx, s, currentRow, offset, length, hasMore);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return hasMore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preScannerClose(InternalScanner s) throws IOException {
        boolean bypass = false;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).preScannerClose(ctx, s);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postScannerClose(InternalScanner s) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).postScannerClose(ctx, s);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preWALRestore(HRegionInfo info, HLogKey logKey, WALEdit logEdit) throws IOException {
        boolean bypass = false;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).preWALRestore(ctx, info, logKey, logEdit);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postWALRestore(HRegionInfo info, HLogKey logKey, WALEdit logEdit) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).postWALRestore(ctx, info, logKey, logEdit);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preBulkLoadHFile(List<Pair<byte[], String>> familyPaths) throws IOException {
        boolean bypass = false;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).preBulkLoadHFile(ctx, familyPaths);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postBulkLoadHFile(List<Pair<byte[], String>> familyPaths, boolean hasLoaded) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                hasLoaded = ((RegionObserver)env.getInstance()).postBulkLoadHFile(ctx, familyPaths, hasLoaded);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return hasLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postStartRegionOperation(HRegion.Operation op) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).postStartRegionOperation(ctx, op);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCloseRegionOperation(HRegion.Operation op) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((RegionObserver)env.getInstance()).postCloseRegionOperation(ctx, op);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreFile.Reader preStoreFileReaderOpen(FileSystem fs, Path p, FSDataInputStreamWrapper in, long size, CacheConfig cacheConf, Reference r) throws IOException {
        StoreFile.Reader reader = null;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                reader = ((RegionObserver)env.getInstance()).preStoreFileReaderOpen(ctx, fs, p, in, size, cacheConf, r, reader);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreFile.Reader postStoreFileReaderOpen(FileSystem fs, Path p, FSDataInputStreamWrapper in, long size, CacheConfig cacheConf, Reference r, StoreFile.Reader reader) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                reader = ((RegionObserver)env.getInstance()).postStoreFileReaderOpen(ctx, fs, p, in, size, cacheConf, r, reader);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cell postMutationBeforeWAL(RegionObserver.MutationType opType, Mutation mutation, Cell oldCell, Cell newCell) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                newCell = ((RegionObserver)env.getInstance()).postMutationBeforeWAL(ctx, opType, mutation, oldCell, newCell);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return newCell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message preEndpointInvocation(Service service, String methodName, Message request) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof EndpointObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                request = ((EndpointObserver)env.getInstance()).preEndpointInvocation(ctx, service, methodName, request);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postEndpointInvocation(Service service, String methodName, Message request, Message.Builder responseBuilder) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof EndpointObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ((EndpointObserver)env.getInstance()).postEndpointInvocation(ctx, service, methodName, request, responseBuilder);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeleteTracker postInstantiateDeleteTracker(DeleteTracker tracker) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                tracker = ((RegionObserver)env.getInstance()).postInstantiateDeleteTracker(ctx, tracker);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return tracker;
    }

    static class RegionEnvironment
    extends CoprocessorHost.Environment
    implements RegionCoprocessorEnvironment {
        private HRegion region;
        private RegionServerServices rsServices;
        ConcurrentMap<String, Object> sharedData;

        public RegionEnvironment(Coprocessor impl, int priority, int seq, Configuration conf, HRegion region, RegionServerServices services, ConcurrentMap<String, Object> sharedData) {
            super(impl, priority, seq, conf);
            this.region = region;
            this.rsServices = services;
            this.sharedData = sharedData;
        }

        @Override
        public HRegion getRegion() {
            return this.region;
        }

        @Override
        public RegionServerServices getRegionServerServices() {
            return this.rsServices;
        }

        @Override
        public void shutdown() {
            super.shutdown();
        }

        @Override
        public ConcurrentMap<String, Object> getSharedData() {
            return this.sharedData;
        }
    }
}

