/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.HRegionPartitioner;
import org.apache.hadoop.hbase.mapred.TableInputFormat;
import org.apache.hadoop.hbase.mapred.TableMap;
import org.apache.hadoop.hbase.mapred.TableOutputFormat;
import org.apache.hadoop.hbase.mapred.TableReduce;
import org.apache.hadoop.hbase.mapred.TableSnapshotInputFormat;
import org.apache.hadoop.hbase.mapreduce.MutationSerialization;
import org.apache.hadoop.hbase.mapreduce.ResultSerialization;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenIdentifier;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenSelector;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.security.token.Token;
import org.apache.zookeeper.KeeperException;
import org.cliffc.high_scale_lib.Counter;

@Deprecated
@InterfaceAudience.Public
@InterfaceStability.Stable
public class TableMapReduceUtil {
    public static void initTableMapJob(String table, String columns, Class<? extends TableMap> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, JobConf job) {
        TableMapReduceUtil.initTableMapJob(table, columns, mapper, outputKeyClass, outputValueClass, job, true, TableInputFormat.class);
    }

    public static void initTableMapJob(String table, String columns, Class<? extends TableMap> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, JobConf job, boolean addDependencyJars) {
        TableMapReduceUtil.initTableMapJob(table, columns, mapper, outputKeyClass, outputValueClass, job, addDependencyJars, TableInputFormat.class);
    }

    public static void initTableMapJob(String table, String columns, Class<? extends TableMap> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, JobConf job, boolean addDependencyJars, Class<? extends InputFormat> inputFormat) {
        job.setInputFormat(inputFormat);
        job.setMapOutputValueClass(outputValueClass);
        job.setMapOutputKeyClass(outputKeyClass);
        job.setMapperClass(mapper);
        job.setStrings("io.serializations", new String[]{job.get("io.serializations"), MutationSerialization.class.getName(), ResultSerialization.class.getName()});
        FileInputFormat.addInputPaths((JobConf)job, (String)table);
        job.set("hbase.mapred.tablecolumns", columns);
        if (addDependencyJars) {
            try {
                TableMapReduceUtil.addDependencyJars(job);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            TableMapReduceUtil.initCredentials(job);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static void initTableSnapshotMapJob(String snapshotName, String columns, Class<? extends TableMap> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, JobConf job, boolean addDependencyJars, Path tmpRestoreDir) throws IOException {
        TableSnapshotInputFormat.setInput(job, snapshotName, tmpRestoreDir);
        TableMapReduceUtil.initTableMapJob(snapshotName, columns, mapper, outputKeyClass, outputValueClass, job, addDependencyJars, TableSnapshotInputFormat.class);
        org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil.resetCacheConfig((Configuration)job);
        org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil.addDependencyJars((Configuration)job, Counter.class);
    }

    public static void initTableReduceJob(String table, Class<? extends TableReduce> reducer, JobConf job) throws IOException {
        TableMapReduceUtil.initTableReduceJob(table, reducer, job, null);
    }

    public static void initTableReduceJob(String table, Class<? extends TableReduce> reducer, JobConf job, Class partitioner) throws IOException {
        TableMapReduceUtil.initTableReduceJob(table, reducer, job, partitioner, true);
    }

    public static void initTableReduceJob(String table, Class<? extends TableReduce> reducer, JobConf job, Class partitioner, boolean addDependencyJars) throws IOException {
        job.setOutputFormat(TableOutputFormat.class);
        job.setReducerClass(reducer);
        job.set("hbase.mapred.outputtable", table);
        job.setOutputKeyClass(ImmutableBytesWritable.class);
        job.setOutputValueClass(Put.class);
        job.setStrings("io.serializations", new String[]{job.get("io.serializations"), MutationSerialization.class.getName(), ResultSerialization.class.getName()});
        if (partitioner == HRegionPartitioner.class) {
            job.setPartitionerClass(HRegionPartitioner.class);
            int regions = MetaReader.getRegionCount((Configuration)HBaseConfiguration.create((Configuration)job), (String)table);
            if (job.getNumReduceTasks() > regions) {
                job.setNumReduceTasks(regions);
            }
        } else if (partitioner != null) {
            job.setPartitionerClass(partitioner);
        }
        if (addDependencyJars) {
            TableMapReduceUtil.addDependencyJars(job);
        }
        TableMapReduceUtil.initCredentials(job);
    }

    public static void initCredentials(JobConf job) throws IOException {
        UserProvider userProvider = UserProvider.instantiate((Configuration)job);
        if (userProvider.isHadoopSecurityEnabled() && System.getenv("HADOOP_TOKEN_FILE_LOCATION") != null) {
            job.set("mapreduce.job.credentials.binary", System.getenv("HADOOP_TOKEN_FILE_LOCATION"));
        }
        if (userProvider.isHBaseSecurityEnabled()) {
            try {
                User user = userProvider.getCurrent();
                Token<AuthenticationTokenIdentifier> authToken = TableMapReduceUtil.getAuthToken((Configuration)job, user);
                if (authToken == null) {
                    user.obtainAuthTokenForJob(job);
                } else {
                    job.getCredentials().addToken(authToken.getService(), authToken);
                }
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
                Thread.currentThread().interrupt();
            }
        }
    }

    private static Token<AuthenticationTokenIdentifier> getAuthToken(Configuration conf, User user) throws IOException, InterruptedException {
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(conf, "mr-init-credentials", null);
        try {
            String clusterId = ZKClusterId.readClusterIdZNode((ZooKeeperWatcher)zkw);
            Token token = new AuthenticationTokenSelector().selectToken(new Text(clusterId), user.getUGI().getTokens());
            return token;
        }
        catch (KeeperException e) {
            throw new IOException(e);
        }
        finally {
            zkw.close();
        }
    }

    public static void limitNumReduceTasks(String table, JobConf job) throws IOException {
        int regions = MetaReader.getRegionCount((Configuration)HBaseConfiguration.create((Configuration)job), (String)table);
        if (job.getNumReduceTasks() > regions) {
            job.setNumReduceTasks(regions);
        }
    }

    public static void limitNumMapTasks(String table, JobConf job) throws IOException {
        int regions = MetaReader.getRegionCount((Configuration)HBaseConfiguration.create((Configuration)job), (String)table);
        if (job.getNumMapTasks() > regions) {
            job.setNumMapTasks(regions);
        }
    }

    public static void setNumReduceTasks(String table, JobConf job) throws IOException {
        job.setNumReduceTasks(MetaReader.getRegionCount((Configuration)HBaseConfiguration.create((Configuration)job), (String)table));
    }

    public static void setNumMapTasks(String table, JobConf job) throws IOException {
        job.setNumMapTasks(MetaReader.getRegionCount((Configuration)HBaseConfiguration.create((Configuration)job), (String)table));
    }

    public static void setScannerCaching(JobConf job, int batchSize) {
        job.setInt("hbase.client.scanner.caching", batchSize);
    }

    public static void addDependencyJars(JobConf job) throws IOException {
        org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil.addHBaseDependencyJars((Configuration)job);
        org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil.addDependencyJars((Configuration)job, job.getMapOutputKeyClass(), job.getMapOutputValueClass(), job.getOutputKeyClass(), job.getOutputValueClass(), job.getPartitionerClass(), job.getClass("mapred.input.format.class", TextInputFormat.class, InputFormat.class), job.getClass("mapred.output.format.class", TextOutputFormat.class, OutputFormat.class), job.getCombinerClass());
    }
}

