/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlFilter;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.access.TableAuthManager;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.TestTableName;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestCellACLWithMultipleVersions
extends SecureTestUtil {
    private static final Log LOG = LogFactory.getLog(TestCellACLWithMultipleVersions.class);
    @Rule
    public TestTableName TEST_TABLE = new TestTableName();
    private static final HBaseTestingUtility TEST_UTIL;
    private static final byte[] TEST_FAMILY1;
    private static final byte[] TEST_FAMILY2;
    private static final byte[] TEST_ROW;
    private static final byte[] TEST_Q1;
    private static final byte[] TEST_Q2;
    private static final byte[] ZERO;
    private static final byte[] ONE;
    private static final byte[] TWO;
    private static Configuration conf;
    private static User USER_OWNER;
    private static User USER_OTHER;
    private static User USER_OTHER2;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        TestCellACLWithMultipleVersions.enableSecurity(conf);
        TestCellACLWithMultipleVersions.verifyConfiguration(conf);
        conf.setBoolean("hbase.security.access.early_out", false);
        TEST_UTIL.startMiniCluster();
        MasterCoprocessorHost cpHost = TEST_UTIL.getMiniHBaseCluster().getMaster().getCoprocessorHost();
        cpHost.load(AccessController.class, 0, conf);
        AccessController ac = (AccessController)cpHost.findCoprocessor(AccessController.class.getName());
        cpHost.createEnvironment(AccessController.class, (Coprocessor)ac, 0, 1, conf);
        RegionServerCoprocessorHost rsHost = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0).getCoprocessorHost();
        rsHost.createEnvironment(AccessController.class, (Coprocessor)ac, 0, 1, conf);
        TEST_UTIL.waitTableEnabled(AccessControlLists.ACL_TABLE_NAME.getName());
        USER_OWNER = User.createUserForTesting((Configuration)conf, (String)"owner", (String[])new String[0]);
        USER_OTHER = User.createUserForTesting((Configuration)conf, (String)"other", (String[])new String[0]);
        USER_OTHER2 = User.createUserForTesting((Configuration)conf, (String)"other2", (String[])new String[0]);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor htd = new HTableDescriptor(this.TEST_TABLE.getTableName());
        HColumnDescriptor hcd = new HColumnDescriptor(TEST_FAMILY1);
        hcd.setMaxVersions(4);
        htd.setOwner(USER_OWNER);
        htd.addFamily(hcd);
        hcd = new HColumnDescriptor(TEST_FAMILY2);
        hcd.setMaxVersions(4);
        htd.setOwner(USER_OWNER);
        htd.addFamily(hcd);
        admin.createTable(htd, (byte[][])new byte[][]{Bytes.toBytes((String)"s")});
        TEST_UTIL.waitTableEnabled(this.TEST_TABLE.getTableName().getName());
    }

    @Test
    public void testCellPermissionwithVersions() throws Exception {
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Put p = new Put(TEST_ROW).add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.setACL(USER_OTHER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.WRITE}));
                    t.put(p);
                    p = new Put(TEST_ROW).add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.setACL(USER_OTHER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ}));
                    t.put(p);
                    p = new Put(TEST_ROW).add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.setACL(USER_OTHER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.WRITE}));
                    t.put(p);
                    p = new Put(TEST_ROW).add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.setACL(USER_OTHER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ}));
                    t.put(p);
                    p = new Put(TEST_ROW).add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.setACL(USER_OTHER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.WRITE}));
                    t.put(p);
                }
                finally {
                    t.close();
                }
                return null;
            }
        }, USER_OWNER);
        SecureTestUtil.AccessTestAction getQ1 = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Get get = new Get(TEST_ROW);
                get.setMaxVersions(10);
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    List list = t.get(get).listCells();
                    return list;
                }
                finally {
                    t.close();
                }
            }
        };
        SecureTestUtil.AccessTestAction get2 = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Get get = new Get(TEST_ROW);
                get.setMaxVersions(10);
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    List list = t.get(get).listCells();
                    return list;
                }
                finally {
                    t.close();
                }
            }
        };
        TestCellACLWithMultipleVersions.verifyAllowed(USER_OTHER, getQ1, 2);
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Put p = new Put(TEST_ROW).add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.setACL(USER_OTHER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.WRITE}));
                    t.put(p);
                    p = new Put(TEST_ROW).add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.setACL(USER_OTHER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ}));
                    t.put(p);
                    p = new Put(TEST_ROW).add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.setACL(USER_OTHER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.WRITE}));
                    t.put(p);
                }
                finally {
                    t.close();
                }
                return null;
            }
        }, USER_OWNER);
        TestCellACLWithMultipleVersions.verifyAllowed(USER_OTHER, get2, 1);
    }

    @Test
    public void testCellPermissionsWithDeleteMutipleVersions() throws Exception {
        final byte[] TEST_ROW1 = Bytes.toBytes((String)"r1");
        final byte[] TEST_ROW2 = Bytes.toBytes((String)"r2");
        final byte[] TEST_Q1 = Bytes.toBytes((String)"q1");
        final byte[] TEST_Q2 = Bytes.toBytes((String)"q2");
        final byte[] ZERO = Bytes.toBytes((long)0L);
        final User user1 = User.createUserForTesting((Configuration)conf, (String)"user1", (String[])new String[0]);
        final User user2 = User.createUserForTesting((Configuration)conf, (String)"user2", (String[])new String[0]);
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Put p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.add(TEST_FAMILY1, TEST_Q2, ZERO);
                    p.setACL(user1.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    t.put(p);
                    p = new Put(TEST_ROW2);
                    p.add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.add(TEST_FAMILY1, TEST_Q2, ZERO);
                    p.setACL(user1.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    t.put(p);
                }
                finally {
                    t.close();
                }
                return null;
            }
        }, USER_OWNER);
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Put p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.add(TEST_FAMILY1, TEST_Q2, ZERO);
                    HashMap<String, Permission> perms = new HashMap<String, Permission>();
                    perms.put(user1.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    perms.put(user2.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    p.setACL(perms);
                    t.put(p);
                    p = new Put(TEST_ROW2);
                    p.add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.add(TEST_FAMILY1, TEST_Q2, ZERO);
                    p.setACL(perms);
                    t.put(p);
                }
                finally {
                    t.close();
                }
                return null;
            }
        }, user1);
        user1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Delete d = new Delete(TEST_ROW1);
                    d.deleteColumns(TEST_FAMILY1, TEST_Q1);
                    d.deleteColumns(TEST_FAMILY1, TEST_Q2);
                    t.delete(d);
                }
                finally {
                    t.close();
                }
                return null;
            }
        });
        user2.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Delete d = new Delete(TEST_ROW2);
                    d.deleteColumns(TEST_FAMILY1, TEST_Q1);
                    d.deleteColumns(TEST_FAMILY1, TEST_Q2);
                    t.delete(d);
                    Assert.fail((String)"user2 should not be allowed to delete the row");
                }
                catch (Exception exception) {
                }
                finally {
                    t.close();
                }
                return null;
            }
        });
        user1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Delete d = new Delete(TEST_ROW2);
                    d.deleteFamily(TEST_FAMILY1);
                    t.delete(d);
                }
                finally {
                    t.close();
                }
                return null;
            }
        });
    }

    @Test
    public void testDeleteWithFutureTimestamp() throws Exception {
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Put p = new Put(TEST_ROW).add(TEST_FAMILY1, TEST_Q1, EnvironmentEdgeManager.currentTimeMillis() + 1000000L, ZERO);
                    p.setACL(USER_OTHER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ}));
                    t.put(p);
                    p = new Put(TEST_ROW).add(TEST_FAMILY1, TEST_Q2, ONE);
                    p.setACL(USER_OTHER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    t.put(p);
                }
                finally {
                    t.close();
                }
                return null;
            }
        }, USER_OWNER);
        SecureTestUtil.AccessTestAction getQ1 = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Get get = new Get(TEST_ROW).addColumn(TEST_FAMILY1, TEST_Q1);
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    List list = t.get(get).listCells();
                    return list;
                }
                finally {
                    t.close();
                }
            }
        };
        SecureTestUtil.AccessTestAction getQ2 = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Get get = new Get(TEST_ROW).addColumn(TEST_FAMILY1, TEST_Q2);
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    List list = t.get(get).listCells();
                    return list;
                }
                finally {
                    t.close();
                }
            }
        };
        TestCellACLWithMultipleVersions.verifyAllowed(getQ1, USER_OWNER, USER_OTHER);
        TestCellACLWithMultipleVersions.verifyAllowed(getQ2, USER_OWNER, USER_OTHER);
        SecureTestUtil.AccessTestAction deleteFamily = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Delete delete = new Delete(TEST_ROW).deleteFamily(TEST_FAMILY1);
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    t.delete(delete);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        TestCellACLWithMultipleVersions.verifyAllowed(deleteFamily, USER_OTHER);
        TestCellACLWithMultipleVersions.verifyAllowed(getQ1, USER_OWNER, USER_OTHER);
        TestCellACLWithMultipleVersions.verifyDenied(getQ2, USER_OTHER);
    }

    @Test
    public void testCellPermissionsWithDeleteWithUserTs() throws Exception {
        USER_OWNER.runAs((PrivilegedExceptionAction)new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Put p = new Put(TEST_ROW);
                    p.add(TEST_FAMILY1, TEST_Q1, 123L, ZERO);
                    p.add(TEST_FAMILY1, TEST_Q2, 123L, ZERO);
                    HashMap<String, Permission> perms = new HashMap<String, Permission>();
                    perms.put(USER_OTHER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    perms.put(USER_OTHER2.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    p.setACL(perms);
                    t.put(p);
                    p = new Put(TEST_ROW);
                    p.add(TEST_FAMILY1, TEST_Q1, 125L, ONE);
                    p.add(TEST_FAMILY1, TEST_Q2, 125L, ONE);
                    perms = new HashMap();
                    perms.put(USER_OTHER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    p.setACL(perms);
                    t.put(p);
                    p = new Put(TEST_ROW);
                    p.add(TEST_FAMILY1, TEST_Q1, 127L, TWO);
                    p.add(TEST_FAMILY1, TEST_Q2, 127L, TWO);
                    perms = new HashMap();
                    perms.put(USER_OTHER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    p.setACL(perms);
                    t.put(p);
                    Object var4_4 = null;
                    return var4_4;
                }
                finally {
                    t.close();
                }
            }
        });
        USER_OTHER2.runAs((PrivilegedExceptionAction)new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Delete d = new Delete(TEST_ROW, 124L);
                    d.deleteColumns(TEST_FAMILY1, TEST_Q1);
                    t.delete(d);
                }
                finally {
                    t.close();
                }
                return null;
            }
        });
        USER_OTHER2.runAs((PrivilegedExceptionAction)new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Delete d = new Delete(TEST_ROW);
                    d.deleteColumns(TEST_FAMILY1, TEST_Q2, 124L);
                    t.delete(d);
                }
                finally {
                    t.close();
                }
                return null;
            }
        });
    }

    @Test
    public void testCellPermissionsWithDeleteExactVersion() throws Exception {
        final byte[] TEST_ROW1 = Bytes.toBytes((String)"r1");
        final byte[] TEST_Q1 = Bytes.toBytes((String)"q1");
        final byte[] TEST_Q2 = Bytes.toBytes((String)"q2");
        final byte[] ZERO = Bytes.toBytes((long)0L);
        final User user1 = User.createUserForTesting((Configuration)conf, (String)"user1", (String[])new String[0]);
        final User user2 = User.createUserForTesting((Configuration)conf, (String)"user2", (String[])new String[0]);
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    HashMap<String, Permission> permsU1andOwner = new HashMap<String, Permission>();
                    permsU1andOwner.put(user1.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    permsU1andOwner.put(USER_OWNER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    HashMap<String, Permission> permsU2andOwner = new HashMap<String, Permission>();
                    permsU2andOwner.put(user2.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    permsU2andOwner.put(USER_OWNER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    Put p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, 123L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q2, 123L, ZERO);
                    p.setACL(permsU2andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY2, TEST_Q1, 123L, ZERO);
                    p.add(TEST_FAMILY2, TEST_Q2, 123L, ZERO);
                    p.setACL(permsU2andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY2, TEST_Q1, 125L, ZERO);
                    p.add(TEST_FAMILY2, TEST_Q2, 125L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, 127L, ZERO);
                    p.setACL(permsU2andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q2, 127L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY2, TEST_Q1, 129L, ZERO);
                    p.add(TEST_FAMILY2, TEST_Q2, 129L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                }
                finally {
                    t.close();
                }
                return null;
            }
        }, USER_OWNER);
        user1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Delete d = new Delete(TEST_ROW1);
                    d.deleteColumn(TEST_FAMILY1, TEST_Q1, 123L);
                    d.deleteColumn(TEST_FAMILY1, TEST_Q2);
                    d.deleteFamilyVersion(TEST_FAMILY2, 125L);
                    t.delete(d);
                }
                finally {
                    t.close();
                }
                return null;
            }
        });
        user2.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Delete d = new Delete(TEST_ROW1, 127L);
                    d.deleteColumns(TEST_FAMILY1, TEST_Q1);
                    d.deleteColumns(TEST_FAMILY1, TEST_Q2);
                    d.deleteFamily(TEST_FAMILY2, 129L);
                    t.delete(d);
                    Assert.fail((String)"user2 can not do the delete");
                }
                catch (Exception exception) {
                }
                finally {
                    t.close();
                }
                return null;
            }
        });
    }

    @Test
    public void testCellPermissionsForIncrementWithMultipleVersions() throws Exception {
        final byte[] TEST_ROW1 = Bytes.toBytes((String)"r1");
        final byte[] TEST_Q1 = Bytes.toBytes((String)"q1");
        final byte[] TEST_Q2 = Bytes.toBytes((String)"q2");
        final byte[] ZERO = Bytes.toBytes((long)0L);
        final User user1 = User.createUserForTesting((Configuration)conf, (String)"user1", (String[])new String[0]);
        final User user2 = User.createUserForTesting((Configuration)conf, (String)"user2", (String[])new String[0]);
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    HashMap<String, Permission> permsU1andOwner = new HashMap<String, Permission>();
                    permsU1andOwner.put(user1.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    permsU1andOwner.put(USER_OWNER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    HashMap<String, Permission> permsU2andOwner = new HashMap<String, Permission>();
                    permsU2andOwner.put(user2.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    permsU2andOwner.put(USER_OWNER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    Put p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, 123L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q2, 123L, ZERO);
                    p.setACL(permsU2andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, 127L, ZERO);
                    p.setACL(permsU2andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q2, 127L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                }
                finally {
                    t.close();
                }
                return null;
            }
        }, USER_OWNER);
        user1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Increment inc = new Increment(TEST_ROW1);
                    inc.setTimeRange(0L, 123L);
                    inc.addColumn(TEST_FAMILY1, TEST_Q1, 2L);
                    t.increment(inc);
                    t.incrementColumnValue(TEST_ROW1, TEST_FAMILY1, TEST_Q2, 1L);
                }
                finally {
                    t.close();
                }
                return null;
            }
        });
        user2.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Increment inc = new Increment(TEST_ROW1);
                    inc.setTimeRange(0L, 127L);
                    inc.addColumn(TEST_FAMILY1, TEST_Q2, 2L);
                    t.increment(inc);
                    Assert.fail();
                }
                catch (Exception exception) {
                }
                finally {
                    t.close();
                }
                return null;
            }
        });
    }

    @Test
    public void testCellPermissionsForPutWithMultipleVersions() throws Exception {
        final byte[] TEST_ROW1 = Bytes.toBytes((String)"r1");
        final byte[] TEST_Q1 = Bytes.toBytes((String)"q1");
        final byte[] TEST_Q2 = Bytes.toBytes((String)"q2");
        final byte[] ZERO = Bytes.toBytes((long)0L);
        final User user1 = User.createUserForTesting((Configuration)conf, (String)"user1", (String[])new String[0]);
        final User user2 = User.createUserForTesting((Configuration)conf, (String)"user2", (String[])new String[0]);
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    HashMap<String, Permission> permsU1andOwner = new HashMap<String, Permission>();
                    permsU1andOwner.put(user1.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    permsU1andOwner.put(USER_OWNER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    HashMap<String, Permission> permsU2andOwner = new HashMap<String, Permission>();
                    permsU2andOwner.put(user2.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    permsU2andOwner.put(USER_OWNER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    Put p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, 123L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q2, 123L, ZERO);
                    p.setACL(permsU2andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, 127L, ZERO);
                    p.setACL(permsU2andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q2, 127L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                }
                finally {
                    t.close();
                }
                return null;
            }
        }, USER_OWNER);
        user1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Put p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, 125L, ZERO);
                    p.add(TEST_FAMILY1, TEST_Q2, ZERO);
                    p.setACL(user2.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    t.put(p);
                }
                finally {
                    t.close();
                }
                return null;
            }
        });
        user2.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Put p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, 124L, ZERO);
                    p.add(TEST_FAMILY1, TEST_Q2, ZERO);
                    t.put(p);
                    Assert.fail();
                }
                catch (Exception exception) {
                }
                finally {
                    t.close();
                }
                return null;
            }
        });
    }

    @Test
    public void testCellPermissionsForCheckAndDelete() throws Exception {
        final byte[] TEST_ROW1 = Bytes.toBytes((String)"r1");
        final byte[] ZERO = Bytes.toBytes((long)0L);
        final User user1 = User.createUserForTesting((Configuration)conf, (String)"user1", (String[])new String[0]);
        final User user2 = User.createUserForTesting((Configuration)conf, (String)"user2", (String[])new String[0]);
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    HashMap<String, Permission> permsU1andOwner = new HashMap<String, Permission>();
                    permsU1andOwner.put(user1.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    permsU1andOwner.put(USER_OWNER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    HashMap<String, Permission> permsU1andU2andOwner = new HashMap<String, Permission>();
                    permsU1andU2andOwner.put(user1.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    permsU1andU2andOwner.put(user2.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    permsU1andU2andOwner.put(USER_OWNER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    HashMap<String, Permission> permsU1andU2 = new HashMap<String, Permission>();
                    permsU1andU2.put(user1.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    permsU1andU2.put(user2.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    Put p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, 120L, ZERO);
                    p.add(TEST_FAMILY1, TEST_Q2, 120L, ZERO);
                    p.setACL(permsU1andU2andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, 123L, ZERO);
                    p.add(TEST_FAMILY1, TEST_Q2, 123L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, 127L, ZERO);
                    p.setACL(permsU1andU2);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q2, 127L, ZERO);
                    p.setACL(user2.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ}));
                    t.put(p);
                }
                finally {
                    t.close();
                }
                return null;
            }
        }, USER_OWNER);
        user1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Delete d = new Delete(TEST_ROW1);
                    d.deleteColumns(TEST_FAMILY1, TEST_Q1);
                    t.checkAndDelete(TEST_ROW1, TEST_FAMILY1, TEST_Q1, ZERO, d);
                }
                finally {
                    t.close();
                }
                return null;
            }
        });
        user2.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Delete d = new Delete(TEST_ROW1);
                    d.deleteColumns(TEST_FAMILY1, TEST_Q1);
                    t.checkAndDelete(TEST_ROW1, TEST_FAMILY1, TEST_Q1, ZERO, d);
                    Assert.fail((String)"user2 should not be allowed to do checkAndDelete");
                }
                catch (Exception exception) {
                }
                finally {
                    t.close();
                }
                return null;
            }
        });
        user2.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Delete d = new Delete(TEST_ROW1);
                    d.deleteColumn(TEST_FAMILY1, TEST_Q2, 120L);
                    t.checkAndDelete(TEST_ROW1, TEST_FAMILY1, TEST_Q2, ZERO, d);
                }
                finally {
                    t.close();
                }
                return null;
            }
        });
    }

    @After
    public void tearDown() throws Exception {
        try {
            TEST_UTIL.deleteTable(this.TEST_TABLE.getTableName());
        }
        catch (TableNotFoundException ex) {
            LOG.info((Object)("Test deleted table " + this.TEST_TABLE.getTableName()));
        }
        Assert.assertEquals((long)0L, (long)AccessControlLists.getTablePermissions((Configuration)conf, (TableName)this.TEST_TABLE.getTableName()).size());
    }

    static {
        Logger.getLogger(AccessController.class).setLevel(Level.TRACE);
        Logger.getLogger(AccessControlFilter.class).setLevel(Level.TRACE);
        Logger.getLogger(TableAuthManager.class).setLevel(Level.TRACE);
        TEST_UTIL = new HBaseTestingUtility();
        TEST_FAMILY1 = Bytes.toBytes((String)"f1");
        TEST_FAMILY2 = Bytes.toBytes((String)"f2");
        TEST_ROW = Bytes.toBytes((String)"cellpermtest");
        TEST_Q1 = Bytes.toBytes((String)"q1");
        TEST_Q2 = Bytes.toBytes((String)"q2");
        ZERO = Bytes.toBytes((long)0L);
        ONE = Bytes.toBytes((long)1L);
        TWO = Bytes.toBytes((long)2L);
    }
}

