/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionAlreadyInTransitionException;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.handler.OpenRegionHandler;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRegionServerNoMaster {
    private static final int NB_SERVERS = 1;
    private static HTable table;
    private static final byte[] row;
    private static HRegionInfo hri;
    private static byte[] regionName;
    private static final HBaseTestingUtility HTU;

    @BeforeClass
    public static void before() throws Exception {
        HTU.startMiniCluster(1);
        byte[] tableName = Bytes.toBytes((String)TestRegionServerNoMaster.class.getSimpleName());
        table = HTU.createTable(tableName, HConstants.CATALOG_FAMILY);
        Put p = new Put(row);
        p.add(HConstants.CATALOG_FAMILY, row, row);
        table.put(p);
        hri = table.getRegionLocation(row, false).getRegionInfo();
        regionName = hri.getRegionName();
        HTU.getHBaseCluster().getMaster().stopMaster();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        table.close();
        HTU.shutdownMiniCluster();
    }

    @After
    public void after() throws Exception {
        ZKAssign.deleteNodeFailSilent((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (HRegionInfo)hri);
    }

    private static HRegionServer getRS() {
        return HTU.getHBaseCluster().getLiveRegionServerThreads().get(0).getRegionServer();
    }

    private void reopenRegion() throws Exception {
        ZKAssign.createNodeOffline((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (HRegionInfo)hri, (ServerName)TestRegionServerNoMaster.getRS().getServerName());
        AdminProtos.OpenRegionRequest orr = RequestConverter.buildOpenRegionRequest((ServerName)TestRegionServerNoMaster.getRS().getServerName(), (HRegionInfo)hri, (int)0, null);
        AdminProtos.OpenRegionResponse responseOpen = TestRegionServerNoMaster.getRS().openRegion(null, orr);
        Assert.assertTrue((responseOpen.getOpeningStateCount() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)responseOpen.getOpeningState(0).equals((Object)AdminProtos.OpenRegionResponse.RegionOpeningState.OPENED));
        this.checkRegionIsOpened();
    }

    private void checkRegionIsOpened() throws Exception {
        while (!TestRegionServerNoMaster.getRS().getRegionsInTransitionInRS().isEmpty()) {
            Thread.sleep(1L);
        }
        Assert.assertTrue((boolean)TestRegionServerNoMaster.getRS().getRegion(regionName).isAvailable());
        Assert.assertTrue((boolean)ZKAssign.deleteOpenedNode((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (String)hri.getEncodedName(), (ServerName)TestRegionServerNoMaster.getRS().getServerName()));
    }

    private void checkRegionIsClosed() throws Exception {
        while (!TestRegionServerNoMaster.getRS().getRegionsInTransitionInRS().isEmpty()) {
            Thread.sleep(1L);
        }
        try {
            Assert.assertFalse((boolean)TestRegionServerNoMaster.getRS().getRegion(regionName).isAvailable());
        }
        catch (NotServingRegionException notServingRegionException) {
            // empty catch block
        }
    }

    private void closeNoZK() throws Exception {
        AdminProtos.CloseRegionRequest crr = RequestConverter.buildCloseRegionRequest((ServerName)TestRegionServerNoMaster.getRS().getServerName(), (byte[])regionName, (boolean)false);
        AdminProtos.CloseRegionResponse responseClose = TestRegionServerNoMaster.getRS().closeRegion(null, crr);
        Assert.assertTrue((boolean)responseClose.getClosed());
        this.checkRegionIsClosed();
    }

    @Test(timeout=60000L)
    public void testCloseByRegionServer() throws Exception {
        this.closeNoZK();
        this.reopenRegion();
    }

    @Test(timeout=60000L)
    public void testCloseByMasterWithoutZNode() throws Exception {
        AdminProtos.CloseRegionRequest crr = RequestConverter.buildCloseRegionRequest((ServerName)TestRegionServerNoMaster.getRS().getServerName(), (byte[])regionName, (boolean)true);
        AdminProtos.CloseRegionResponse responseClose = TestRegionServerNoMaster.getRS().closeRegion(null, crr);
        Assert.assertTrue((boolean)responseClose.getClosed());
        while (!TestRegionServerNoMaster.getRS().getRegionsInTransitionInRS().isEmpty()) {
            Thread.sleep(1L);
        }
        Assert.assertTrue((String)"The close should have failed", (boolean)TestRegionServerNoMaster.getRS().getRegion(regionName).isAvailable());
    }

    @Test(timeout=60000L)
    public void testOpenCloseByMasterWithZNode() throws Exception {
        ZKAssign.createNodeClosing((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (HRegionInfo)hri, (ServerName)TestRegionServerNoMaster.getRS().getServerName());
        AdminProtos.CloseRegionRequest crr = RequestConverter.buildCloseRegionRequest((ServerName)TestRegionServerNoMaster.getRS().getServerName(), (byte[])regionName, (boolean)true);
        AdminProtos.CloseRegionResponse responseClose = TestRegionServerNoMaster.getRS().closeRegion(null, crr);
        Assert.assertTrue((boolean)responseClose.getClosed());
        this.checkRegionIsClosed();
        ZKAssign.deleteClosedNode((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (String)hri.getEncodedName(), (ServerName)TestRegionServerNoMaster.getRS().getServerName());
        this.reopenRegion();
    }

    @Test(timeout=60000L)
    public void testMultipleOpen() throws Exception {
        this.closeNoZK();
        this.checkRegionIsClosed();
        ZKAssign.createNodeOffline((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (HRegionInfo)hri, (ServerName)TestRegionServerNoMaster.getRS().getServerName());
        for (int i = 0; i < 10; ++i) {
            AdminProtos.OpenRegionRequest orr = RequestConverter.buildOpenRegionRequest((ServerName)TestRegionServerNoMaster.getRS().getServerName(), (HRegionInfo)hri, (int)0, null);
            AdminProtos.OpenRegionResponse responseOpen = TestRegionServerNoMaster.getRS().openRegion(null, orr);
            Assert.assertTrue((responseOpen.getOpeningStateCount() == 1 ? 1 : 0) != 0);
            AdminProtos.OpenRegionResponse.RegionOpeningState ors = responseOpen.getOpeningState(0);
            Assert.assertTrue((String)("request " + i + " failed"), (ors.equals((Object)AdminProtos.OpenRegionResponse.RegionOpeningState.OPENED) || ors.equals((Object)AdminProtos.OpenRegionResponse.RegionOpeningState.ALREADY_OPENED) ? 1 : 0) != 0);
        }
        this.checkRegionIsOpened();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOpenClosingRegion() throws Exception {
        Assert.assertTrue((boolean)TestRegionServerNoMaster.getRS().getRegion(regionName).isAvailable());
        try {
            TestRegionServerNoMaster.getRS().regionsInTransitionInRS.put(hri.getEncodedNameAsBytes(), Boolean.FALSE);
            AdminProtos.OpenRegionRequest orr = RequestConverter.buildOpenRegionRequest((ServerName)TestRegionServerNoMaster.getRS().getServerName(), (HRegionInfo)hri, (int)0, null);
            TestRegionServerNoMaster.getRS().openRegion(null, orr);
            Assert.fail((String)"The closing region should not be opened");
        }
        catch (ServiceException se) {
            Assert.assertTrue((String)"The region should be already in transition", (boolean)(se.getCause() instanceof RegionAlreadyInTransitionException));
        }
        finally {
            TestRegionServerNoMaster.getRS().regionsInTransitionInRS.remove(hri.getEncodedNameAsBytes());
        }
    }

    @Test(timeout=60000L)
    public void testMultipleCloseFromMaster() throws Exception {
        ZKAssign.createNodeClosing((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (HRegionInfo)hri, (ServerName)TestRegionServerNoMaster.getRS().getServerName());
        for (int i = 0; i < 10; ++i) {
            AdminProtos.CloseRegionRequest crr = RequestConverter.buildCloseRegionRequest((ServerName)TestRegionServerNoMaster.getRS().getServerName(), (byte[])regionName, (int)0, null, (boolean)true);
            try {
                AdminProtos.CloseRegionResponse responseClose = TestRegionServerNoMaster.getRS().closeRegion(null, crr);
                Assert.assertEquals((String)"The first request should succeeds", (long)0L, (long)i);
                Assert.assertTrue((String)("request " + i + " failed"), (responseClose.getClosed() || responseClose.hasClosed() ? 1 : 0) != 0);
                continue;
            }
            catch (ServiceException se) {
                Assert.assertTrue((String)"The next queries should throw an exception.", (i > 0 ? 1 : 0) != 0);
            }
        }
        this.checkRegionIsClosed();
        Assert.assertTrue((boolean)ZKAssign.deleteClosedNode((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (String)hri.getEncodedName(), (ServerName)TestRegionServerNoMaster.getRS().getServerName()));
        this.reopenRegion();
    }

    @Test(timeout=60000L)
    public void testCancelOpeningWithoutZK() throws Exception {
        this.closeNoZK();
        this.checkRegionIsClosed();
        ZKAssign.createNodeOffline((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (HRegionInfo)hri, (ServerName)TestRegionServerNoMaster.getRS().getServerName());
        TestRegionServerNoMaster.getRS().getRegionsInTransitionInRS().put(hri.getEncodedNameAsBytes(), Boolean.TRUE);
        AdminProtos.CloseRegionRequest crr = RequestConverter.buildCloseRegionRequest((ServerName)TestRegionServerNoMaster.getRS().getServerName(), (byte[])regionName, (boolean)false);
        try {
            TestRegionServerNoMaster.getRS().closeRegion(null, crr);
            Assert.assertTrue((boolean)false);
        }
        catch (ServiceException expected) {
            // empty catch block
        }
        Assert.assertEquals((Object)Boolean.FALSE, TestRegionServerNoMaster.getRS().getRegionsInTransitionInRS().get(hri.getEncodedNameAsBytes()));
        HTableDescriptor htd = TestRegionServerNoMaster.getRS().tableDescriptors.get(hri.getTable());
        TestRegionServerNoMaster.getRS().service.submit((EventHandler)new OpenRegionHandler((Server)TestRegionServerNoMaster.getRS(), (RegionServerServices)TestRegionServerNoMaster.getRS(), hri, htd, 0));
        this.checkRegionIsClosed();
        Assert.assertTrue((boolean)ZKAssign.deleteNode((ZooKeeperWatcher)TestRegionServerNoMaster.getRS().getZooKeeperWatcher(), (String)hri.getEncodedName(), (EventType)EventType.RS_ZK_REGION_FAILED_OPEN, (int)1));
        this.reopenRegion();
    }

    @Test(timeout=60000L)
    public void testCancelOpeningWithZK() throws Exception {
        this.closeNoZK();
        this.checkRegionIsClosed();
        TestRegionServerNoMaster.getRS().getRegionsInTransitionInRS().put(hri.getEncodedNameAsBytes(), Boolean.TRUE);
        ZKAssign.createNodeClosing((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (HRegionInfo)hri, (ServerName)TestRegionServerNoMaster.getRS().getServerName());
        AdminProtos.CloseRegionRequest crr = RequestConverter.buildCloseRegionRequest((ServerName)TestRegionServerNoMaster.getRS().getServerName(), (byte[])regionName, (boolean)false);
        try {
            TestRegionServerNoMaster.getRS().closeRegion(null, crr);
            Assert.assertTrue((boolean)false);
        }
        catch (ServiceException expected) {
            Assert.assertTrue((boolean)(expected.getCause() instanceof NotServingRegionException));
        }
        Assert.assertTrue((boolean)ZKAssign.deleteNode((ZooKeeperWatcher)TestRegionServerNoMaster.getRS().getZooKeeperWatcher(), (String)hri.getEncodedName(), (EventType)EventType.M_ZK_REGION_CLOSING, (int)0));
        Assert.assertEquals((Object)Boolean.FALSE, TestRegionServerNoMaster.getRS().getRegionsInTransitionInRS().get(hri.getEncodedNameAsBytes()));
        HTableDescriptor htd = TestRegionServerNoMaster.getRS().tableDescriptors.get(hri.getTable());
        TestRegionServerNoMaster.getRS().service.submit((EventHandler)new OpenRegionHandler((Server)TestRegionServerNoMaster.getRS(), (RegionServerServices)TestRegionServerNoMaster.getRS(), hri, htd, 0));
        this.checkRegionIsClosed();
        Assert.assertEquals((long)-1L, (long)ZKAssign.getVersion((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (HRegionInfo)hri));
        this.reopenRegion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOpenCloseRegionRPCIntendedForPreviousServer() throws Exception {
        Assert.assertTrue((boolean)TestRegionServerNoMaster.getRS().getRegion(regionName).isAvailable());
        ServerName sn = TestRegionServerNoMaster.getRS().getServerName();
        ServerName earlierServerName = ServerName.valueOf((String)sn.getHostname(), (int)sn.getPort(), (long)1L);
        try {
            AdminProtos.CloseRegionRequest request = RequestConverter.buildCloseRegionRequest((ServerName)earlierServerName, (byte[])regionName, (boolean)true);
            TestRegionServerNoMaster.getRS().closeRegion(null, request);
            Assert.fail((String)"The closeRegion should have been rejected");
        }
        catch (ServiceException se) {
            Assert.assertTrue((boolean)(se.getCause() instanceof IOException));
            Assert.assertTrue((boolean)se.getCause().getMessage().contains("This RPC was intended for a different server"));
        }
        this.closeNoZK();
        try {
            AdminProtos.OpenRegionRequest orr = RequestConverter.buildOpenRegionRequest((ServerName)earlierServerName, (HRegionInfo)hri, (int)0, null);
            TestRegionServerNoMaster.getRS().openRegion(null, orr);
            Assert.fail((String)"The openRegion should have been rejected");
        }
        catch (ServiceException se) {
            Assert.assertTrue((boolean)(se.getCause() instanceof IOException));
            Assert.assertTrue((boolean)se.getCause().getMessage().contains("This RPC was intended for a different server"));
        }
        finally {
            this.reopenRegion();
        }
    }

    static {
        row = "ee".getBytes();
        HTU = new HBaseTestingUtility();
    }
}

