/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.protobuf.ByteString;
import com.google.protobuf.HBaseZeroCopyByteString;
import com.google.protobuf.Message;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.regionserver.AnnotationReadingPriorityFunction;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestPriorityRpc {
    private HRegionServer regionServer = null;
    private PriorityFunction priority = null;

    @Before
    public void setup() {
        Configuration conf = HBaseConfiguration.create();
        this.regionServer = HRegionServer.constructRegionServer(HRegionServer.class, (Configuration)conf);
        this.priority = this.regionServer.getPriority();
    }

    @Test
    public void testQosFunctionForMeta() throws IOException {
        this.priority = this.regionServer.getPriority();
        RPCProtos.RequestHeader.Builder headerBuilder = RPCProtos.RequestHeader.newBuilder();
        headerBuilder.setMethodName("foo");
        ClientProtos.GetRequest.Builder getRequestBuilder = ClientProtos.GetRequest.newBuilder();
        HBaseProtos.RegionSpecifier.Builder regionSpecifierBuilder = HBaseProtos.RegionSpecifier.newBuilder();
        regionSpecifierBuilder.setType(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME);
        ByteString name = HBaseZeroCopyByteString.wrap((byte[])HRegionInfo.FIRST_META_REGIONINFO.getRegionName());
        regionSpecifierBuilder.setValue(name);
        HBaseProtos.RegionSpecifier regionSpecifier = regionSpecifierBuilder.build();
        getRequestBuilder.setRegion(regionSpecifier);
        ClientProtos.Get.Builder getBuilder = ClientProtos.Get.newBuilder();
        getBuilder.setRow(HBaseZeroCopyByteString.wrap((byte[])"somerow".getBytes()));
        getRequestBuilder.setGet(getBuilder.build());
        ClientProtos.GetRequest getRequest = getRequestBuilder.build();
        RPCProtos.RequestHeader header = headerBuilder.build();
        HRegion mockRegion = (HRegion)Mockito.mock(HRegion.class);
        HRegionServer mockRS = (HRegionServer)Mockito.mock(HRegionServer.class);
        HRegionInfo mockRegionInfo = (HRegionInfo)Mockito.mock(HRegionInfo.class);
        Mockito.when((Object)mockRS.getRegion((HBaseProtos.RegionSpecifier)Mockito.any())).thenReturn((Object)mockRegion);
        Mockito.when((Object)mockRegion.getRegionInfo()).thenReturn((Object)mockRegionInfo);
        Mockito.when((Object)mockRegionInfo.isMetaTable()).thenReturn((Object)true);
        ((AnnotationReadingPriorityFunction)this.priority).setRegionServer(mockRS);
        Assert.assertEquals((long)100L, (long)this.priority.getPriority(header, (Message)getRequest));
    }

    @Test
    public void testQosFunctionWithoutKnownArgument() throws IOException {
        RPCProtos.RequestHeader.Builder headerBuilder = RPCProtos.RequestHeader.newBuilder();
        headerBuilder.setMethodName("foo");
        RPCProtos.RequestHeader header = headerBuilder.build();
        PriorityFunction qosFunc = this.regionServer.getPriority();
        Assert.assertEquals((long)0L, (long)qosFunc.getPriority(header, null));
    }

    @Test
    public void testQosFunctionForScanMethod() throws IOException {
        RPCProtos.RequestHeader.Builder headerBuilder = RPCProtos.RequestHeader.newBuilder();
        headerBuilder.setMethodName("Scan");
        RPCProtos.RequestHeader header = headerBuilder.build();
        ClientProtos.ScanRequest.Builder scanBuilder = ClientProtos.ScanRequest.newBuilder();
        ClientProtos.ScanRequest scanRequest = scanBuilder.build();
        HRegion mockRegion = (HRegion)Mockito.mock(HRegion.class);
        HRegionServer mockRS = (HRegionServer)Mockito.mock(HRegionServer.class);
        HRegionInfo mockRegionInfo = (HRegionInfo)Mockito.mock(HRegionInfo.class);
        Mockito.when((Object)mockRS.getRegion((HBaseProtos.RegionSpecifier)Mockito.any())).thenReturn((Object)mockRegion);
        Mockito.when((Object)mockRegion.getRegionInfo()).thenReturn((Object)mockRegionInfo);
        Mockito.when((Object)mockRegionInfo.isMetaRegion()).thenReturn((Object)false);
        ((AnnotationReadingPriorityFunction)this.priority).setRegionServer(mockRS);
        int qos = this.priority.getPriority(header, (Message)scanRequest);
        Assert.assertTrue((String)("" + qos), (qos == 0 ? 1 : 0) != 0);
        scanBuilder = ClientProtos.ScanRequest.newBuilder();
        scanBuilder.setScannerId(12345L);
        scanRequest = scanBuilder.build();
        RegionScanner mockRegionScanner = (RegionScanner)Mockito.mock(RegionScanner.class);
        Mockito.when((Object)mockRS.getScanner(12345L)).thenReturn((Object)mockRegionScanner);
        Mockito.when((Object)mockRegionScanner.getRegionInfo()).thenReturn((Object)mockRegionInfo);
        Mockito.when((Object)mockRS.getRegion((HBaseProtos.RegionSpecifier)Mockito.any())).thenReturn((Object)mockRegion);
        Mockito.when((Object)mockRegion.getRegionInfo()).thenReturn((Object)mockRegionInfo);
        Mockito.when((Object)mockRegionInfo.isMetaRegion()).thenReturn((Object)true);
        ((AnnotationReadingPriorityFunction)this.priority).setRegionServer(mockRS);
        Assert.assertEquals((long)100L, (long)this.priority.getPriority(header, (Message)scanRequest));
        Mockito.when((Object)mockRegionInfo.isMetaRegion()).thenReturn((Object)false);
        Assert.assertEquals((long)0L, (long)this.priority.getPriority(header, (Message)scanRequest));
    }
}

