/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.CachedBlock;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.KeyValueSkipListSet;
import org.apache.hadoop.hbase.regionserver.MemStore;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.util.ClassSize;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestHeapSize {
    static final Log LOG = LogFactory.getLog(TestHeapSize.class);

    @BeforeClass
    public static void beforeClass() throws Exception {
        RuntimeMXBean b = ManagementFactory.getRuntimeMXBean();
        LOG.info((Object)("name=" + b.getName()));
        LOG.info((Object)("specname=" + b.getSpecName()));
        LOG.info((Object)("specvendor=" + b.getSpecVendor()));
        LOG.info((Object)("vmname=" + b.getVmName()));
        LOG.info((Object)("vmversion=" + b.getVmVersion()));
        LOG.info((Object)("vmvendor=" + b.getVmVendor()));
        Map<String, String> p = b.getSystemProperties();
        LOG.info((Object)("properties=" + p));
    }

    @Test
    public void testNativeSizes() throws IOException {
        long actual;
        Class cl = ArrayList.class;
        long expected = ClassSize.estimateBase(cl, (boolean)false);
        if (expected != (actual = (long)ClassSize.ARRAYLIST)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = ByteBuffer.class, (boolean)false)) != (actual = (long)ClassSize.BYTE_BUFFER)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = Integer.class, (boolean)false)) != (actual = (long)ClassSize.INTEGER)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = Object.class, (boolean)false)) != (actual = (long)ClassSize.OBJECT)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = TreeMap.class, (boolean)false)) != (actual = (long)ClassSize.TREEMAP)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = String.class, (boolean)false)) != (actual = (long)ClassSize.STRING)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = ConcurrentHashMap.class, (boolean)false)) != (actual = (long)ClassSize.CONCURRENT_HASHMAP)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = ConcurrentSkipListMap.class, (boolean)false)) != (actual = (long)ClassSize.CONCURRENT_SKIPLISTMAP)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = ReentrantReadWriteLock.class, (boolean)false)) != (actual = (long)ClassSize.REENTRANT_LOCK)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = AtomicLong.class, (boolean)false)) != (actual = (long)ClassSize.ATOMIC_LONG)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = AtomicInteger.class, (boolean)false)) != (actual = (long)ClassSize.ATOMIC_INTEGER)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = AtomicBoolean.class, (boolean)false)) != (actual = (long)ClassSize.ATOMIC_BOOLEAN)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = CopyOnWriteArraySet.class, (boolean)false)) != (actual = (long)ClassSize.COPYONWRITE_ARRAYSET)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = CopyOnWriteArrayList.class, (boolean)false)) != (actual = (long)ClassSize.COPYONWRITE_ARRAYLIST)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = TimeRangeTracker.class, (boolean)false)) != (actual = (long)ClassSize.TIMERANGE_TRACKER)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = KeyValueSkipListSet.class, (boolean)false)) != (actual = (long)ClassSize.KEYVALUE_SKIPLIST_SET)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
    }

    @Test
    public void testSizes() throws IOException {
        KeyValue kv;
        long actual;
        Class<KeyValue> cl = KeyValue.class;
        long expected = ClassSize.estimateBase(cl, (boolean)false);
        if (expected != (actual = (kv = new KeyValue()).heapSize())) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        cl = LruBlockCache.class;
        actual = LruBlockCache.CACHE_FIXED_OVERHEAD;
        expected = ClassSize.estimateBase(cl, (boolean)false);
        if (expected != actual) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        cl = CachedBlock.class;
        actual = CachedBlock.PER_BLOCK_OVERHEAD;
        expected = ClassSize.estimateBase(cl, (boolean)false);
        expected += ClassSize.estimateBase(String.class, (boolean)false);
        if ((expected += ClassSize.estimateBase(ByteBuffer.class, (boolean)false)) != actual) {
            ClassSize.estimateBase(cl, (boolean)true);
            ClassSize.estimateBase(String.class, (boolean)true);
            ClassSize.estimateBase(ByteBuffer.class, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        cl = MemStore.class;
        actual = MemStore.FIXED_OVERHEAD;
        expected = ClassSize.estimateBase(cl, (boolean)false);
        if (expected != actual) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        actual = MemStore.DEEP_OVERHEAD;
        expected = ClassSize.estimateBase(cl, (boolean)false);
        expected += ClassSize.estimateBase(AtomicLong.class, (boolean)false);
        expected += 2L * ClassSize.estimateBase(KeyValueSkipListSet.class, (boolean)false);
        expected += 2L * ClassSize.estimateBase(ConcurrentSkipListMap.class, (boolean)false);
        if ((expected += 2L * ClassSize.estimateBase(TimeRangeTracker.class, (boolean)false)) != actual) {
            ClassSize.estimateBase(cl, (boolean)true);
            ClassSize.estimateBase(AtomicLong.class, (boolean)true);
            ClassSize.estimateBase(KeyValueSkipListSet.class, (boolean)true);
            ClassSize.estimateBase(KeyValueSkipListSet.class, (boolean)true);
            ClassSize.estimateBase(ConcurrentSkipListMap.class, (boolean)true);
            ClassSize.estimateBase(ConcurrentSkipListMap.class, (boolean)true);
            ClassSize.estimateBase(TimeRangeTracker.class, (boolean)true);
            ClassSize.estimateBase(TimeRangeTracker.class, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        cl = HStore.class;
        actual = HStore.FIXED_OVERHEAD;
        expected = ClassSize.estimateBase(cl, (boolean)false);
        if (expected != actual) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        cl = HRegion.class;
        actual = HRegion.FIXED_OVERHEAD;
        expected = ClassSize.estimateBase(cl, (boolean)false);
        if (expected != actual) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        cl = BlockCacheKey.class;
        actual = new BlockCacheKey("", 0L).heapSize();
        expected = ClassSize.estimateBase(cl, (boolean)false);
        if (expected != actual) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
    }

    @Test
    public void testMutations() {
        Class<TimeRange> cl = TimeRange.class;
        long actual = ClassSize.TIMERANGE;
        long expected = ClassSize.estimateBase(cl, (boolean)false);
        if (expected != actual) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        byte[] row = new byte[]{0};
        cl = Put.class;
        new Put(row);
        actual = Put.MUTATION_OVERHEAD + (long)ClassSize.align((int)ClassSize.ARRAY);
        expected = ClassSize.estimateBase(cl, (boolean)false);
        if ((expected += (long)ClassSize.align((int)ClassSize.TREEMAP)) != actual) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        cl = Delete.class;
        new Delete(row);
        actual = Delete.MUTATION_OVERHEAD + (long)ClassSize.align((int)ClassSize.ARRAY);
        expected = ClassSize.estimateBase(cl, (boolean)false);
        if ((expected += (long)ClassSize.align((int)ClassSize.TREEMAP)) != actual) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
    }
}

