/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.TableAuthManager;

class AccessControlFilter
extends FilterBase {
    private TableAuthManager authManager;
    private TableName table;
    private User user;

    AccessControlFilter() {
    }

    AccessControlFilter(TableAuthManager mgr, User ugi, TableName tableName) {
        this.authManager = mgr;
        this.table = tableName;
        this.user = ugi;
    }

    public Filter.ReturnCode filterKeyValue(Cell c) {
        KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)c);
        if (this.authManager.authorize(this.user, this.table, kv, Permission.Action.READ)) {
            return Filter.ReturnCode.INCLUDE;
        }
        return Filter.ReturnCode.NEXT_COL;
    }

    public byte[] toByteArray() {
        throw new UnsupportedOperationException("Serialization not supported.  Intended for server-side use only.");
    }

    public static AccessControlFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        throw new UnsupportedOperationException("Serialization not supported.  Intended for server-side use only.");
    }
}

