/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.NoOpDataBlockEncoder;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class HFileDataBlockEncoderImpl
implements HFileDataBlockEncoder {
    private final DataBlockEncoding onDisk;
    private final DataBlockEncoding inCache;
    private final byte[] dummyHeader;

    public HFileDataBlockEncoderImpl(DataBlockEncoding encoding) {
        this(encoding, encoding);
    }

    public HFileDataBlockEncoderImpl(DataBlockEncoding onDisk, DataBlockEncoding inCache) {
        this(onDisk, inCache, HConstants.HFILEBLOCK_DUMMY_HEADER);
    }

    public HFileDataBlockEncoderImpl(DataBlockEncoding onDisk, DataBlockEncoding inCache, byte[] dummyHeader) {
        this.onDisk = onDisk != null ? onDisk : DataBlockEncoding.NONE;
        this.inCache = inCache != null ? inCache : DataBlockEncoding.NONE;
        this.dummyHeader = dummyHeader;
        Preconditions.checkArgument((onDisk == DataBlockEncoding.NONE || onDisk == inCache ? 1 : 0) != 0, (Object)("on-disk encoding (" + onDisk + ") must be " + "either the same as in-cache encoding (" + inCache + ") or " + DataBlockEncoding.NONE));
    }

    public static HFileDataBlockEncoder createFromFileInfo(HFile.FileInfo fileInfo, DataBlockEncoding preferredEncodingInCache) throws IOException {
        DataBlockEncoding onDisk;
        boolean hasPreferredCacheEncoding = preferredEncodingInCache != null && preferredEncodingInCache != DataBlockEncoding.NONE;
        byte[] dataBlockEncodingType = fileInfo.get(DATA_BLOCK_ENCODING);
        if (dataBlockEncodingType == null && !hasPreferredCacheEncoding) {
            return NoOpDataBlockEncoder.INSTANCE;
        }
        if (dataBlockEncodingType == null) {
            onDisk = DataBlockEncoding.NONE;
        } else {
            String dataBlockEncodingStr = Bytes.toString((byte[])dataBlockEncodingType);
            try {
                onDisk = DataBlockEncoding.valueOf((String)dataBlockEncodingStr);
            }
            catch (IllegalArgumentException ex) {
                throw new IOException("Invalid data block encoding type in file info: " + dataBlockEncodingStr, ex);
            }
        }
        DataBlockEncoding inCache = onDisk == DataBlockEncoding.NONE ? preferredEncodingInCache : onDisk;
        return new HFileDataBlockEncoderImpl(onDisk, inCache);
    }

    @Override
    public void saveMetadata(HFile.Writer writer) throws IOException {
        writer.appendFileInfo(DATA_BLOCK_ENCODING, this.onDisk.getNameInBytes());
    }

    @Override
    public DataBlockEncoding getEncodingOnDisk() {
        return this.onDisk;
    }

    @Override
    public DataBlockEncoding getEncodingInCache() {
        return this.inCache;
    }

    @Override
    public DataBlockEncoding getEffectiveEncodingInCache(boolean isCompaction) {
        if (!this.useEncodedScanner(isCompaction)) {
            return DataBlockEncoding.NONE;
        }
        return this.inCache;
    }

    @Override
    public HFileBlock diskToCacheFormat(HFileBlock block, boolean isCompaction) {
        if (block.getBlockType() == BlockType.DATA) {
            if (!this.useEncodedScanner(isCompaction)) {
                return block;
            }
            return this.encodeDataBlock(block, this.inCache, block.doesIncludeMemstoreTS(), this.createInCacheEncodingContext());
        }
        if (block.getBlockType() == BlockType.ENCODED_DATA) {
            if (block.getDataBlockEncodingId() == this.onDisk.getId()) {
                return block;
            }
            throw new AssertionError((Object)("Expected on-disk data block encoding " + this.onDisk + ", got " + block.getDataBlockEncoding()));
        }
        return block;
    }

    @Override
    public void beforeWriteToDisk(ByteBuffer in, boolean includesMemstoreTS, HFileBlockEncodingContext encodeCtx, BlockType blockType) throws IOException {
        if (this.onDisk == DataBlockEncoding.NONE) {
            ((HFileBlockDefaultEncodingContext)encodeCtx).compressAfterEncodingWithBlockType(in.array(), blockType);
            return;
        }
        this.encodeBufferToHFileBlockBuffer(in, this.onDisk, includesMemstoreTS, encodeCtx);
    }

    @Override
    public boolean useEncodedScanner(boolean isCompaction) {
        if (isCompaction && this.onDisk == DataBlockEncoding.NONE) {
            return false;
        }
        return this.inCache != DataBlockEncoding.NONE;
    }

    private void encodeBufferToHFileBlockBuffer(ByteBuffer in, DataBlockEncoding algo, boolean includesMemstoreTS, HFileBlockEncodingContext encodeCtx) {
        DataBlockEncoder encoder = algo.getEncoder();
        try {
            encoder.encodeKeyValues(in, includesMemstoreTS, encodeCtx);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Bug in data block encoder '%s', it probably requested too much data, exception message: %s.", algo.toString(), e.getMessage()), e);
        }
    }

    private HFileBlock encodeDataBlock(HFileBlock block, DataBlockEncoding algo, boolean includesMemstoreTS, HFileBlockEncodingContext encodingCtx) {
        encodingCtx.setDummyHeader(block.getDummyHeaderForVersion());
        this.encodeBufferToHFileBlockBuffer(block.getBufferWithoutHeader(), algo, includesMemstoreTS, encodingCtx);
        byte[] encodedUncompressedBytes = encodingCtx.getUncompressedBytesWithHeader();
        ByteBuffer bufferWrapper = ByteBuffer.wrap(encodedUncompressedBytes);
        int sizeWithoutHeader = bufferWrapper.limit() - block.headerSize();
        HFileBlock encodedBlock = new HFileBlock(BlockType.ENCODED_DATA, block.getOnDiskSizeWithoutHeader(), sizeWithoutHeader, block.getPrevBlockOffset(), bufferWrapper, true, block.getOffset(), includesMemstoreTS, block.getMinorVersion(), block.getBytesPerChecksum(), block.getChecksumType(), block.getOnDiskDataSizeWithHeader());
        return encodedBlock;
    }

    private HFileBlockEncodingContext createInCacheEncodingContext() {
        return this.inCache != DataBlockEncoding.NONE ? this.inCache.getEncoder().newDataBlockEncodingContext(Compression.Algorithm.NONE, this.inCache, this.dummyHeader) : new HFileBlockDefaultEncodingContext(Compression.Algorithm.NONE, this.inCache, this.dummyHeader);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(onDisk=" + this.onDisk + ", inCache=" + this.inCache + ")";
    }

    @Override
    public HFileBlockEncodingContext newOnDiskDataBlockEncodingContext(Compression.Algorithm compressionAlgorithm, byte[] dummyHeader) {
        DataBlockEncoder encoder;
        if (this.onDisk != null && (encoder = this.onDisk.getEncoder()) != null) {
            return encoder.newDataBlockEncodingContext(compressionAlgorithm, this.onDisk, dummyHeader);
        }
        return new HFileBlockDefaultEncodingContext(compressionAlgorithm, null, dummyHeader);
    }

    @Override
    public HFileBlockDecodingContext newOnDiskDataBlockDecodingContext(Compression.Algorithm compressionAlgorithm) {
        DataBlockEncoder encoder;
        if (this.onDisk != null && (encoder = this.onDisk.getEncoder()) != null) {
            return encoder.newDataBlockDecodingContext(compressionAlgorithm);
        }
        return new HFileBlockDefaultDecodingContext(compressionAlgorithm);
    }
}

