/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureBulkLoadEndpoint;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.junit.Assert;

public class SecureTestUtil {
    public static void enableSecurity(Configuration conf) throws IOException {
        conf.set("hadoop.security.authorization", "false");
        conf.set("hadoop.security.authentication", "simple");
        conf.set("hbase.coprocessor.master.classes", AccessController.class.getName());
        conf.set("hbase.coprocessor.region.classes", AccessController.class.getName() + "," + SecureBulkLoadEndpoint.class.getName());
        String currentUser = User.getCurrent().getName();
        conf.set("hbase.superuser", "admin," + currentUser);
    }

    public void verifyAllowed(User user, PrivilegedExceptionAction ... actions) throws Exception {
        for (PrivilegedExceptionAction action : actions) {
            try {
                user.runAs(action);
            }
            catch (AccessDeniedException ade) {
                Assert.fail((String)("Expected action to pass for user '" + user.getShortName() + "' but was denied"));
            }
        }
    }

    public void verifyAllowed(PrivilegedExceptionAction action, User ... users) throws Exception {
        for (User user : users) {
            this.verifyAllowed(user, action);
        }
    }

    public void verifyDenied(User user, PrivilegedExceptionAction ... actions) throws Exception {
        for (PrivilegedExceptionAction action : actions) {
            try {
                user.runAs(action);
                Assert.fail((String)("Expected AccessDeniedException for user '" + user.getShortName() + "'"));
            }
            catch (IOException e) {
                boolean isAccessDeniedException = false;
                if (e instanceof RetriesExhaustedWithDetailsException) {
                    for (Throwable ex : ((RetriesExhaustedWithDetailsException)((Object)e)).getCauses()) {
                        if (!(ex instanceof AccessDeniedException)) continue;
                        isAccessDeniedException = true;
                        break;
                    }
                } else {
                    Throwable ex = e;
                    do {
                        if (!(ex instanceof AccessDeniedException)) continue;
                        isAccessDeniedException = true;
                        break;
                    } while ((ex = ex.getCause()) != null);
                }
                if (isAccessDeniedException) continue;
                Assert.fail((String)("Not receiving AccessDeniedException for user '" + user.getShortName() + "'"));
            }
            catch (UndeclaredThrowableException ute) {
                ServiceException se;
                Throwable ex = ute.getUndeclaredThrowable();
                if (ex instanceof PrivilegedActionException) {
                    ex = ((PrivilegedActionException)ex).getException();
                }
                if (ex instanceof ServiceException && (se = (ServiceException)ex).getCause() != null && se.getCause() instanceof AccessDeniedException) {
                    return;
                }
                Assert.fail((String)("Not receiving AccessDeniedException for user '" + user.getShortName() + "'"));
            }
        }
    }

    public void verifyDenied(PrivilegedExceptionAction action, User ... users) throws Exception {
        for (User user : users) {
            this.verifyDenied(user, action);
        }
    }

    public void checkTablePerms(Configuration conf, byte[] table, byte[] family, byte[] column, Permission.Action ... actions) throws IOException {
        Permission[] perms = new Permission[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            perms[i] = new TablePermission(TableName.valueOf((byte[])table), family, column, new Permission.Action[]{actions[i]});
        }
        this.checkTablePerms(conf, table, perms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkTablePerms(Configuration conf, byte[] table, Permission ... perms) throws IOException {
        AccessControlProtos.CheckPermissionsRequest.Builder request = AccessControlProtos.CheckPermissionsRequest.newBuilder();
        for (Permission p : perms) {
            request.addPermission(ProtobufUtil.toPermission((Permission)p));
        }
        HTable acl = new HTable(conf, table);
        try {
            AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)acl.coprocessorService(new byte[0]));
            try {
                protocol.checkPermissions(null, request.build());
            }
            catch (ServiceException se) {
                ProtobufUtil.toIOException((ServiceException)se);
            }
        }
        finally {
            acl.close();
        }
    }
}

