/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.QosFunction;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestQosFunction {
    @Test
    public void testPriority() {
        HRegionServer hrs = (HRegionServer)Mockito.mock(HRegionServer.class);
        QosFunction qosFunction = new QosFunction(hrs);
        this.checkMethod("ReplicateWALEntry", 5, qosFunction);
        this.checkMethod("OpenRegion", 100, qosFunction);
    }

    private void checkMethod(String methodName, int expected, QosFunction qosf) {
        RPCProtos.RequestHeader.Builder builder = RPCProtos.RequestHeader.newBuilder();
        builder.setMethodName(methodName);
        Pair headerAndParam = new Pair((Object)builder.build(), null);
        Assert.assertEquals((String)methodName, (long)expected, (long)qosf.apply(headerAndParam).intValue());
    }
}

