/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestJoinedScanners {
    static final Log LOG = LogFactory.getLog(TestJoinedScanners.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final String DIR = TEST_UTIL.getDataTestDir("TestJoinedScanners").toString();
    private static final byte[] cf_essential = Bytes.toBytes((String)"essential");
    private static final byte[] cf_joined = Bytes.toBytes((String)"joined");
    private static final byte[] col_name = Bytes.toBytes((String)"a");
    private static final byte[] flag_yes = Bytes.toBytes((String)"Y");
    private static final byte[] flag_no = Bytes.toBytes((String)"N");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJoinedScanners() throws Exception {
        String[] dataNodeHosts = new String[]{"host1", "host2", "host3"};
        int regionServersCount = 3;
        HBaseTestingUtility htu = new HBaseTestingUtility();
        int DEFAULT_BLOCK_SIZE = 0x100000;
        htu.getConfiguration().setLong("dfs.block.size", 0x100000L);
        htu.getConfiguration().setInt("dfs.replication", 1);
        htu.getConfiguration().setLong("hbase.hregion.max.filesize", 0x4B00000000L);
        MiniHBaseCluster cluster = null;
        try {
            cluster = htu.startMiniCluster(1, regionServersCount, dataNodeHosts);
            byte[][] families = new byte[][]{cf_essential, cf_joined};
            HTable ht = htu.createTable(Bytes.toBytes((String)this.getClass().getSimpleName()), (byte[][])families);
            long rows_to_insert = 1000L;
            int insert_batch = 20;
            int flag_percent = 1;
            int large_bytes = 131072;
            long time = System.nanoTime();
            LOG.info((Object)("Make " + Long.toString(rows_to_insert) + " rows, total size = " + Float.toString(rows_to_insert * (long)large_bytes / 1024L / 1024L) + " MB"));
            byte[] val_large = new byte[large_bytes];
            ArrayList<Put> puts = new ArrayList<Put>();
            for (long i = 0L; i < rows_to_insert; ++i) {
                Put put = new Put(Bytes.toBytes((String)Long.toString(i)));
                if (i % 100L <= (long)flag_percent) {
                    put.add(cf_essential, col_name, flag_yes);
                } else {
                    put.add(cf_essential, col_name, flag_no);
                }
                put.add(cf_joined, col_name, val_large);
                puts.add(put);
                if (puts.size() < insert_batch) continue;
                ht.put(puts);
                puts.clear();
            }
            if (puts.size() >= 0) {
                ht.put(puts);
                puts.clear();
            }
            LOG.info((Object)("Data generated in " + Double.toString((double)(System.nanoTime() - time) / 1.0E9) + " seconds"));
            boolean slow = true;
            for (int i = 0; i < 20; ++i) {
                this.runScanner(ht, slow);
                slow = !slow;
            }
            ht.close();
        }
        finally {
            if (cluster != null) {
                htu.shutdownMiniCluster();
            }
        }
    }

    private void runScanner(HTable table, boolean slow) throws Exception {
        Result res;
        long time = System.nanoTime();
        Scan scan = new Scan();
        scan.addColumn(cf_essential, col_name);
        scan.addColumn(cf_joined, col_name);
        SingleColumnValueFilter filter = new SingleColumnValueFilter(cf_essential, col_name, CompareFilter.CompareOp.EQUAL, flag_yes);
        filter.setFilterIfMissing(true);
        scan.setFilter((Filter)filter);
        scan.setLoadColumnFamiliesOnDemand(!slow);
        ResultScanner result_scanner = table.getScanner(scan);
        long rows_count = 0L;
        while ((res = result_scanner.next()) != null) {
            ++rows_count;
        }
        double timeSec = (double)(System.nanoTime() - time) / 1.0E9;
        result_scanner.close();
        LOG.info((Object)((slow ? "Slow" : "Joined") + " scanner finished in " + Double.toString(timeSec) + " seconds, got " + Long.toString(rows_count / 2L) + " rows"));
    }

    private static HRegion initHRegion(byte[] tableName, byte[] startKey, byte[] stopKey, String callingMethod, Configuration conf, byte[] ... families) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((byte[])tableName));
        for (byte[] family : families) {
            htd.addFamily(new HColumnDescriptor(family));
        }
        HRegionInfo info = new HRegionInfo(htd.getTableName(), startKey, stopKey, false);
        Path path = new Path(DIR + callingMethod);
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (fs.exists(path) && !fs.delete(path, true)) {
            throw new IOException("Failed delete of " + path);
        }
        return HRegion.createHRegion((HRegionInfo)info, (Path)path, (Configuration)conf, (HTableDescriptor)htd);
    }
}

