/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.master.snapshot.SnapshotFileCache;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.snapshot.TakeSnapshotUtils;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestSnapshotFileCache {
    private static final Log LOG = LogFactory.getLog(TestSnapshotFileCache.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static FileSystem fs;
    private static Path rootDir;

    @BeforeClass
    public static void startCluster() throws Exception {
        UTIL.startMiniDFSCluster(1);
        fs = UTIL.getDFSCluster().getFileSystem();
        rootDir = UTIL.getDefaultRootDirPath();
    }

    @AfterClass
    public static void stopCluster() throws Exception {
        UTIL.shutdownMiniDFSCluster();
    }

    @After
    public void cleanupFiles() throws Exception {
        Path snapshotDir = SnapshotDescriptionUtils.getSnapshotsDir((Path)rootDir);
        fs.delete(snapshotDir, true);
    }

    @Test(timeout=10000000L)
    public void testLoadAndDelete() throws Exception {
        long period = Long.MAX_VALUE;
        Path snapshotDir = SnapshotDescriptionUtils.getSnapshotsDir((Path)rootDir);
        SnapshotFileCache cache = new SnapshotFileCache(fs, rootDir, period, 10000000L, "test-snapshot-file-cache-refresh", (SnapshotFileCache.SnapshotFileInspector)new SnapshotFiles());
        Path snapshot = new Path(snapshotDir, "snapshot");
        Path region = new Path(snapshot, "7e91021");
        Path family = new Path(region, "fam");
        Path file1 = new Path(family, "file1");
        Path file2 = new Path(family, "file2");
        fs.create(file1);
        fs.create(file2);
        FSUtils.logFileSystemState((FileSystem)fs, (Path)rootDir, (Log)LOG);
        Assert.assertTrue((String)("Cache didn't find:" + file1), (boolean)cache.contains(file1.getName()));
        Assert.assertTrue((String)("Cache didn't find:" + file2), (boolean)cache.contains(file2.getName()));
        String not = "file-shouldn't-be-found";
        Assert.assertFalse((String)("Cache found '" + not + "', but it shouldn't have."), (boolean)cache.contains(not));
        Thread.sleep(10L);
        LOG.debug((Object)"Deleting snapshot.");
        if (!fs.delete(snapshot, true)) {
            throw new IOException("Couldn't delete " + snapshot + " for an unknown reason.");
        }
        FSUtils.logFileSystemState((FileSystem)fs, (Path)rootDir, (Log)LOG);
        LOG.debug((Object)"Checking to see if file is deleted.");
        Assert.assertTrue((String)("Cache didn't find:" + file1), (boolean)cache.contains(file1.getName()));
        Assert.assertTrue((String)("Cache didn't find:" + file2), (boolean)cache.contains(file2.getName()));
        cache.triggerCacheRefreshForTesting();
        Assert.assertFalse((String)("Cache found '" + file1 + "', but it shouldn't have."), (boolean)cache.contains(file1.getName()));
        Assert.assertFalse((String)("Cache found '" + file2 + "', but it shouldn't have."), (boolean)cache.contains(file2.getName()));
        fs.delete(snapshotDir, true);
    }

    @Test
    public void testLoadsTmpDir() throws Exception {
        long period = Long.MAX_VALUE;
        Path snapshotDir = SnapshotDescriptionUtils.getSnapshotsDir((Path)rootDir);
        SnapshotFileCache cache = new SnapshotFileCache(fs, rootDir, period, 10000000L, "test-snapshot-file-cache-refresh", (SnapshotFileCache.SnapshotFileInspector)new SnapshotFiles());
        Path snapshot = new Path(snapshotDir, "snapshot");
        Path region = new Path(snapshot, "7e91021");
        Path family = new Path(region, "fam");
        Path file1 = new Path(family, "file1");
        fs.create(file1);
        HBaseProtos.SnapshotDescription desc = HBaseProtos.SnapshotDescription.newBuilder().setName("working").build();
        snapshot = SnapshotDescriptionUtils.getWorkingSnapshotDir((HBaseProtos.SnapshotDescription)desc, (Path)rootDir);
        region = new Path(snapshot, "7e91021");
        family = new Path(region, "fam");
        Path file2 = new Path(family, "file2");
        fs.create(file2);
        FSUtils.logFileSystemState((FileSystem)fs, (Path)rootDir, (Log)LOG);
        Assert.assertTrue((String)("Cache didn't find:" + file1), (boolean)cache.contains(file1.getName()));
        Assert.assertTrue((String)("Cache didn't find:" + file2), (boolean)cache.contains(file2.getName()));
    }

    @Test
    public void testJustFindLogsDirectory() throws Exception {
        long period = Long.MAX_VALUE;
        Path snapshotDir = SnapshotDescriptionUtils.getSnapshotsDir((Path)rootDir);
        SnapshotFileCache cache = new SnapshotFileCache(fs, rootDir, period, 10000000L, "test-snapshot-file-cache-refresh", new SnapshotFileCache.SnapshotFileInspector(){

            public Collection<String> filesUnderSnapshot(Path snapshotDir) throws IOException {
                return SnapshotReferenceUtil.getHLogNames((FileSystem)fs, (Path)snapshotDir);
            }
        });
        Path snapshot = new Path(snapshotDir, "snapshot");
        Path region = new Path(snapshot, "7e91021");
        Path family = new Path(region, "fam");
        Path file1 = new Path(family, "file1");
        fs.create(file1);
        Path logs = TakeSnapshotUtils.getSnapshotHLogsDir((Path)snapshot, (String)"server");
        Path log = new Path(logs, "me.hbase.com%2C58939%2C1350424310315.1350424315552");
        fs.create(log);
        FSUtils.logFileSystemState((FileSystem)fs, (Path)rootDir, (Log)LOG);
        Assert.assertFalse((String)("Cache found '" + file1 + "', but it shouldn't have."), (boolean)cache.contains(file1.getName()));
        Assert.assertTrue((String)("Cache didn't find:" + log), (boolean)cache.contains(log.getName()));
    }

    @Test
    public void testReloadModifiedDirectory() throws IOException {
        long period = Long.MAX_VALUE;
        Path snapshotDir = SnapshotDescriptionUtils.getSnapshotsDir((Path)rootDir);
        SnapshotFileCache cache = new SnapshotFileCache(fs, rootDir, period, 10000000L, "test-snapshot-file-cache-refresh", (SnapshotFileCache.SnapshotFileInspector)new SnapshotFiles());
        Path snapshot = new Path(snapshotDir, "snapshot");
        Path region = new Path(snapshot, "7e91021");
        Path family = new Path(region, "fam");
        Path file1 = new Path(family, "file1");
        Path file2 = new Path(family, "file2");
        fs.create(file1);
        fs.create(file2);
        FSUtils.logFileSystemState((FileSystem)fs, (Path)rootDir, (Log)LOG);
        Assert.assertTrue((String)("Cache didn't find " + file1), (boolean)cache.contains(file1.getName()));
        fs.delete(snapshot, true);
        Path file3 = new Path(family, "new_file");
        fs.create(file3);
        FSUtils.logFileSystemState((FileSystem)fs, (Path)rootDir, (Log)LOG);
        Assert.assertTrue((String)("Cache didn't find new file:" + file3), (boolean)cache.contains(file3.getName()));
    }

    class SnapshotFiles
    implements SnapshotFileCache.SnapshotFileInspector {
        SnapshotFiles() {
        }

        public Collection<String> filesUnderSnapshot(Path snapshotDir) throws IOException {
            HashSet<String> files = new HashSet<String>();
            files.addAll(SnapshotReferenceUtil.getHLogNames((FileSystem)fs, (Path)snapshotDir));
            files.addAll(SnapshotReferenceUtil.getHFileNames((FileSystem)fs, (Path)snapshotDir));
            return files;
        }
    }
}

