/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import org.apache.hadoop.hbase.master.balancer.ServerAndLoad;
import org.apache.hadoop.hbase.master.balancer.TestStochasticLoadBalancer;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestBaseLoadBalancer
extends BalancerTestBase {
    private static LoadBalancer loadBalancer;
    private static final Log LOG;
    int[][] regionsAndServersMocks = new int[][]{{0, 0}, {0, 1}, {1, 1}, {2, 1}, {10, 1}, {1, 2}, {2, 2}, {3, 2}, {1, 3}, {2, 3}, {3, 3}, {25, 3}, {2, 10}, {2, 100}, {12, 10}, {12, 100}};

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        loadBalancer = new MockBalancer();
        loadBalancer.setConf(conf);
    }

    @Test
    public void testImmediateAssignment() throws Exception {
        for (int[] mock : this.regionsAndServersMocks) {
            LOG.debug((Object)("testImmediateAssignment with " + mock[0] + " regions and " + mock[1] + " servers"));
            List<HRegionInfo> regions = this.randomRegions(mock[0]);
            List<ServerAndLoad> servers = this.randomServers(mock[1], 0);
            List<ServerName> list = this.getListOfServerNames(servers);
            Map assignments = loadBalancer.immediateAssignment(regions, list);
            this.assertImmediateAssignment(regions, list, assignments);
            this.returnRegions(regions);
            this.returnServers(list);
        }
    }

    private void assertImmediateAssignment(List<HRegionInfo> regions, List<ServerName> servers, Map<HRegionInfo, ServerName> assignments) {
        for (HRegionInfo region : regions) {
            Assert.assertTrue((boolean)assignments.containsKey(region));
        }
    }

    @Test
    public void testBulkAssignment() throws Exception {
        for (int[] mock : this.regionsAndServersMocks) {
            LOG.debug((Object)("testBulkAssignment with " + mock[0] + " regions and " + mock[1] + " servers"));
            List<HRegionInfo> regions = this.randomRegions(mock[0]);
            List<ServerAndLoad> servers = this.randomServers(mock[1], 0);
            List<ServerName> list = this.getListOfServerNames(servers);
            Map assignments = loadBalancer.roundRobinAssignment(regions, list);
            float average = (float)regions.size() / (float)servers.size();
            int min = (int)Math.floor(average);
            int max = (int)Math.ceil(average);
            if (assignments != null && !assignments.isEmpty()) {
                for (List regionList : assignments.values()) {
                    Assert.assertTrue((regionList.size() == min || regionList.size() == max ? 1 : 0) != 0);
                }
            }
            this.returnRegions(regions);
            this.returnServers(list);
        }
    }

    @Test
    public void testRetainAssignment() throws Exception {
        List<ServerAndLoad> servers = this.randomServers(10, 10);
        List<HRegionInfo> regions = this.randomRegions(100);
        TreeMap<HRegionInfo, ServerName> existing = new TreeMap<HRegionInfo, ServerName>();
        for (int i = 0; i < regions.size(); ++i) {
            ServerName sn = servers.get(i % servers.size()).getServerName();
            ServerName snWithOldStartCode = new ServerName(sn.getHostname(), sn.getPort(), sn.getStartcode() - 10L);
            existing.put(regions.get(i), snWithOldStartCode);
        }
        List<ServerName> listOfServerNames = this.getListOfServerNames(servers);
        Map assignment = loadBalancer.retainAssignment(existing, listOfServerNames);
        this.assertRetainedAssignment(existing, listOfServerNames, assignment);
        ArrayList<ServerAndLoad> servers2 = new ArrayList<ServerAndLoad>(servers);
        servers2.add(this.randomServer(10));
        servers2.add(this.randomServer(10));
        listOfServerNames = this.getListOfServerNames(servers2);
        assignment = loadBalancer.retainAssignment(existing, listOfServerNames);
        this.assertRetainedAssignment(existing, listOfServerNames, assignment);
        ArrayList<ServerAndLoad> servers3 = new ArrayList<ServerAndLoad>(servers);
        servers3.remove(0);
        servers3.remove(0);
        listOfServerNames = this.getListOfServerNames(servers3);
        assignment = loadBalancer.retainAssignment(existing, listOfServerNames);
        this.assertRetainedAssignment(existing, listOfServerNames, assignment);
    }

    private List<ServerName> getListOfServerNames(List<ServerAndLoad> sals) {
        ArrayList<ServerName> list = new ArrayList<ServerName>();
        for (ServerAndLoad e : sals) {
            list.add(e.getServerName());
        }
        return list;
    }

    private void assertRetainedAssignment(Map<HRegionInfo, ServerName> existing, List<ServerName> servers, Map<ServerName, List<HRegionInfo>> assignment) {
        TreeSet<ServerName> onlineServerSet = new TreeSet<ServerName>(servers);
        TreeSet<HRegionInfo> assignedRegions = new TreeSet<HRegionInfo>();
        for (Map.Entry<ServerName, List<HRegionInfo>> a : assignment.entrySet()) {
            Assert.assertTrue((String)"Region assigned to server that was not listed as online", (boolean)onlineServerSet.contains(a.getKey()));
            for (HRegionInfo r : a.getValue()) {
                assignedRegions.add(r);
            }
        }
        Assert.assertEquals((long)existing.size(), (long)assignedRegions.size());
        TreeSet<String> onlineHostNames = new TreeSet<String>();
        for (ServerName serverName : servers) {
            onlineHostNames.add(serverName.getHostname());
        }
        for (Map.Entry entry : assignment.entrySet()) {
            ServerName assignedTo = (ServerName)entry.getKey();
            for (HRegionInfo r : (List)entry.getValue()) {
                ServerName address = existing.get(r);
                if (address == null || !onlineHostNames.contains(address.getHostname())) continue;
                Assert.assertEquals((Object)address.getHostname(), (Object)assignedTo.getHostname());
            }
        }
    }

    static {
        LOG = LogFactory.getLog(TestStochasticLoadBalancer.class);
    }

    public static class MockBalancer
    extends BaseLoadBalancer {
        public List<RegionPlan> balanceCluster(Map<ServerName, List<HRegionInfo>> clusterState) {
            return null;
        }
    }
}

